/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFileWalker;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.CoordMath;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.OverlapDetector;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.StringUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.None;

@CommandLineProgramProperties(usage="Designs baits or oligos for hybrid selection reactions.", usageShort="Designs baits or oligos for hybrid selection reactions.", programGroup=None.class)
public class BaitDesigner
extends CommandLineProgram {
    @Option(shortName="T", doc="The file with design parameters and targets")
    public File TARGETS;
    @Option(doc="The name of the bait design")
    public String DESIGN_NAME;
    @Option(shortName="R", doc="The reference sequence fasta file")
    public File REFERENCE_SEQUENCE;
    @Option(doc="The left amplification primer to prepend to all baits for synthesis")
    public String LEFT_PRIMER = "ATCGCACCAGCGTGT";
    @Option(doc="The right amplification primer to prepend to all baits for synthesis")
    public String RIGHT_PRIMER = "CACTGCGGCTCCTCA";
    @Option(doc="The design strategy to use to layout baits across each target")
    public DesignStrategy DESIGN_STRATEGY = DesignStrategy.FixedOffset;
    @Option(doc="The length of each individual bait to design")
    public int BAIT_SIZE = 120;
    @Option(doc="The minimum number of baits to design per target.")
    public int MINIMUM_BAITS_PER_TARGET = 2;
    @Option(doc="The desired offset between the start of one bait and the start of another bait for the same target.")
    public int BAIT_OFFSET = 80;
    @Option(doc="Pad the input targets by this amount when designing baits. Padding is applied on both sides in this amount.")
    public int PADDING = 0;
    @Option(doc="Baits that have more than REPEAT_TOLERANCE soft or hard masked bases will not be allowed")
    public int REPEAT_TOLERANCE = 50;
    @Option(doc="The size of pools or arrays for synthesis. If no pool files are desired, can be set to 0.")
    public int POOL_SIZE = 55000;
    @Option(doc="If true, fill up the pools with alternating fwd and rc copies of all baits. Equal copies of all baits will always be maintained")
    public boolean FILL_POOLS = true;
    @Option(doc="If true design baits on the strand of the target feature, if false always design on the + strand of the genome.")
    public boolean DESIGN_ON_TARGET_STRAND = false;
    @Option(doc="If true merge targets that are 'close enough' that designing against a merged target would be more efficient.")
    public boolean MERGE_NEARBY_TARGETS = true;
    @Option(doc="If true also output .design.txt files per pool with one line per bait sequence")
    public boolean OUTPUT_AGILENT_FILES = true;
    @Option(shortName="O", optional=true, doc="The output directory. If not provided then the DESIGN_NAME will be used as the output directory")
    public File OUTPUT_DIRECTORY;
    int TARGET_TERRITORY;
    int TARGET_COUNT;
    int BAIT_TERRITORY;
    int BAIT_COUNT;
    int BAIT_TARGET_TERRITORY_INTERSECTION;
    int ZERO_BAIT_TARGETS;
    double DESIGN_EFFICIENCY;
    private static final Log log = Log.getInstance(BaitDesigner.class);
    private final NumberFormat fmt = NumberFormat.getIntegerInstance();

    String makeBaitName(String string, int n, int n2) {
        String string2 = this.fmt.format(n2);
        String string3 = this.fmt.format(n);
        while (string3.length() < string2.length()) {
            string3 = "0" + string3;
        }
        return string + "_bait#" + string3;
    }

    public static int getMaskedBaseCount(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            byte by = byArray[i];
            if (by == 65 || by == 67 || by == 71 || by == 84) continue;
            ++n3;
        }
        return n3;
    }

    public static void main(String[] stringArray) {
        new BaitDesigner().instanceMainWithExit(stringArray);
    }

    @Override
    protected String[] customCommandLineValidation() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Pattern pattern = Pattern.compile("^[ACGTacgt]*$");
        if (this.LEFT_PRIMER != null && !pattern.matcher(this.LEFT_PRIMER).matches()) {
            arrayList.add("Left primer " + this.LEFT_PRIMER + " is not a valid primer sequence.");
        }
        if (this.RIGHT_PRIMER != null && !pattern.matcher(this.RIGHT_PRIMER).matches()) {
            arrayList.add("Right primer " + this.RIGHT_PRIMER + " is not a valid primer sequence.");
        }
        if (arrayList.size() > 0) {
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return null;
    }

    int estimateBaits(int n, int n2) {
        int n3 = n2 - n + 1;
        return Math.max(this.MINIMUM_BAITS_PER_TARGET, (int)(Math.ceil(n3 - this.BAIT_SIZE) / (double)this.BAIT_OFFSET) + 1);
    }

    @Override
    protected int doWork() {
        IntervalList intervalList;
        IntervalList intervalList2;
        if (this.OUTPUT_DIRECTORY == null) {
            this.OUTPUT_DIRECTORY = new File(this.DESIGN_NAME);
        }
        IOUtil.assertFileIsReadable((File)this.TARGETS);
        IOUtil.assertFileIsReadable((File)this.REFERENCE_SEQUENCE);
        if (!this.OUTPUT_DIRECTORY.exists()) {
            this.OUTPUT_DIRECTORY.mkdirs();
        }
        IOUtil.assertDirectoryIsWritable((File)this.OUTPUT_DIRECTORY);
        IntervalList intervalList3 = IntervalList.fromFile((File)this.TARGETS);
        IntervalList intervalList4 = new IntervalList(intervalList3.getHeader());
        SAMSequenceDictionary sAMSequenceDictionary = intervalList4.getHeader().getSequenceDictionary();
        for (Object object : intervalList3.getIntervals()) {
            intervalList4.add(new Interval(object.getSequence(), Math.max(object.getStart() - this.PADDING, 1), Math.min(object.getEnd() + this.PADDING, sAMSequenceDictionary.getSequence(object.getSequence()).getSequenceLength()), object.isNegativeStrand(), object.getName()));
        }
        log.info(new Object[]{"Starting with " + intervalList4.size() + " targets."});
        intervalList4.uniqued();
        log.info(new Object[]{"After uniquing " + intervalList4.size() + " targets remain."});
        if (this.MERGE_NEARBY_TARGETS) {
            Object object;
            intervalList2 = intervalList4.getIntervals().listIterator();
            object = (Interval)intervalList2.next();
            intervalList = new IntervalList(intervalList4.getHeader());
            while (intervalList2.hasNext()) {
                Interval interval = (Interval)intervalList2.next();
                if (object.getSequence().equals(interval.getSequence()) && this.estimateBaits(object.getStart(), object.getEnd()) + this.estimateBaits(interval.getStart(), interval.getEnd()) >= this.estimateBaits(object.getStart(), interval.getEnd())) {
                    object = new Interval(object.getSequence(), object.getStart(), Math.max(object.getEnd(), interval.getEnd()), object.isNegativeStrand(), object.getName());
                    continue;
                }
                intervalList.add((Interval)object);
                object = interval;
            }
            if (object != null) {
                intervalList.add((Interval)object);
            }
            log.info(new Object[]{"After collapsing nearby targets " + intervalList.size() + " targets remain."});
        } else {
            intervalList = intervalList4;
        }
        intervalList4 = new ReferenceSequenceFileWalker(this.REFERENCE_SEQUENCE);
        SequenceUtil.assertSequenceDictionariesEqual((SAMSequenceDictionary)intervalList4.getSequenceDictionary(), (SAMSequenceDictionary)intervalList.getHeader().getSequenceDictionary());
        int n = 0;
        intervalList2 = new IntervalList(intervalList.getHeader());
        for (Interval interval : intervalList) {
            int n2 = intervalList.getHeader().getSequenceIndex(interval.getSequence());
            ReferenceSequence referenceSequence = intervalList4.get(n2);
            for (Bait bait : this.DESIGN_STRATEGY.design(this, interval, referenceSequence)) {
                if (bait.length() != this.BAIT_SIZE) {
                    throw new PicardException("Bait designed at wrong length: " + (Object)((Object)bait));
                }
                if (bait.getMaskedBaseCount() <= this.REPEAT_TOLERANCE) {
                    intervalList2.add((Interval)bait);
                    for (byte by : bait.getBases()) {
                        byte by2 = StringUtil.toUpperCase((byte)by);
                        if (by2 == 65 || by2 == 67 || by2 == 71 || by2 == 84) continue;
                        log.warn(new Object[]{"Bait contains non-synthesizable bases: " + (Object)((Object)bait)});
                    }
                    continue;
                }
                log.debug(new Object[]{"Discarding bait: " + (Object)((Object)bait)});
                ++n;
            }
        }
        this.calculateStatistics(intervalList, intervalList2);
        log.info(new Object[]{"Designed and kept " + intervalList2.size() + " baits, discarded " + n});
        intervalList3.write(new File(this.OUTPUT_DIRECTORY, this.DESIGN_NAME + ".targets.interval_list"));
        intervalList2.write(new File(this.OUTPUT_DIRECTORY, this.DESIGN_NAME + ".baits.interval_list"));
        this.writeParametersFile(new File(this.OUTPUT_DIRECTORY, this.DESIGN_NAME + ".design_parameters.txt"));
        this.writeDesignFastaFile(new File(this.OUTPUT_DIRECTORY, this.DESIGN_NAME + ".design.fasta"), intervalList2);
        if (this.POOL_SIZE > 0) {
            this.writePoolFiles(this.OUTPUT_DIRECTORY, this.DESIGN_NAME, intervalList2);
        }
        return 0;
    }

    void calculateStatistics(IntervalList intervalList, IntervalList intervalList2) {
        this.TARGET_TERRITORY = (int)intervalList.getUniqueBaseCount();
        this.TARGET_COUNT = intervalList.size();
        this.BAIT_TERRITORY = (int)intervalList2.getUniqueBaseCount();
        this.BAIT_COUNT = intervalList2.size();
        this.DESIGN_EFFICIENCY = (double)this.TARGET_TERRITORY / (double)this.BAIT_TERRITORY;
        IntervalList intervalList3 = new IntervalList(intervalList.getHeader());
        OverlapDetector overlapDetector = new OverlapDetector(0, 0);
        overlapDetector.addAll(intervalList2.getIntervals(), intervalList2.getIntervals());
        for (Interval interval : intervalList) {
            Collection collection = overlapDetector.getOverlaps(interval);
            if (collection.isEmpty()) {
                ++this.ZERO_BAIT_TARGETS;
                continue;
            }
            for (Interval interval2 : collection) {
                intervalList3.add(interval.intersect(interval2));
            }
        }
        intervalList3.uniqued();
        this.BAIT_TARGET_TERRITORY_INTERSECTION = (int)intervalList3.getBaseCount();
    }

    void writeParametersFile(File file) {
        try {
            BufferedWriter bufferedWriter = IOUtil.openFileForBufferedWriting((File)file);
            for (Field field : this.getClass().getDeclaredFields()) {
                Object object;
                String string;
                if (Modifier.isPrivate(field.getModifiers()) || !(string = field.getName()).toUpperCase().equals(string) || string.equals("USAGE") || (object = field.get(this)) == null) continue;
                bufferedWriter.append(string);
                bufferedWriter.append("=");
                bufferedWriter.append(object.toString());
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            throw new PicardException("Error writing out parameters file.", exception);
        }
    }

    void writeDesignFastaFile(File file, IntervalList intervalList) {
        BufferedWriter bufferedWriter = IOUtil.openFileForBufferedWriting((File)file);
        for (Interval interval : intervalList) {
            this.writeBaitFasta(bufferedWriter, interval, false);
        }
        CloserUtil.close((Object)bufferedWriter);
    }

    private void writeBaitFasta(BufferedWriter bufferedWriter, Interval interval, boolean bl) {
        try {
            Bait bait = (Bait)interval;
            bufferedWriter.append(">");
            bufferedWriter.append(bait.getName());
            bufferedWriter.newLine();
            String string = this.getBaitSequence(bait, bl);
            bufferedWriter.append(string);
            bufferedWriter.newLine();
        }
        catch (IOException iOException) {
            throw new PicardException("Error writing out bait information.", iOException);
        }
    }

    private String getBaitSequence(Bait bait, boolean bl) {
        String string = (this.LEFT_PRIMER == null ? "" : this.LEFT_PRIMER) + StringUtil.bytesToString((byte[])bait.getBases()) + (this.RIGHT_PRIMER == null ? "" : this.RIGHT_PRIMER);
        if (bl) {
            string = SequenceUtil.reverseComplement((String)string);
        }
        return string;
    }

    void writePoolFiles(File file, String string, IntervalList intervalList) {
        int n = this.FILL_POOLS && intervalList.size() < this.POOL_SIZE ? (int)Math.floor((double)this.POOL_SIZE / (double)intervalList.size()) : 1;
        int n2 = 0;
        int n3 = 0;
        BufferedWriter bufferedWriter = null;
        BufferedWriter bufferedWriter2 = null;
        String string2 = this.DESIGN_NAME.substring(0, Math.min(this.DESIGN_NAME.length(), 8)) + "_";
        DecimalFormat decimalFormat = new DecimalFormat("000000");
        try {
            for (int i = 0; i < n; ++i) {
                boolean bl = i % 2 == 1;
                int n4 = 1;
                for (Interval interval : intervalList) {
                    Bait bait = (Bait)interval;
                    if (n2++ % this.POOL_SIZE == 0) {
                        if (bufferedWriter != null) {
                            bufferedWriter.close();
                        }
                        if (bufferedWriter2 != null) {
                            bufferedWriter2.close();
                        }
                        String string3 = string + ".pool" + n3++ + ".design.";
                        bufferedWriter = IOUtil.openFileForBufferedWriting((File)new File(file, string3 + "fasta"));
                        if (this.OUTPUT_AGILENT_FILES) {
                            bufferedWriter2 = IOUtil.openFileForBufferedWriting((File)new File(file, string3 + "txt"));
                        }
                    }
                    this.writeBaitFasta(bufferedWriter, interval, bl);
                    if (!this.OUTPUT_AGILENT_FILES) continue;
                    bufferedWriter2.append(string2).append(decimalFormat.format(n4++));
                    bufferedWriter2.append("\t");
                    bufferedWriter2.append(this.getBaitSequence(bait, bl).toUpperCase());
                    bufferedWriter2.newLine();
                }
            }
            CloserUtil.close(bufferedWriter);
            CloserUtil.close(bufferedWriter2);
        }
        catch (Exception exception) {
            throw new PicardException("Error while writing pool files.", exception);
        }
    }

    public static enum DesignStrategy {
        CenteredConstrained{

            @Override
            List<Bait> design(BaitDesigner baitDesigner, Interval interval, ReferenceSequence referenceSequence) {
                LinkedList<Bait> linkedList = new LinkedList<Bait>();
                int n = baitDesigner.BAIT_SIZE;
                int n2 = baitDesigner.BAIT_OFFSET;
                if (interval.length() <= n) {
                    int n3 = interval.getStart() + interval.length() / 2;
                    int n4 = n3 - n / 2;
                    Bait bait = new Bait(interval.getSequence(), n4, CoordMath.getEnd((int)n4, (int)n), interval.isNegativeStrand(), baitDesigner.makeBaitName(interval.getName(), 1, 1));
                    bait.addBases(referenceSequence, baitDesigner.DESIGN_ON_TARGET_STRAND);
                    linkedList.add(bait);
                } else {
                    int n5 = 1 + (int)Math.ceil((double)(interval.length() - n) / (double)n2);
                    int n6 = interval.getStart();
                    int n7 = CoordMath.getStart((int)interval.getEnd(), (int)n);
                    double d = (double)(n7 - n6) / (double)(n5 - 1);
                    int n8 = 1;
                    int n9 = n6;
                    while (n9 <= n7) {
                        int n10 = CoordMath.getEnd((int)n9, (int)n);
                        Bait bait = new Bait(interval.getSequence(), n9, n10, interval.isNegativeStrand(), baitDesigner.makeBaitName(interval.getName(), n8, n5));
                        bait.addBases(referenceSequence, baitDesigner.DESIGN_ON_TARGET_STRAND);
                        linkedList.add(bait);
                        n9 = n6 + (int)Math.round(d * (double)n8);
                        ++n8;
                    }
                }
                return linkedList;
            }
        }
        ,
        FixedOffset{

            @Override
            List<Bait> design(BaitDesigner baitDesigner, Interval interval, ReferenceSequence referenceSequence) {
                int n;
                int n2;
                Interval interval2;
                int n3;
                int n4;
                int n5;
                LinkedList<Bait> linkedList = new LinkedList<Bait>();
                int n6 = baitDesigner.BAIT_SIZE;
                int n7 = baitDesigner.BAIT_OFFSET;
                int n8 = n6 + n7 * (baitDesigner.MINIMUM_BAITS_PER_TARGET - 1);
                if (interval.length() < n8) {
                    n5 = n8 - interval.length();
                    n4 = n5 / 2;
                    n3 = n5 - n4;
                    interval2 = new Interval(interval.getSequence(), Math.max(interval.getStart() - n4, 1), Math.min(interval.getEnd() + n3, referenceSequence.length()), interval.isNegativeStrand(), interval.getName());
                } else {
                    interval2 = interval;
                }
                n5 = 1 + (int)Math.ceil((double)(interval2.length() - n6) / (double)n7);
                n4 = n6 + n7 * (n5 - 1);
                n3 = Math.max(interval2.getStart() - (n4 - interval2.length()) / 2, 1);
                byte[] byArray = referenceSequence.getBases();
                int n9 = baitDesigner.REPEAT_TOLERANCE;
                for (int i = 1; i <= n5 && (n2 = CoordMath.getEnd((int)(n = n3 + n7 * (i - 1)), (int)n6)) <= referenceSequence.length(); ++i) {
                    if (BaitDesigner.getMaskedBaseCount(byArray, n - 1, n2) > n9) {
                        int n10 = n7 * 3 / 4;
                        for (int j = 1; j <= n10; ++j) {
                            if (n - j >= 1 && BaitDesigner.getMaskedBaseCount(byArray, n - j - 1, n2 - j) <= n9) {
                                n -= j;
                                n2 -= j;
                                break;
                            }
                            if (n2 + j > referenceSequence.length() || BaitDesigner.getMaskedBaseCount(byArray, n + j - 1, n2 + j) > n9) continue;
                            n += j;
                            n2 += j;
                            break;
                        }
                    }
                    Bait bait = new Bait(interval2.getSequence(), n, n2, interval2.isNegativeStrand(), baitDesigner.makeBaitName(interval2.getName(), i, n5));
                    bait.addBases(referenceSequence, baitDesigner.DESIGN_ON_TARGET_STRAND);
                    linkedList.add(bait);
                }
                return linkedList;
            }
        }
        ,
        Simple{

            @Override
            List<Bait> design(BaitDesigner baitDesigner, Interval interval, ReferenceSequence referenceSequence) {
                LinkedList<Bait> linkedList = new LinkedList<Bait>();
                int n = baitDesigner.BAIT_SIZE;
                int n2 = baitDesigner.BAIT_OFFSET;
                int n3 = Math.min(interval.getEnd(), referenceSequence.length() - n);
                int n4 = 1 + (int)Math.floor((double)(n3 - interval.getStart()) / (double)n2);
                int n5 = 0;
                for (int i = interval.getStart(); i < n3; i += n2) {
                    Bait bait = new Bait(interval.getSequence(), i, CoordMath.getEnd((int)i, (int)n), interval.isNegativeStrand(), baitDesigner.makeBaitName(interval.getName(), ++n5, n4));
                    bait.addBases(referenceSequence, baitDesigner.DESIGN_ON_TARGET_STRAND);
                    linkedList.add(bait);
                }
                return linkedList;
            }
        };


        abstract List<Bait> design(BaitDesigner var1, Interval var2, ReferenceSequence var3);
    }

    static class Bait
    extends Interval {
        byte[] bases;

        public Bait(String string, int n, int n2, boolean bl, String string2) {
            super(string, n, n2, bl, string2);
        }

        public void addBases(ReferenceSequence referenceSequence, boolean bl) {
            byte[] byArray = new byte[this.length()];
            System.arraycopy(referenceSequence.getBases(), this.getStart() - 1, byArray, 0, this.length());
            if (bl && this.isNegativeStrand()) {
                SequenceUtil.reverseComplement((byte[])byArray);
            }
            this.setBases(byArray);
        }

        public int getMaskedBaseCount() {
            return BaitDesigner.getMaskedBaseCount(this.bases, 0, this.bases.length);
        }

        public String toString() {
            return "Bait{name=" + this.getName() + ", bases=" + StringUtil.bytesToString((byte[])this.bases) + '}';
        }

        public void setBases(byte[] byArray) {
            this.bases = byArray;
        }

        public byte[] getBases() {
            return this.bases;
        }
    }
}

