/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.util.BufferedLineReader;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import picard.PicardException;
import picard.util.AbstractInputParser;

public class BasicInputParser
extends AbstractInputParser {
    private BufferedLineReader reader;
    private final ArrayList<InputStream> inputs = new ArrayList();
    private final ArrayList<String> fileNames = new ArrayList();
    String currentFileName = null;
    private String currentLine = null;
    private String nextLine = null;
    private int currentLineNumber = 0;
    private int nextLineNumber = 0;

    public BasicInputParser(boolean bl, InputStream ... inputStreamArray) {
        if (inputStreamArray.length == 0) {
            throw new IllegalArgumentException("At least one input must be specified.");
        }
        this.inputs.addAll(Arrays.asList(inputStreamArray));
        this.reader = new BufferedLineReader(this.inputs.remove(0));
        this.setTreatGroupedDelimitersAsOne(bl);
    }

    public BasicInputParser(boolean bl, int n, InputStream ... inputStreamArray) {
        this(bl, inputStreamArray);
        this.setWordCount(n);
    }

    public BasicInputParser(boolean bl, File ... fileArray) {
        this(bl, BasicInputParser.filesToInputStreams(fileArray));
        for (File file : fileArray) {
            this.fileNames.add(file.getAbsolutePath());
        }
        this.currentFileName = this.fileNames.remove(0);
    }

    public BasicInputParser(boolean bl, int n, File ... fileArray) {
        this(bl, fileArray);
        this.setWordCount(n);
    }

    @Override
    protected byte[] readNextLine() {
        try {
            String string = this.reader.readLine();
            if (this.nextLine != null && !this.isComment(this.nextLine.getBytes())) {
                this.currentLineNumber = this.nextLineNumber;
                this.currentLine = this.nextLine;
            }
            if (string != null) {
                ++this.nextLineNumber;
                this.nextLine = string;
                return string.getBytes();
            }
            if (this.inputs.size() > 0) {
                this.advanceFile();
                return this.readNextLine();
            }
            return null;
        }
        catch (RuntimeIOException runtimeIOException) {
            throw new PicardException("Error reading from file " + this.currentFileName, runtimeIOException);
        }
    }

    protected void advanceFile() {
        this.currentFileName = this.fileNames.size() > 0 ? this.fileNames.remove(0) : null;
        this.nextLineNumber = 0;
        this.nextLine = null;
        this.reader = new BufferedLineReader(this.inputs.remove(0));
    }

    @Override
    public void close() {
        if (this.reader != null) {
            this.reader.close();
        }
        for (InputStream inputStream : this.inputs) {
            CloserUtil.close((Object)inputStream);
        }
    }

    @Override
    public String getFileName() {
        return this.currentFileName != null ? this.currentFileName : "(file name unavailable)";
    }

    public String getCurrentLine() {
        return this.currentLine;
    }

    public int getCurrentLineNumber() {
        return this.currentLineNumber;
    }

    private static InputStream[] filesToInputStreams(File[] fileArray) {
        InputStream[] inputStreamArray = new InputStream[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            inputStreamArray[i] = IOUtil.openFileForReading((File)fileArray[i]);
        }
        return inputStreamArray;
    }
}

