/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.CloseableTribbleIterator;
import htsjdk.tribble.FeatureCodec;
import htsjdk.tribble.annotation.Strand;
import htsjdk.tribble.bed.BEDCodec;
import htsjdk.tribble.bed.BEDFeature;
import htsjdk.variant.utils.SAMSequenceDictionaryExtractor;
import java.io.File;
import java.io.IOException;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Intervals;

@CommandLineProgramProperties(usage="Converts a BED file to an Picard Interval List.", usageShort="Converts a BED file to an Picard Interval List.", programGroup=Intervals.class)
public class BedToIntervalList
extends CommandLineProgram {
    @Option(shortName="I", doc="The input BED file")
    public File INPUT;
    @Option(shortName="SD", doc="The sequence dictionary")
    public File SEQUENCE_DICTIONARY;
    @Option(shortName="O", doc="The output Picard Interval List")
    public File OUTPUT;
    @Option(doc="If true, sort the output interval list before writing it.")
    public boolean SORT = true;
    @Option(doc="If true, unique the output interval list by merging overlapping regions, before writing it (implies sort=true).")
    public boolean UNIQUE = true;
    final Log LOG = Log.getInstance(this.getClass());

    public static void main(String[] stringArray) {
        new BedToIntervalList().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsReadable((File)this.SEQUENCE_DICTIONARY);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        try {
            BEDFeature bEDFeature;
            SAMFileHeader sAMFileHeader = new SAMFileHeader();
            SAMSequenceDictionary sAMSequenceDictionary = SAMSequenceDictionaryExtractor.extractDictionary((File)this.SEQUENCE_DICTIONARY);
            sAMFileHeader.setSequenceDictionary(sAMSequenceDictionary);
            sAMFileHeader.setSortOrder(SAMFileHeader.SortOrder.coordinate);
            IntervalList intervalList = new IntervalList(sAMFileHeader);
            AbstractFeatureReader abstractFeatureReader = AbstractFeatureReader.getFeatureReader((String)this.INPUT.getAbsolutePath(), (FeatureCodec)new BEDCodec(BEDCodec.StartOffset.ZERO), (boolean)false);
            CloseableTribbleIterator closeableTribbleIterator = abstractFeatureReader.iterator();
            ProgressLogger progressLogger = new ProgressLogger(this.LOG, 1000000);
            while (closeableTribbleIterator.hasNext()) {
                SAMSequenceRecord sAMSequenceRecord;
                bEDFeature = (BEDFeature)closeableTribbleIterator.next();
                String string = bEDFeature.getContig();
                int n = bEDFeature.getStart() + 1;
                int n2 = bEDFeature.getEnd();
                String string2 = bEDFeature.getName();
                if (string2.isEmpty()) {
                    string2 = null;
                }
                if (null == (sAMSequenceRecord = sAMFileHeader.getSequenceDictionary().getSequence(string))) {
                    throw new PicardException(String.format("Sequence '%s' was not found in the sequence dictionary", string));
                }
                if (n < 1) {
                    throw new PicardException(String.format("Start on sequence '%s' was less than one: %d", string, n));
                }
                if (sAMSequenceRecord.getSequenceLength() < n) {
                    throw new PicardException(String.format("Start on sequence '%s' was past the end: %d < %d", string, sAMSequenceRecord.getSequenceLength(), n));
                }
                if (n2 < 1) {
                    throw new PicardException(String.format("End on sequence '%s' was less than one: %d", string, n2));
                }
                if (sAMSequenceRecord.getSequenceLength() < n2) {
                    throw new PicardException(String.format("End on sequence '%s' was past the end: %d < %d", string, sAMSequenceRecord.getSequenceLength(), n2));
                }
                if (n2 < n - 1) {
                    throw new PicardException(String.format("On sequence '%s', end < start-1: %d <= %d", string, n2, n));
                }
                boolean bl = bEDFeature.getStrand() == Strand.NEGATIVE;
                Interval interval = new Interval(string, n, n2, bl, string2);
                intervalList.add(interval);
                progressLogger.record(string, n);
            }
            CloserUtil.close((Object)abstractFeatureReader);
            bEDFeature = intervalList;
            if (this.SORT) {
                bEDFeature = bEDFeature.sorted();
            }
            if (this.UNIQUE) {
                bEDFeature = bEDFeature.uniqued();
            }
            bEDFeature.write(this.OUTPUT);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return 0;
    }
}

