/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import picard.PicardException;

public class CircularByteBuffer {
    private final byte[] bytes;
    private final int capacity;
    private int nextWritePos = 0;
    private int bytesAvailableToWrite;
    private int nextReadPos = 0;
    private int bytesAvailableToRead = 0;
    private boolean closed = false;

    public CircularByteBuffer(int n) {
        this.bytes = new byte[n];
        this.bytesAvailableToWrite = this.capacity = this.bytes.length;
    }

    public synchronized int write(byte[] byArray, int n, int n2) {
        if (this.closed) {
            throw new IllegalStateException("Cannot write to closed buffer.");
        }
        try {
            if (this.bytesAvailableToWrite == 0) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new PicardException("Interrupted while waiting to write to fifo.", interruptedException);
        }
        int n3 = this.nextWritePos;
        int n4 = this.capacity - n3;
        int n5 = n4 < this.bytesAvailableToWrite ? n4 : this.bytesAvailableToWrite;
        int n6 = n5 < n2 ? n5 : n2;
        System.arraycopy(byArray, n, this.bytes, n3, n6);
        this.bytesAvailableToWrite -= n6;
        this.bytesAvailableToRead += n6;
        this.nextWritePos = (n3 + n6) % this.capacity;
        this.notify();
        return n6;
    }

    public synchronized int read(byte[] byArray, int n, int n2) {
        try {
            if (this.bytesAvailableToRead == 0 && !this.closed) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new PicardException("Interrupted while waiting to read from fifo.", interruptedException);
        }
        int n3 = this.nextReadPos;
        int n4 = this.capacity - n3;
        int n5 = n4 < this.bytesAvailableToRead ? n4 : this.bytesAvailableToRead;
        int n6 = n5 < n2 ? n5 : n2;
        System.arraycopy(this.bytes, n3, byArray, n, n6);
        this.bytesAvailableToRead -= n6;
        this.bytesAvailableToWrite += n6;
        this.nextReadPos = (n3 + n6) % this.capacity;
        this.notify();
        return n6;
    }

    public synchronized void close() {
        this.closed = true;
        this.notify();
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public synchronized int getBytesAvailableToRead() {
        return this.bytesAvailableToRead;
    }
}

