/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMProgramRecord;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import htsjdk.variant.vcf.VCFFileReader;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import picard.PicardException;
import picard.cmdline.CommandLineParser;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Intervals;
import picard.util.IntervalListScatterer;

@CommandLineProgramProperties(usage=" General tool for manipulating interval lists, including sorting, merging, padding, uniqueifying, and other set-theoretic operations. Default operation if given one or more inputs is to merge and sort them.  Other options are controlled by arguments.", usageShort="General tool for manipulating interval lists", programGroup=Intervals.class)
public class IntervalListTools
extends CommandLineProgram {
    @Option(shortName="I", doc="One or more interval lists. If multiple interval lists are provided the output is theresult of merging the inputs. Supported formats are interval_list and VCF.", minElements=1)
    public List<File> INPUT;
    @Option(doc="The output interval list file to write (if SCATTER_COUNT is 1) or the directory into which to write the scattered interval sub-directories (if SCATTER_COUNT > 1)", shortName="O", optional=true)
    public File OUTPUT;
    @Option(doc="The amount to pad each end of the intervals by before other operations are undertaken. Negative numbers are allowed and indicate intervals should be shrunk. Resulting intervals < 0 bases long will be removed. Padding is applied to the interval lists <b> before </b> the ACTION is performed.", optional=true)
    public int PADDING = 0;
    @Option(doc="If true, merge overlapping and adjacent intervals to create a list of unique intervals. Implies SORT=true")
    public boolean UNIQUE = false;
    @Option(doc="If true, sort the resulting interval list by coordinate.")
    public boolean SORT = true;
    @Option(doc="Action to take on inputs.")
    public Action ACTION = Action.CONCAT;
    @Option(shortName="SI", doc="Second set of intervals for SUBTRACT and DIFFERENCE operations.", optional=true)
    public List<File> SECOND_INPUT;
    @Option(doc="One or more lines of comment to add to the header of the output file.", optional=true)
    public List<String> COMMENT = null;
    @Option(doc="The number of files into which to scatter the resulting list by locus; in some situations, fewer intervals may be emitted.  Note - if > 1, the resultant scattered intervals will be sorted and uniqued.  The sort will be inverted if the INVERT flag is set.")
    public int SCATTER_COUNT = 1;
    @Option(doc="Whether to include filtered variants in the vcf when generating an interval list from vcf", optional=true)
    public boolean INCLUDE_FILTERED = false;
    @Option(shortName="BRK", doc="If set to a positive value will create a new interval list with the original intervals broken up at integer multiples of this value.  Set to 0 to NOT break up intervals", optional=true)
    public int BREAK_BANDS_AT_MULTIPLES_OF = 0;
    @Option(shortName="M", doc="Do not subdivide ")
    public IntervalListScatterer.Mode SUBDIVISION_MODE = IntervalListScatterer.Mode.INTERVAL_SUBDIVISION;
    @Option(doc="Produce the inverse list", optional=true)
    public boolean INVERT = false;
    private static final Log LOG = Log.getInstance(IntervalListTools.class);

    public static void main(String[] stringArray) {
        new IntervalListTools().instanceMainWithExit(stringArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int doWork() {
        void var10_25;
        List list;
        for (File object22 : this.INPUT) {
            IOUtil.assertFileIsReadable((File)object22);
        }
        for (File file : this.SECOND_INPUT) {
            IOUtil.assertFileIsReadable((File)file);
        }
        if (this.OUTPUT != null) {
            if (this.SCATTER_COUNT == 1) {
                IOUtil.assertFileIsWritable((File)this.OUTPUT);
            } else {
                IOUtil.assertDirectoryIsWritable((File)this.OUTPUT);
            }
        }
        List<IntervalList> list2 = this.openIntervalLists(this.INPUT);
        List<IntervalList> list3 = this.openIntervalLists(this.SECOND_INPUT);
        if (this.UNIQUE && !this.SORT) {
            LOG.warn(new Object[]{"UNIQUE=true requires sorting but SORT=false was specified.  Results will be sorted!"});
        }
        IntervalList intervalList = this.ACTION.act(list2, list3);
        if (this.SCATTER_COUNT > 1) {
            this.SORT = true;
            this.UNIQUE = true;
        }
        if (this.INVERT) {
            this.SORT = false;
            this.UNIQUE = true;
        }
        IntervalList intervalList2 = this.SORT ? intervalList.sorted() : intervalList;
        IntervalList intervalList3 = this.INVERT ? IntervalList.invert((IntervalList)intervalList2) : intervalList2;
        List list4 = list = this.UNIQUE ? intervalList3.uniqued().getIntervals() : intervalList3.getIntervals();
        if (this.BREAK_BANDS_AT_MULTIPLES_OF > 0) {
            list = IntervalList.breakIntervalsAtBandMultiples((List)list, (int)this.BREAK_BANDS_AT_MULTIPLES_OF);
        }
        SAMFileHeader sAMFileHeader = intervalList.getHeader();
        HashSet<String> hashSet = new HashSet<String>();
        for (SAMProgramRecord sAMProgramRecord : sAMFileHeader.getProgramRecords()) {
            hashSet.add(sAMProgramRecord.getId());
        }
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            if (hashSet.contains(String.valueOf(i))) continue;
            SAMProgramRecord sAMProgramRecord = new SAMProgramRecord(String.valueOf(i));
            sAMProgramRecord.setCommandLine(this.getCommandLine());
            sAMProgramRecord.setProgramName(this.getClass().getSimpleName());
            sAMFileHeader.addProgramRecord(sAMProgramRecord);
            break;
        }
        if (this.COMMENT != null) {
            for (String string : this.COMMENT) {
                sAMFileHeader.addComment(string);
            }
        }
        IntervalList intervalList4 = new IntervalList(sAMFileHeader);
        for (Object object : list) {
            intervalList4.add((Interval)object);
        }
        if (this.OUTPUT != null) {
            if (this.SCATTER_COUNT == 1) {
                intervalList4.write(this.OUTPUT);
                List<IntervalList> list5 = Arrays.asList(intervalList4);
            } else {
                Object object;
                object = this.writeScatterIntervals(intervalList4);
                LOG.info(new Object[]{String.format("Wrote %s scatter subdirectories to %s.", object.size(), this.OUTPUT)});
                if (object.size() != this.SCATTER_COUNT) {
                    LOG.warn(new Object[]{String.format("Requested scatter width of %s, but only emitted %s.  (This may be an expected consequence of running in %s mode.)", new Object[]{this.SCATTER_COUNT, object.size(), this.SUBDIVISION_MODE})});
                }
                Object object2 = object;
            }
        } else {
            List<IntervalList> list6 = Arrays.asList(intervalList4);
        }
        long l = 0L;
        long l2 = 0L;
        for (IntervalList intervalList5 : var10_25) {
            l = intervalList5.getUniqueBaseCount();
            l2 += (long)intervalList5.size();
        }
        LOG.info(new Object[]{"Produced " + l2 + " intervals totalling " + l + " unique bases."});
        return 0;
    }

    private List<IntervalList> openIntervalLists(List<File> list) {
        ArrayList<IntervalList> arrayList = new ArrayList<IntervalList>();
        for (File file : list) {
            arrayList.add(TYPE.getIntervalList(file, this.INCLUDE_FILTERED).padded(this.PADDING));
        }
        return arrayList;
    }

    @Override
    protected String[] customCommandLineValidation() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.SCATTER_COUNT < 1) {
            arrayList.add("SCATTER_COUNT must be greater than 0.");
        }
        if (this.BREAK_BANDS_AT_MULTIPLES_OF < 0) {
            arrayList.add("BREAK_BANDS_AT_MULTIPLES_OF must be greater than or equal to 0.");
        }
        return arrayList.size() == 0 ? null : arrayList.toArray(new String[arrayList.size()]);
    }

    private List<IntervalList> writeScatterIntervals(IntervalList intervalList) {
        IntervalListScatterer intervalListScatterer = new IntervalListScatterer(this.SUBDIVISION_MODE);
        List<IntervalList> list = intervalListScatterer.scatter(intervalList, this.SCATTER_COUNT, this.UNIQUE);
        DecimalFormat decimalFormat = new DecimalFormat("0000");
        int n = 1;
        for (IntervalList intervalList2 : list) {
            intervalList2.write(IntervalListTools.createDirectoryAndGetScatterFile(this.OUTPUT, list.size(), decimalFormat.format(n++)));
        }
        return list;
    }

    public static File getScatteredFileName(File file, long l, String string) {
        return new File(file.getAbsolutePath() + "/temp_" + string + "_of_" + l + "/scattered" + ".interval_list");
    }

    private static File createDirectoryAndGetScatterFile(File file, long l, String string) {
        IntervalListTools.createDirectoryOrFail(file);
        File file2 = IntervalListTools.getScatteredFileName(file, l, string);
        IntervalListTools.createDirectoryOrFail(file2.getParentFile());
        return file2;
    }

    private static void createDirectoryOrFail(File file) {
        if (!file.exists() && !file.mkdir()) {
            throw new PicardException("Unable to create directory: " + file.getAbsolutePath());
        }
    }

    static enum TYPE {
        VCF(IOUtil.VCF_EXTENSIONS){

            @Override
            protected IntervalList getIntervalListInternal(File file, boolean bl) {
                return VCFFileReader.fromVcf((File)file, (boolean)bl);
            }
        }
        ,
        INTERVAL_LIST(new String[]{".interval_list"}){

            @Override
            protected IntervalList getIntervalListInternal(File file, boolean bl) {
                return IntervalList.fromFile((File)file);
            }
        };

        final Collection<String> applicableExtensions;

        private TYPE(String ... stringArray) {
            this.applicableExtensions = CollectionUtil.makeSet((Object[])stringArray);
        }

        private TYPE(Collection<String> collection) {
            this.applicableExtensions = collection;
        }

        protected abstract IntervalList getIntervalListInternal(File var1, boolean var2);

        static TYPE forFile(File file) {
            for (TYPE tYPE : TYPE.values()) {
                for (String string : tYPE.applicableExtensions) {
                    if (!file.getName().endsWith(string)) continue;
                    return tYPE;
                }
            }
            throw new SAMException("Cannot figure out type of file " + file.getAbsolutePath() + " from extension. Current implementation understands the following types: " + Arrays.toString((Object[])TYPE.values()));
        }

        public static IntervalList getIntervalList(File file, boolean bl) {
            return TYPE.forFile(file).getIntervalListInternal(file, bl);
        }

        public String toString() {
            return super.toString() + ": " + this.applicableExtensions.toString();
        }
    }

    public static enum Action implements CommandLineParser.ClpEnum
    {
        CONCAT("The concatenation of all the INPUTs, no sorting or merging of overlapping/abutting intervals implied. Will result in an unsorted list unless requested otherwise."){

            @Override
            IntervalList act(List<IntervalList> list, List<IntervalList> list2) {
                if (!list2.isEmpty()) {
                    throw new IllegalArgumentException(String.format("Second List found when action was %s. Ignoring second list.", this.name()));
                }
                return IntervalList.concatenate(list);
            }
        }
        ,
        UNION("Like CONCATENATE but with UNIQUE and SORT implied, the result being the set-wise union of all INPUTS."){

            @Override
            IntervalList act(List<IntervalList> list, List<IntervalList> list2) {
                if (!list2.isEmpty()) {
                    throw new IllegalArgumentException(String.format("Second List found when action was %s. Ignoring second list.", this.name()));
                }
                return IntervalList.union(list);
            }
        }
        ,
        INTERSECT("The sorted, uniqued set of all loci that are contained in all of the INPUTs."){

            @Override
            IntervalList act(List<IntervalList> list, List<IntervalList> list2) {
                if (!list2.isEmpty()) {
                    throw new IllegalArgumentException(String.format("Second List found when action was %s. Ignoring second list.", this.name()));
                }
                return IntervalList.intersection(list);
            }
        }
        ,
        SUBTRACT("Subtracts SECOND_INPUT from INPUT. The resulting loci are there in INPUT that are not in SECOND_INPUT"){

            @Override
            IntervalList act(List<IntervalList> list, List<IntervalList> list2) {
                return IntervalList.subtract(list, list2);
            }
        }
        ,
        SYMDIFF("Find loci that are in INPUT or SECOND_INPUT but are not in both."){

            @Override
            IntervalList act(List<IntervalList> list, List<IntervalList> list2) {
                return IntervalList.difference(list, list2);
            }
        };

        String helpdoc;

        private Action(String string2) {
            this.helpdoc = string2;
        }

        @Override
        public String getHelpDoc() {
            return this.helpdoc;
        }

        abstract IntervalList act(List<IntervalList> var1, List<IntervalList> var2);
    }
}

