/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.liftover.LiftOver;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.util.List;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Intervals;

@CommandLineProgramProperties(usage="Lifts over an interval list from one reference build to another. Based on UCSC liftOver. Uses a UCSC chain file to guide the liftOver.", usageShort="Lifts over an interval list from one reference build to another", programGroup=Intervals.class)
public class LiftOverIntervalList
extends CommandLineProgram {
    private static final Log LOG = Log.getInstance(LiftOverIntervalList.class);
    @Option(doc="Interval list to be lifted over.", shortName="I")
    public File INPUT;
    @Option(doc="Where to write lifted-over interval list.", shortName="O")
    public File OUTPUT;
    @Option(doc="Sequence dictionary to write into the output interval list.", shortName="SD")
    public File SEQUENCE_DICTIONARY;
    @Option(doc="Chain file that guides LiftOver.")
    public File CHAIN;
    @Option(doc="Minimum percentage of bases in each input interval that must map to output interval.")
    public double MIN_LIFTOVER_PCT = 0.95;

    public static void main(String[] stringArray) {
        new LiftOverIntervalList().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsReadable((File)this.SEQUENCE_DICTIONARY);
        IOUtil.assertFileIsReadable((File)this.CHAIN);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        LiftOver liftOver = new LiftOver(this.CHAIN);
        liftOver.setLiftOverMinMatch(this.MIN_LIFTOVER_PCT);
        IntervalList intervalList = IntervalList.fromFile((File)this.INPUT);
        SAMFileHeader sAMFileHeader = SamReaderFactory.makeDefault().getFileHeader(this.SEQUENCE_DICTIONARY);
        liftOver.validateToSequences(sAMFileHeader.getSequenceDictionary());
        IntervalList intervalList2 = new IntervalList(sAMFileHeader);
        boolean bl = false;
        for (Interval interval : intervalList) {
            Interval interval2 = liftOver.liftOver(interval);
            if (interval2 != null) {
                intervalList2.add(interval2);
                continue;
            }
            bl = true;
            LOG.warn(new Object[]{"Liftover failed for ", interval, "(len ", interval.length(), ")"});
            List list = liftOver.diagnosticLiftover(interval);
            for (LiftOver.PartialLiftover partialLiftover : list) {
                LOG.info(new Object[]{partialLiftover});
            }
        }
        intervalList2.sorted();
        intervalList2.write(this.OUTPUT);
        return bl ? 1 : 0;
    }
}

