/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import java.math.BigDecimal;
import java.util.Arrays;

public final class MathUtil {
    public static final double MAX_PROB_BELOW_ONE = 0.9999999999999999;
    public static final LogMath LOG_2_MATH = new LogMath(2.0);
    public static final LogMath NATURAL_LOG_MATH = new LogMath(Math.exp(1.0)){

        @Override
        public double getLogValue(double d) {
            return Math.log(d);
        }
    };
    public static final LogMath LOG_10_MATH = new LogMath(10.0){

        @Override
        public double getLogValue(double d) {
            return Math.log10(d);
        }
    };

    private MathUtil() {
    }

    public static double log10_1p(double d) {
        return Math.log1p(d) / LOG_10_MATH.log_of_base;
    }

    public static double mean(double[] dArray, int n, int n2) {
        double d = 0.0;
        for (int i = n; i < n2; ++i) {
            d += dArray[i];
        }
        return d / (double)(n2 - n);
    }

    public static double stddev(double[] dArray, int n, int n2) {
        return MathUtil.stddev(dArray, n, n2, MathUtil.mean(dArray, n, n2));
    }

    public static double stddev(double[] dArray, int n, int n2, double d) {
        double d2 = 0.0;
        for (int i = n; i < n2; ++i) {
            d2 += dArray[i] * dArray[i];
        }
        return Math.sqrt(d2 / (double)(n2 - n) - d * d);
    }

    public static int compare(int n, int n2) {
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    public static double median(double ... dArray) {
        if (dArray.length == 0) {
            throw new IllegalArgumentException("Attempting to find the median of an empty array");
        }
        double[] dArray2 = Arrays.copyOf(dArray, dArray.length);
        Arrays.sort(dArray2);
        int n = dArray2.length / 2;
        return dArray2.length % 2 == 1 ? dArray2[n] : (dArray2[n - 1] + dArray2[n]) / 2.0;
    }

    public static Double percentageOrNull(Long l, Long l2) {
        if (l != null && l2 != null && l2 != 0L) {
            return l.doubleValue() / l2.doubleValue();
        }
        return null;
    }

    public static double round(double d, int n) {
        BigDecimal bigDecimal = new BigDecimal(d);
        bigDecimal = bigDecimal.setScale(n, 4);
        return bigDecimal.doubleValue();
    }

    public static double max(double[] dArray) {
        return dArray[MathUtil.indexOfMax(dArray)];
    }

    public static int indexOfMax(double[] dArray) {
        double d = dArray[0];
        int n = 0;
        for (int i = 1; i < dArray.length; ++i) {
            if (!(dArray[i] > d)) continue;
            d = dArray[i];
            n = i;
        }
        return n;
    }

    public static double min(double[] dArray) {
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            if (!(dArray[i] < d)) continue;
            d = dArray[i];
        }
        return d;
    }

    public static int min(int[] nArray) {
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] >= n) continue;
            n = nArray[i];
        }
        return n;
    }

    public static short min(short[] sArray) {
        short s = sArray[0];
        for (int i = 1; i < sArray.length; ++i) {
            if (sArray[i] >= s) continue;
            s = sArray[i];
        }
        return s;
    }

    public static double[] seq(double d, double d2, double d3) {
        if (d < d2 && d3 <= 0.0) {
            return new double[0];
        }
        if (d > d2 && d3 >= 0.0) {
            return new double[0];
        }
        int n = 1 + (int)Math.floor((d2 - d) / d3);
        double[] dArray = new double[n];
        BigDecimal bigDecimal = new BigDecimal(d);
        BigDecimal bigDecimal2 = new BigDecimal(d3);
        for (int i = 0; i < n; ++i) {
            dArray[i] = bigDecimal.doubleValue();
            bigDecimal = bigDecimal.add(bigDecimal2);
        }
        return dArray;
    }

    public static double[] promote(int[] nArray) {
        double[] dArray = new double[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            dArray[i] = nArray[i];
        }
        return dArray;
    }

    @Deprecated
    public static double[] logLikelihoodsToProbs(double[] dArray) {
        return MathUtil.pNormalizeLogProbability(dArray);
    }

    public static double[] pNormalizeLogProbability(double[] dArray) {
        double d = MathUtil.max(dArray);
        double d2 = 300.0 - d;
        double[] dArray2 = new double[dArray.length];
        double d3 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = Math.pow(10.0, dArray[i] + d2);
            d3 += dArray2[i];
        }
        double d4 = (double)1.110223E-16f / (double)(dArray2.length - 1);
        for (int i = 0; i < dArray.length; ++i) {
            int n = i;
            dArray2[n] = dArray2[n] / d3;
            if (dArray2[i] > 0.9999999999999999) {
                dArray2[i] = 0.9999999999999999;
                continue;
            }
            if (!(dArray2[i] < d4)) continue;
            dArray2[i] = d4;
        }
        return dArray2;
    }

    public static double[] divide(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Arrays must be of same length.");
        }
        int n = dArray.length;
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray3[i] = dArray[i] / dArray2[i];
        }
        return dArray3;
    }

    public static double[] pNormalizeVector(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        double d = MathUtil.sum(dArray);
        double d2 = (double)1.110223E-16f / (double)(dArray2.length - 1);
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i] / d;
            if (dArray2[i] > 0.9999999999999999) {
                dArray2[i] = 0.9999999999999999;
                continue;
            }
            if (!(dArray2[i] < d2)) continue;
            dArray2[i] = d2;
        }
        return dArray2;
    }

    public static double[] multiply(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Arrays must be of same length.");
        }
        int n = dArray.length;
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray3[i] = dArray[i] * dArray2[i];
        }
        return dArray3;
    }

    public static double[] sum(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Arrays must be of same length.");
        }
        int n = dArray.length;
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray3[i] = dArray[i] + dArray2[i];
        }
        return dArray3;
    }

    public static double sum(double[] dArray) {
        double d = 0.0;
        for (double d2 : dArray) {
            d += d2;
        }
        return d;
    }

    public static long sum(long[] lArray, int n, int n2) {
        long l = 0L;
        for (int i = n; i < n2; ++i) {
            l += lArray[i];
        }
        return l;
    }

    public static class LogMath {
        private final double base;
        private final double log_of_base;

        public double getLog_of_base() {
            return this.log_of_base;
        }

        private LogMath(double d) {
            this.base = d;
            this.log_of_base = Math.log(d);
        }

        public double getNonLogValue(double d) {
            return Math.pow(this.base, d);
        }

        public double getLogValue(double d) {
            return Math.log(d) / this.log_of_base;
        }

        public double[] getLogValue(double[] dArray) {
            double[] dArray2 = new double[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray2[i] = this.getLogValue(dArray[i]);
            }
            return dArray2;
        }

        public double mean(double ... dArray) {
            return this.sum(dArray) - this.getLogValue(dArray.length);
        }

        public double sum(double ... dArray) {
            double d = MathUtil.max(dArray);
            double d2 = 0.0;
            for (double d3 : dArray) {
                d2 += this.getNonLogValue(d3 - d);
            }
            return this.getLogValue(d2) + d;
        }

        public double product(double ... dArray) {
            return MathUtil.sum(dArray);
        }
    }
}

