/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.PeekableIterator;

public class QuerySortedReadPairIteratorUtil {
    public static ReadPair getNextReadPair(PeekableIterator<SAMRecord> peekableIterator) {
        ReadPair readPair = new ReadPair();
        readPair.read1 = QuerySortedReadPairIteratorUtil.getNextUsableRead(peekableIterator, false);
        if (readPair.read1 == null) {
            return null;
        }
        SAMRecord sAMRecord = QuerySortedReadPairIteratorUtil.getNextUsableRead(peekableIterator, true);
        if (sAMRecord != null && sAMRecord.getReadName().equals(readPair.read1.getReadName())) {
            readPair.read2 = QuerySortedReadPairIteratorUtil.getNextUsableRead(peekableIterator, false);
        }
        return readPair;
    }

    private static SAMRecord getNextUsableRead(PeekableIterator<SAMRecord> peekableIterator, boolean bl) {
        while (peekableIterator.hasNext()) {
            SAMRecord sAMRecord = (SAMRecord)peekableIterator.peek();
            if (sAMRecord.getReadFailsVendorQualityCheckFlag() || sAMRecord.isSecondaryOrSupplementary()) {
                peekableIterator.next();
                continue;
            }
            return bl ? sAMRecord : (SAMRecord)peekableIterator.next();
        }
        return null;
    }

    public static class ReadPair {
        public SAMRecord read1 = null;
        public SAMRecord read2 = null;
    }
}

