/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProcessExecutor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import picard.PicardException;

public class RExecutor {
    private static final Log LOG = Log.getInstance(RExecutor.class);
    private static final String R_EXE = "Rscript";

    public static int executeFromClasspath(String string, String ... stringArray) {
        File file = RExecutor.writeScriptFile(string);
        int n = RExecutor.executeFromFile(file, stringArray);
        IOUtil.deleteFiles((File[])new File[]{file});
        return n;
    }

    public static int executeFromFile(File file, String ... stringArray) {
        String[] stringArray2 = new String[stringArray.length + 2];
        stringArray2[0] = R_EXE;
        stringArray2[1] = file.getAbsolutePath();
        System.arraycopy(stringArray, 0, stringArray2, 2, stringArray.length);
        LOG.info(new Object[]{String.format("Executing R script via command: %s", CollectionUtil.join(Arrays.asList(stringArray2), (String)" "))});
        return ProcessExecutor.execute((String[])stringArray2);
    }

    private static File writeScriptFile(String string) {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = RExecutor.class.getClassLoader().getResourceAsStream(string);
            if (inputStream == null) {
                throw new IllegalArgumentException("Script [" + string + "] not found in classpath");
            }
            File file = File.createTempFile("script", ".R");
            outputStream = IOUtil.openFileForWriting((File)file);
            IOUtil.copyStream((InputStream)inputStream, (OutputStream)outputStream);
            File file2 = file;
            return file2;
        }
        catch (IOException iOException) {
            throw new PicardException("Unexpected exception creating R script file [" + string + "]", iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

