/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestNGUtil {
    static final double EPSILON = 1.0E-300;

    public static Object[][] generateDataProvider(TestNGParameterizable[] testNGParameterizableArray) {
        return TestNGUtil.generateDataProvider(Arrays.asList(testNGParameterizableArray));
    }

    public static Object[][] generateDataProvider(Iterable<? extends TestNGParameterizable> iterable) {
        Iterator<? extends TestNGParameterizable> iterator = iterable.iterator();
        LinkedList<Object[]> linkedList = new LinkedList<Object[]>();
        while (iterator.hasNext()) {
            linkedList.add(iterator.next().toObjectArray());
        }
        Object[][] objectArray = new Object[linkedList.size()][];
        for (int i = 0; i < linkedList.size(); ++i) {
            objectArray[i] = (Object[])linkedList.get(i);
        }
        return objectArray;
    }

    public static boolean compareDoubleWithAccuracy(double d, double d2, double d3) {
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("Accuracy must be positive.");
        }
        return Math.abs(d - d2) / (Math.abs(d) + Math.abs(d2) + 1.0E-300) < d3;
    }

    public static void assertEqualDoubleArrays(double[] dArray, double[] dArray2, double d) {
        Assert.assertNotNull((Object)dArray);
        Assert.assertNotNull((Object)dArray2);
        if (d <= 0.0) {
            throw new IllegalArgumentException("Accuracy must be positive.");
        }
        Assert.assertEquals((int)dArray.length, (int)dArray2.length, (String)("Arrays not same length: " + dArray.length + " vs. " + dArray2.length));
        for (int i = 0; i < dArray.length; ++i) {
            Assert.assertTrue((boolean)TestNGUtil.compareDoubleWithAccuracy(dArray[i], dArray2[i], d), (String)("Arrays disagree at position " + i + ":  " + dArray[i] + " vs. " + dArray2[i] + ". "));
        }
    }

    public static class TestNGParameterizable {
        public Object[] toObjectArray() {
            return new Object[]{this};
        }
    }

    public static abstract class SingleTestUnitTest<TestClazz extends TestNGParameterizable> {
        @DataProvider(name="testcases")
        Object[][] getParams() {
            return TestNGUtil.generateDataProvider(this.getTestcases());
        }

        @Test(dataProvider="testcases")
        public void doMetaTest(TestClazz TestClazz) {
            this.doTest(TestClazz);
        }

        public abstract Iterable<TestClazz> getTestcases();

        public abstract void doTest(TestClazz var1);
    }
}

