/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFFileReader;
import java.util.Iterator;

public class ByIntervalListVariantContextIterator
implements Iterator<VariantContext> {
    private final VCFFileReader reader;
    private final Iterator<Interval> intervals;
    private CloseableIterator<VariantContext> currentIterator;

    public ByIntervalListVariantContextIterator(VCFFileReader vCFFileReader, IntervalList intervalList) {
        this.reader = vCFFileReader;
        this.intervals = intervalList.uniqued().iterator();
    }

    private void advance() {
        while ((this.currentIterator == null || !this.currentIterator.hasNext()) && this.intervals.hasNext()) {
            if (this.currentIterator != null) {
                this.currentIterator.close();
            }
            Interval interval = this.intervals.next();
            this.currentIterator = this.reader.query(interval.getSequence(), interval.getStart(), interval.getEnd());
        }
    }

    @Override
    public boolean hasNext() {
        this.advance();
        return this.currentIterator.hasNext();
    }

    @Override
    public VariantContext next() {
        this.advance();
        return (VariantContext)this.currentIterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

