/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import picard.util.DbSnpBitSetUtil;
import picard.vcf.CollectVariantCallingMetrics;
import picard.vcf.processor.VariantProcessor;

public class CallingMetricAccumulator
implements VariantProcessor.Accumulator<Result> {
    private static final Log LOG = Log.getInstance(CallingMetricAccumulator.class);
    private static final ProgressLogger progress = new ProgressLogger(LOG, 10000);
    private final DbSnpBitSetUtil.DbSnpBitSets dbsnp;
    private final CollectVariantCallingMetrics.VariantCallingSummaryMetrics summaryMetric = new CollectVariantCallingMetrics.VariantCallingSummaryMetrics();
    private final CollectionUtil.DefaultingMap<String, CollectVariantCallingMetrics.VariantCallingDetailMetrics> sampleMetricsMap = new CollectionUtil.DefaultingMap((CollectionUtil.DefaultingMap.Factory)new CollectionUtil.DefaultingMap.Factory<CollectVariantCallingMetrics.VariantCallingDetailMetrics, String>(){

        public CollectVariantCallingMetrics.VariantCallingDetailMetrics make(String string) {
            CollectVariantCallingMetrics.VariantCallingDetailMetrics variantCallingDetailMetrics = new CollectVariantCallingMetrics.VariantCallingDetailMetrics();
            variantCallingDetailMetrics.SAMPLE_ALIAS = string;
            return variantCallingDetailMetrics;
        }
    }, true);

    public CallingMetricAccumulator(DbSnpBitSetUtil.DbSnpBitSets dbSnpBitSets) {
        this.dbsnp = dbSnpBitSets;
    }

    @Override
    public void accumulate(VariantContext variantContext) {
        progress.record(variantContext.getChr(), variantContext.getStart());
        if (!this.isVariantExcluded(variantContext)) {
            String string = this.getSingletonSample(variantContext);
            this.updateSummaryMetric(this.summaryMetric, null, variantContext, string != null);
            for (String string2 : variantContext.getSampleNames()) {
                if (variantContext.getGenotype(string2).isHomRef()) continue;
                this.updateDetailMetric((CollectVariantCallingMetrics.VariantCallingDetailMetrics)((Object)this.sampleMetricsMap.get((Object)string2)), variantContext.getGenotype(string2), variantContext, string2.equals(string));
            }
        }
    }

    private String getSingletonSample(VariantContext variantContext) {
        String string = null;
        for (String string2 : variantContext.getSampleNames()) {
            Genotype genotype = variantContext.getGenotype(string2);
            if (genotype.isHomVar()) {
                return null;
            }
            if (!genotype.isHet()) continue;
            if (string != null) {
                return null;
            }
            string = string2;
        }
        return string;
    }

    @Override
    public Result result() {
        Collection collection = this.sampleMetricsMap.values();
        for (CollectVariantCallingMetrics.VariantCallingDetailMetrics variantCallingDetailMetrics : collection) {
            variantCallingDetailMetrics.updateDerivedValuesInPlace();
        }
        this.summaryMetric.updateDerivedValuesInPlace();
        return new Result(this.summaryMetric, collection);
    }

    private boolean isVariantExcluded(VariantContext variantContext) {
        if (!variantContext.isVariant()) {
            return true;
        }
        for (String string : variantContext.getSampleNames()) {
            if (variantContext.getGenotype(string).isHomRef()) continue;
            return false;
        }
        return true;
    }

    private void updateDetailMetric(CollectVariantCallingMetrics.VariantCallingDetailMetrics variantCallingDetailMetrics, Genotype genotype, VariantContext variantContext, boolean bl) {
        this.updateSummaryMetric(variantCallingDetailMetrics, genotype, variantContext, bl);
        if (genotype != null && !variantContext.isFiltered()) {
            if (genotype.isHet()) {
                ++variantCallingDetailMetrics.numHets;
            } else if (genotype.isHomVar()) {
                ++variantCallingDetailMetrics.numHomVar;
            }
        }
    }

    private void updateSummaryMetric(CollectVariantCallingMetrics.VariantCallingSummaryMetrics variantCallingSummaryMetrics, Genotype genotype, VariantContext variantContext, boolean bl) {
        if (genotype != null && genotype.isNoCall()) {
            return;
        }
        if (variantContext.isFiltered()) {
            if (variantContext.isSNP()) {
                ++variantCallingSummaryMetrics.FILTERED_SNPS;
            } else if (variantContext.isIndel()) {
                ++variantCallingSummaryMetrics.FILTERED_INDELS;
            }
            return;
        }
        if (bl) {
            ++variantCallingSummaryMetrics.NUM_SINGLETONS;
        }
        if (variantContext.isBiallelic() && variantContext.isSNP()) {
            boolean bl2 = this.dbsnp.snps.isDbSnpSite(variantContext.getChr(), variantContext.getStart());
            boolean bl3 = CallingMetricAccumulator.isTransition(variantContext);
            ++variantCallingSummaryMetrics.TOTAL_SNPS;
            if (bl2) {
                ++variantCallingSummaryMetrics.NUM_IN_DB_SNP;
                if (bl3) {
                    ++variantCallingSummaryMetrics.dbSnpTransitions;
                } else {
                    ++variantCallingSummaryMetrics.dbSnpTransversions;
                }
            } else if (bl3) {
                ++variantCallingSummaryMetrics.novelTransitions;
            } else {
                ++variantCallingSummaryMetrics.novelTransversions;
            }
            if (genotype != null && genotype.isHet()) {
                int[] nArray = genotype.getAD();
                if (nArray != null) {
                    int n = variantContext.getAlleleIndex(variantContext.getReference());
                    int n2 = (n + 1) % 2;
                    variantCallingSummaryMetrics.refAlleleObs += (long)nArray[n];
                    variantCallingSummaryMetrics.altAlleleObs += (long)nArray[n2];
                    this.summaryMetric.refAlleleObs += (long)nArray[n];
                    this.summaryMetric.altAlleleObs += (long)nArray[n2];
                } else {
                    LOG.debug(new Object[]{"Skipping aggregation of genotype due to missing allele depth data: ", genotype, "."});
                }
            }
        } else if (variantContext.isSNP() && variantContext.getAlternateAlleles().size() > 1) {
            variantCallingSummaryMetrics.TOTAL_MULTIALLELIC_SNPS += 1.0;
            if (this.dbsnp.snps.isDbSnpSite(variantContext.getChr(), variantContext.getStart())) {
                variantCallingSummaryMetrics.NUM_IN_DB_SNP_MULTIALLELIC += 1.0;
            }
        } else if (variantContext.isIndel() && !variantContext.isComplexIndel()) {
            boolean bl4 = this.dbsnp.indels.isDbSnpSite(variantContext.getChr(), variantContext.getStart());
            boolean bl5 = variantContext.isSimpleInsertion();
            ++variantCallingSummaryMetrics.TOTAL_INDELS;
            if (bl4) {
                ++variantCallingSummaryMetrics.NUM_IN_DB_SNP_INDELS;
                if (bl5) {
                    ++variantCallingSummaryMetrics.dbSnpInsertions;
                } else {
                    ++variantCallingSummaryMetrics.dbSnpDeletions;
                }
            } else if (bl5) {
                ++variantCallingSummaryMetrics.novelInsertions;
            } else {
                ++variantCallingSummaryMetrics.novelDeletions;
            }
        } else if (variantContext.isComplexIndel()) {
            variantCallingSummaryMetrics.TOTAL_COMPLEX_INDELS += 1.0;
            if (this.dbsnp.indels.isDbSnpSite(variantContext.getChr(), variantContext.getStart())) {
                variantCallingSummaryMetrics.NUM_IN_DB_SNP_COMPLEX_INDELS += 1.0;
            }
        }
    }

    private static boolean isTransition(VariantContext variantContext) {
        byte by = variantContext.getReference().getBases()[0];
        List list = variantContext.getAlternateAlleles();
        Byte by2 = null;
        for (Allele allele : list) {
            if (allele.getBases()[0] == by) continue;
            by2 = allele.getBases()[0];
            break;
        }
        if (by2 == null) {
            throw new IllegalArgumentException("All alternate alleles match the reference base " + (char)by);
        }
        return by == 65 && by2 == 71 || by == 71 && by2 == 65 || by == 67 && by2 == 84 || by == 84 && by2 == 67;
    }

    public static class Result {
        final CollectVariantCallingMetrics.VariantCallingSummaryMetrics summary;
        final Collection<CollectVariantCallingMetrics.VariantCallingDetailMetrics> details;

        Result(CollectVariantCallingMetrics.VariantCallingSummaryMetrics variantCallingSummaryMetrics, Collection<CollectVariantCallingMetrics.VariantCallingDetailMetrics> collection) {
            this.summary = variantCallingSummaryMetrics;
            this.details = collection;
        }

        public static Result merge(Collection<Result> collection) {
            ArrayList<CollectVariantCallingMetrics.VariantCallingDetailMetrics> arrayList = new ArrayList<CollectVariantCallingMetrics.VariantCallingDetailMetrics>();
            ArrayList<CollectVariantCallingMetrics.VariantCallingSummaryMetrics> arrayList2 = new ArrayList<CollectVariantCallingMetrics.VariantCallingSummaryMetrics>();
            for (Result object2 : collection) {
                arrayList2.add(object2.summary);
                arrayList.addAll(object2.details);
            }
            Map map = CollectionUtil.partition(arrayList, (CollectionUtil.Partitioner)new CollectionUtil.Partitioner<CollectVariantCallingMetrics.VariantCallingDetailMetrics, String>(){

                public String getPartition(CollectVariantCallingMetrics.VariantCallingDetailMetrics variantCallingDetailMetrics) {
                    return variantCallingDetailMetrics.SAMPLE_ALIAS;
                }
            });
            ArrayList<CollectVariantCallingMetrics.VariantCallingDetailMetrics> arrayList3 = new ArrayList<CollectVariantCallingMetrics.VariantCallingDetailMetrics>();
            for (Collection collection2 : map.values()) {
                CollectVariantCallingMetrics.VariantCallingDetailMetrics variantCallingDetailMetrics = new CollectVariantCallingMetrics.VariantCallingDetailMetrics();
                CollectVariantCallingMetrics.VariantCallingDetailMetrics.foldInto(variantCallingDetailMetrics, collection2);
                arrayList3.add(variantCallingDetailMetrics);
            }
            Object object = new CollectVariantCallingMetrics.VariantCallingSummaryMetrics();
            CollectVariantCallingMetrics.VariantCallingSummaryMetrics.foldInto(object, arrayList2);
            return new Result((CollectVariantCallingMetrics.VariantCallingSummaryMetrics)((Object)object), (Collection<CollectVariantCallingMetrics.VariantCallingDetailMetrics>)arrayList3);
        }
    }
}

