/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.SAMFileReader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import htsjdk.variant.vcf.VCFFileReader;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Metrics;
import picard.util.DbSnpBitSetUtil;
import picard.vcf.CallingMetricAccumulator;
import picard.vcf.processor.VariantProcessor;

@CommandLineProgramProperties(usage="Collects per-sample and aggregate (spanning all samples) metrics from the provided VCF file.", usageShort="Collects per-sample and aggregate (spanning all samples) metrics from the provided VCF file", programGroup=Metrics.class)
public class CollectVariantCallingMetrics
extends CommandLineProgram {
    @Option(shortName="I", doc="Input vcf file for analysis")
    public File INPUT;
    @Option(shortName="O", doc="Path (except for the file extension) of output metrics files to write.")
    public File OUTPUT;
    @Option(doc="Reference dbSNP file in dbSNP or VCF format.")
    public File DBSNP;
    @Option(shortName="TI", doc="Target intervals to restrict analysis to.", optional=true)
    public File TARGET_INTERVALS;
    @Option(shortName="SD", optional=true, doc="If present, speeds loading of dbSNP file")
    public File SEQUENCE_DICTIONARY = null;
    @Option(doc="Deprecated option will be removed in a future release.")
    public Boolean REQUIRE_INDEX = false;
    @Option
    public int THREAD_COUNT = 1;
    private final Log log = Log.getInstance(CollectVariantCallingMetrics.class);

    public static void main(String[] stringArray) {
        new CollectVariantCallingMetrics().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        boolean bl = this.TARGET_INTERVALS != null || this.THREAD_COUNT > 1;
        VCFFileReader vCFFileReader = new VCFFileReader(this.INPUT, bl);
        SAMSequenceDictionary sAMSequenceDictionary = this.SEQUENCE_DICTIONARY != null ? SAMFileReader.getSequenceDictionary((File)this.SEQUENCE_DICTIONARY) : vCFFileReader.getFileHeader().getSequenceDictionary();
        CloserUtil.close((Object)vCFFileReader);
        this.log.info(new Object[]{"Loading dbSNP file ..."});
        final DbSnpBitSetUtil.DbSnpBitSets dbSnpBitSets = DbSnpBitSetUtil.createSnpAndIndelBitSets(this.DBSNP, sAMSequenceDictionary);
        this.log.info(new Object[]{"Starting iteration of variants."});
        VariantProcessor.Builder<CallingMetricAccumulator, CallingMetricAccumulator.Result> builder = VariantProcessor.Builder.generatingAccumulatorsBy(new VariantProcessor.AccumulatorGenerator<CallingMetricAccumulator, CallingMetricAccumulator.Result>(){

            @Override
            public CallingMetricAccumulator build() {
                return new CallingMetricAccumulator(dbSnpBitSets);
            }
        }).combiningResultsBy(new VariantProcessor.ResultMerger<CallingMetricAccumulator.Result>(){

            @Override
            public CallingMetricAccumulator.Result merge(Collection<CallingMetricAccumulator.Result> collection) {
                return CallingMetricAccumulator.Result.merge(collection);
            }
        }).withInput(this.INPUT).multithreadingBy(this.THREAD_COUNT);
        if (this.TARGET_INTERVALS != null) {
            builder.limitingProcessedRegionsTo(IntervalList.fromFile((File)this.TARGET_INTERVALS).uniqued());
        }
        CallingMetricAccumulator.Result result = builder.build().process();
        MetricsFile metricsFile = this.getMetricsFile();
        MetricsFile metricsFile2 = this.getMetricsFile();
        metricsFile2.addMetric((MetricBase)result.summary);
        for (VariantCallingDetailMetrics variantCallingDetailMetrics : result.details) {
            metricsFile.addMetric((MetricBase)variantCallingDetailMetrics);
        }
        String string = this.OUTPUT.getAbsolutePath() + ".";
        metricsFile.write(new File((String)string + VariantCallingDetailMetrics.getFileExtension()));
        metricsFile2.write(new File((String)string + VariantCallingSummaryMetrics.getFileExtension()));
        return 0;
    }

    public static class VariantCallingDetailMetrics
    extends VariantCallingSummaryMetrics {
        public String SAMPLE_ALIAS;
        public double HET_HOMVAR_RATIO;
        long numHets;
        long numHomVar;

        public static String getFileExtension() {
            return "variant_calling_detail_metrics";
        }

        public static void foldInto(VariantCallingDetailMetrics variantCallingDetailMetrics, Collection<VariantCallingDetailMetrics> collection) {
            VariantCallingSummaryMetrics.foldInto(variantCallingDetailMetrics, collection);
            HashSet<String> hashSet = new HashSet<String>();
            for (VariantCallingDetailMetrics variantCallingDetailMetrics2 : collection) {
                variantCallingDetailMetrics.numHets += variantCallingDetailMetrics2.numHets;
                variantCallingDetailMetrics.numHomVar += variantCallingDetailMetrics2.numHomVar;
                hashSet.add(variantCallingDetailMetrics2.SAMPLE_ALIAS);
            }
            variantCallingDetailMetrics.updateDerivedValuesInPlace();
            if (hashSet.size() != 1) {
                throw new IllegalArgumentException("Provided metrics do not have the same sample name.");
            }
            variantCallingDetailMetrics.SAMPLE_ALIAS = (String)hashSet.iterator().next();
        }

        @Override
        public void updateDerivedValuesInPlace() {
            super.updateDerivedValuesInPlace();
            this.HET_HOMVAR_RATIO = (double)this.numHets / (double)this.numHomVar;
        }
    }

    public static class VariantCallingSummaryMetrics
    extends MetricBase {
        public long TOTAL_SNPS;
        public long NUM_IN_DB_SNP;
        public long NOVEL_SNPS;
        public long FILTERED_SNPS;
        public float PCT_DBSNP;
        public double DBSNP_TITV;
        public double NOVEL_TITV;
        public long TOTAL_INDELS;
        public long NOVEL_INDELS;
        public long FILTERED_INDELS;
        public float PCT_DBSNP_INDELS;
        public long NUM_IN_DB_SNP_INDELS;
        public double DBSNP_INS_DEL_RATIO;
        public double NOVEL_INS_DEL_RATIO;
        public double TOTAL_MULTIALLELIC_SNPS;
        public double NUM_IN_DB_SNP_MULTIALLELIC;
        public double TOTAL_COMPLEX_INDELS;
        public double NUM_IN_DB_SNP_COMPLEX_INDELS;
        public double SNP_REFERENCE_BIAS;
        public long NUM_SINGLETONS;
        long refAlleleObs;
        long altAlleleObs;
        long novelDeletions;
        long novelInsertions;
        long novelTransitions;
        long novelTransversions;
        long dbSnpDeletions;
        long dbSnpInsertions;
        long dbSnpTransitions;
        long dbSnpTransversions;

        public static String getFileExtension() {
            return "variant_calling_summary_metrics";
        }

        public void updateDerivedValuesInPlace() {
            this.PCT_DBSNP = (float)this.NUM_IN_DB_SNP / (float)this.TOTAL_SNPS;
            this.NOVEL_SNPS = this.TOTAL_SNPS - this.NUM_IN_DB_SNP;
            this.SNP_REFERENCE_BIAS = (double)this.refAlleleObs / (double)(this.refAlleleObs + this.altAlleleObs);
            if (this.dbSnpTransversions > 0L) {
                this.DBSNP_TITV = (double)this.dbSnpTransitions / (double)this.dbSnpTransversions;
            }
            if (this.novelTransversions > 0L) {
                this.NOVEL_TITV = (double)this.novelTransitions / (double)this.novelTransversions;
            }
            this.PCT_DBSNP_INDELS = (float)this.NUM_IN_DB_SNP_INDELS / (float)this.TOTAL_INDELS;
            this.NOVEL_INDELS = this.TOTAL_INDELS - this.NUM_IN_DB_SNP_INDELS;
            if (this.dbSnpDeletions > 0L) {
                this.DBSNP_INS_DEL_RATIO = (double)this.dbSnpInsertions / (double)this.dbSnpDeletions;
            }
            if (this.novelDeletions > 0L) {
                this.NOVEL_INS_DEL_RATIO = (double)this.novelInsertions / (double)this.novelDeletions;
            }
        }

        public static <T extends VariantCallingSummaryMetrics> void foldInto(T t, Collection<T> collection) {
            for (VariantCallingSummaryMetrics variantCallingSummaryMetrics : collection) {
                t.TOTAL_SNPS += variantCallingSummaryMetrics.TOTAL_SNPS;
                t.NUM_IN_DB_SNP += variantCallingSummaryMetrics.NUM_IN_DB_SNP;
                t.FILTERED_SNPS += variantCallingSummaryMetrics.FILTERED_SNPS;
                t.TOTAL_INDELS += variantCallingSummaryMetrics.TOTAL_INDELS;
                t.FILTERED_INDELS += variantCallingSummaryMetrics.FILTERED_INDELS;
                t.NUM_IN_DB_SNP_INDELS += variantCallingSummaryMetrics.NUM_IN_DB_SNP_INDELS;
                t.TOTAL_MULTIALLELIC_SNPS += variantCallingSummaryMetrics.TOTAL_MULTIALLELIC_SNPS;
                t.NUM_IN_DB_SNP_MULTIALLELIC += variantCallingSummaryMetrics.NUM_IN_DB_SNP_MULTIALLELIC;
                t.TOTAL_COMPLEX_INDELS += variantCallingSummaryMetrics.TOTAL_COMPLEX_INDELS;
                t.NUM_IN_DB_SNP_COMPLEX_INDELS += variantCallingSummaryMetrics.NUM_IN_DB_SNP_COMPLEX_INDELS;
                t.NUM_SINGLETONS += variantCallingSummaryMetrics.NUM_SINGLETONS;
                t.refAlleleObs += variantCallingSummaryMetrics.refAlleleObs;
                t.altAlleleObs += variantCallingSummaryMetrics.altAlleleObs;
                t.novelDeletions += variantCallingSummaryMetrics.novelDeletions;
                t.novelInsertions += variantCallingSummaryMetrics.novelInsertions;
                t.novelTransitions += variantCallingSummaryMetrics.novelTransitions;
                t.novelTransversions += variantCallingSummaryMetrics.novelTransversions;
                t.dbSnpDeletions += variantCallingSummaryMetrics.dbSnpDeletions;
                t.dbSnpInsertions += variantCallingSummaryMetrics.dbSnpInsertions;
                t.dbSnpTransitions += variantCallingSummaryMetrics.dbSnpTransitions;
                t.dbSnpTransversions += variantCallingSummaryMetrics.dbSnpTransversions;
            }
            t.updateDerivedValuesInPlace();
        }
    }
}

