/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.samtools.util.BlockCompressedStreamConstants;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.PeekableIterator;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextComparator;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterFactory;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.VcfOrBcf;

@CommandLineProgramProperties(usage="Gathers multiple VCF files from a scatter operation into a single VCF file. Input files must be supplied in genomic order and must not have events at overlapping positions.", usageShort="Gathers multiple VCF files from a scatter operation into a single VCF file", programGroup=VcfOrBcf.class)
public class GatherVcfs
extends CommandLineProgram {
    @Option(shortName="I", doc="Input VCF file(s).")
    public List<File> INPUT;
    @Option(shortName="O", doc="Output VCF file.")
    public File OUTPUT;
    private static final Log log = Log.getInstance(GatherVcfs.class);

    public static void main(String[] stringArray) {
        new GatherVcfs().instanceMainWithExit(stringArray);
    }

    public GatherVcfs() {
        this.CREATE_INDEX = true;
    }

    @Override
    protected int doWork() {
        log.info(new Object[]{"Checking inputs."});
        this.INPUT = IOUtil.unrollFiles(this.INPUT, (String[])IOUtil.VCF_EXTENSIONS);
        for (File file : this.INPUT) {
            IOUtil.assertFileIsReadable((File)file);
        }
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        SAMSequenceDictionary sAMSequenceDictionary = VCFFileReader.getSequenceDictionary((File)this.INPUT.get(0));
        if (this.CREATE_INDEX.booleanValue() && sAMSequenceDictionary == null) {
            throw new PicardException("In order to index the resulting VCF input VCFs must contain ##contig lines.");
        }
        log.info(new Object[]{"Checking file headers and first records to ensure compatibility."});
        GatherVcfs.assertSameSamplesAndValidOrdering(this.INPUT);
        if (this.areAllBlockCompressed(this.INPUT) && this.areAllBlockCompressed(CollectionUtil.makeList((Object[])new File[]{this.OUTPUT}))) {
            log.info(new Object[]{"Gathering by copying gzip blocks. Will not be able to validate position non-overlap of files."});
            if (this.CREATE_INDEX.booleanValue()) {
                log.warn(new Object[]{"Index creation not currently supported when gathering block compressed VCFs."});
            }
            GatherVcfs.gatherWithBlockCopying(this.INPUT, this.OUTPUT);
        } else {
            log.info(new Object[]{"Gathering by conventional means."});
            GatherVcfs.gatherConventionally(sAMSequenceDictionary, this.CREATE_INDEX, this.INPUT, this.OUTPUT);
        }
        return 0;
    }

    private boolean areAllBlockCompressed(List<File> list) {
        for (File file : list) {
            if (!VariantContextWriterFactory.isBCFOutput((File)file) && VariantContextWriterFactory.isCompressedVcf((File)file)) continue;
            return false;
        }
        return true;
    }

    private static void assertSameSamplesAndValidOrdering(List<File> list) {
        VCFHeader vCFHeader = new VCFFileReader(list.get(0), false).getFileHeader();
        SAMSequenceDictionary sAMSequenceDictionary = vCFHeader.getSequenceDictionary();
        VariantContextComparator variantContextComparator = new VariantContextComparator(vCFHeader.getSequenceDictionary());
        List list2 = vCFHeader.getGenotypeSamples();
        File file = null;
        VariantContext variantContext = null;
        for (File file2 : list) {
            VariantContext variantContext2;
            Object object;
            VCFFileReader vCFFileReader = new VCFFileReader(file2, false);
            sAMSequenceDictionary.assertSameDictionary(vCFFileReader.getFileHeader().getSequenceDictionary());
            List list3 = vCFFileReader.getFileHeader().getGenotypeSamples();
            if (!list2.equals(list3)) {
                object = new TreeSet(list2);
                variantContext2 = new TreeSet(list3);
                object.removeAll(list3);
                variantContext2.removeAll(list2);
                throw new IllegalArgumentException("VCFs do not have identical sample lists. Samples unique to first file: " + object + ". Samples unique to " + file2.getAbsolutePath() + ": " + variantContext2 + ".");
            }
            object = vCFFileReader.iterator();
            if (object.hasNext()) {
                variantContext2 = (VariantContext)object.next();
                if (variantContext != null && variantContextComparator.compare(variantContext, variantContext2) >= 0) {
                    throw new IllegalArgumentException("First record in file " + file2.getAbsolutePath() + " is not after first record in " + "previous file " + file.getAbsolutePath());
                }
                variantContext = variantContext2;
                file = file2;
            }
            CloserUtil.close((Object)vCFFileReader);
        }
    }

    private static void gatherConventionally(SAMSequenceDictionary sAMSequenceDictionary, boolean bl, List<File> list, File file) {
        EnumSet<Options> enumSet = EnumSet.copyOf(VariantContextWriterFactory.DEFAULT_OPTIONS);
        if (bl) {
            enumSet.add(Options.INDEX_ON_THE_FLY);
        } else {
            enumSet.remove(Options.INDEX_ON_THE_FLY);
        }
        VariantContextWriter variantContextWriter = VariantContextWriterFactory.create((File)file, (SAMSequenceDictionary)sAMSequenceDictionary, enumSet);
        ProgressLogger progressLogger = new ProgressLogger(log, 10000);
        VariantContext variantContext = null;
        File file2 = null;
        VCFHeader vCFHeader = null;
        VariantContextComparator variantContextComparator = null;
        for (File file3 : list) {
            VariantContext variantContext2;
            log.debug(new Object[]{"Gathering from file: ", file3.getAbsolutePath()});
            VCFFileReader vCFFileReader = new VCFFileReader(file3, false);
            PeekableIterator peekableIterator = new PeekableIterator((Iterator)vCFFileReader.iterator());
            VCFHeader vCFHeader2 = vCFFileReader.getFileHeader();
            if (vCFHeader == null) {
                vCFHeader = vCFHeader2;
                variantContextWriter.writeHeader(vCFHeader);
                variantContextComparator = new VariantContextComparator((Collection)vCFHeader.getContigLines());
            }
            if (variantContext != null && peekableIterator.hasNext() && variantContextComparator.compare(variantContext2 = (VariantContext)peekableIterator.peek(), variantContext) <= 0) {
                throw new IllegalStateException("First variant in file " + file3.getAbsolutePath() + " is at " + variantContext2.getSource() + " but last variant in earlier file " + file2.getAbsolutePath() + " is at " + variantContext.getSource());
            }
            while (peekableIterator.hasNext()) {
                variantContext = (VariantContext)peekableIterator.next();
                variantContextWriter.add(variantContext);
                progressLogger.record(variantContext.getChr(), variantContext.getStart());
            }
            file2 = file3;
            CloserUtil.close((Object)peekableIterator);
            CloserUtil.close((Object)vCFFileReader);
        }
        variantContextWriter.close();
    }

    private static void gatherWithBlockCopying(List<File> list, File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            boolean bl = true;
            for (File file2 : list) {
                log.info(new Object[]{"Gathering " + file2.getAbsolutePath()});
                FileInputStream fileInputStream = new FileInputStream(file2);
                BlockCompressedInputStream.FileTermination fileTermination = BlockCompressedInputStream.checkTermination((File)file2);
                if (fileTermination == BlockCompressedInputStream.FileTermination.DEFECTIVE) {
                    throw new PicardException(file2.getAbsolutePath() + " does not have a valid GZIP block at the end of the file.");
                }
                if (!bl) {
                    BlockCompressedInputStream blockCompressedInputStream = new BlockCompressedInputStream((InputStream)fileInputStream, false);
                    boolean bl2 = true;
                    while (fileInputStream.available() > 0) {
                        int n = blockCompressedInputStream.available();
                        byte[] byArray = new byte[n];
                        int n2 = blockCompressedInputStream.read(byArray);
                        if (n == 0 || n2 != n) {
                            throw new IllegalStateException("Could not read available bytes from BlockCompressedInputStream.");
                        }
                        int n3 = -1;
                        for (int i = 0; i < n2; ++i) {
                            boolean bl3;
                            byte by = byArray[i];
                            boolean bl4 = bl3 = by == 10 || by == 13;
                            if (bl2 && !bl3 && by != 35) {
                                n3 = i;
                                break;
                            }
                            bl2 = bl3;
                        }
                        if (n3 < 0) continue;
                        BlockCompressedOutputStream blockCompressedOutputStream = new BlockCompressedOutputStream((OutputStream)fileOutputStream, null);
                        blockCompressedOutputStream.write(byArray, n3, byArray.length - n3);
                        blockCompressedOutputStream.flush();
                        break;
                    }
                }
                long l = fileInputStream.getChannel().position();
                long l2 = file2.length();
                long l3 = fileTermination == BlockCompressedInputStream.FileTermination.HAS_TERMINATOR_BLOCK ? (long)BlockCompressedStreamConstants.EMPTY_GZIP_BLOCK.length : 0L;
                long l4 = l2 - l3 - l;
                IOUtil.transferByStream((InputStream)fileInputStream, (OutputStream)fileOutputStream, (long)l4);
                fileInputStream.close();
                bl = false;
            }
            fileOutputStream.write(BlockCompressedStreamConstants.EMPTY_GZIP_BLOCK);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new RuntimeIOException((Throwable)iOException);
        }
    }
}

