/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.metrics.MetricBase;
import htsjdk.variant.variantcontext.VariantContext;
import picard.vcf.GenotypeConcordanceCounts;
import picard.vcf.GenotypeConcordanceScheme;
import picard.vcf.GenotypeConcordanceSchemeFactory;

public class GenotypeConcordanceSummaryMetrics
extends MetricBase {
    public VariantContext.Type VARIANT_TYPE;
    public String TRUTH_SAMPLE;
    public String CALL_SAMPLE;
    public double HET_SENSITIVITY;
    public double HET_PPV;
    public double HET_SPECIFICITY;
    public double HOMVAR_SENSITIVITY;
    public double HOMVAR_PPV;
    public double HOMVAR_SPECIFICITY;
    public double VAR_SENSITIVITY;
    public double VAR_PPV;
    public double VAR_SPECIFICITY;
    public double GENOTYPE_CONCORDANCE;
    public double NON_REF_GENOTYPE_CONCORDANCE;

    public GenotypeConcordanceSummaryMetrics() {
    }

    GenotypeConcordanceSummaryMetrics(VariantContext.Type type, GenotypeConcordanceCounts genotypeConcordanceCounts, String string, String string2, boolean bl) {
        this.VARIANT_TYPE = type;
        this.TRUTH_SAMPLE = string;
        this.CALL_SAMPLE = string2;
        GenotypeConcordanceSchemeFactory genotypeConcordanceSchemeFactory = new GenotypeConcordanceSchemeFactory();
        GenotypeConcordanceScheme genotypeConcordanceScheme = genotypeConcordanceSchemeFactory.getScheme(bl);
        genotypeConcordanceScheme.validateScheme();
        genotypeConcordanceCounts.validateCountsAgainstScheme(genotypeConcordanceScheme);
        this.HET_SENSITIVITY = genotypeConcordanceCounts.getSensitivity(genotypeConcordanceScheme, GenotypeConcordanceCounts.HET_TRUTH_STATES);
        this.HET_PPV = genotypeConcordanceCounts.Ppv(genotypeConcordanceScheme, GenotypeConcordanceCounts.HET_CALL_STATES);
        this.HET_SPECIFICITY = Double.NaN;
        this.HOMVAR_SENSITIVITY = genotypeConcordanceCounts.getSensitivity(genotypeConcordanceScheme, GenotypeConcordanceCounts.HOM_VAR_TRUTH_STATES);
        this.HOMVAR_PPV = genotypeConcordanceCounts.Ppv(genotypeConcordanceScheme, GenotypeConcordanceCounts.HOM_VAR_CALL_STATES);
        this.HOMVAR_SPECIFICITY = Double.NaN;
        this.VAR_SENSITIVITY = genotypeConcordanceCounts.getSensitivity(genotypeConcordanceScheme, GenotypeConcordanceCounts.VAR_TRUTH_STATES);
        this.VAR_PPV = genotypeConcordanceCounts.Ppv(genotypeConcordanceScheme, GenotypeConcordanceCounts.VAR_CALL_STATES);
        this.VAR_SPECIFICITY = genotypeConcordanceCounts.getSpecificity(genotypeConcordanceScheme, GenotypeConcordanceCounts.VAR_TRUTH_STATES);
        this.GENOTYPE_CONCORDANCE = genotypeConcordanceCounts.calculateGenotypeConcordance(genotypeConcordanceScheme, bl);
        this.NON_REF_GENOTYPE_CONCORDANCE = genotypeConcordanceCounts.calculateNonRefGenotypeConcordance(genotypeConcordanceScheme, bl);
    }
}

