/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.liftover.LiftOver;
import htsjdk.samtools.reference.ReferenceSequenceFileWalker;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.SortingCollection;
import htsjdk.samtools.util.StringUtil;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFFilterHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFRecordCodec;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.VcfOrBcf;

@CommandLineProgramProperties(usage="Lifts a VCF over from one genome build to another using UCSC liftover. The output file will be sorted and indexed. Records may be rejected because they cannot be lifted over or because post-liftover the reference allele mismatches the target genome build.  Rejected records will be emitted with filters to the REJECT file, on the source genome.", usageShort="Lifts a VCF between genome builds.", programGroup=VcfOrBcf.class)
public class LiftoverVcf
extends CommandLineProgram {
    @Option(shortName="I", doc="The input VCF/BCF file to be lifted over.")
    public File INPUT;
    @Option(shortName="O", doc="The output location to write the lifted over VCF/BCF to.")
    public File OUTPUT;
    @Option(shortName="C", doc="The liftover chain file. See https://genome.ucsc.edu/goldenPath/help/chain.html for a description of chain files.  See http://hgdownload.soe.ucsc.edu/downloads.html#terms for where to download chain files.")
    public File CHAIN;
    @Option(doc="File to which to write rejected records.")
    public File REJECT;
    @Option(shortName="R", common=false, doc="The reference sequence (fasta) for the TARGET genome build.  The fasta file must have an accompanying sqeuence dictionary (.dict file).")
    public File REFERENCE_SEQUENCE = Defaults.REFERENCE_FASTA;
    public static final String FILTER_CANNOT_LIFTOVER_INDEL = "ReverseComplementedIndel";
    public static final String FILTER_NO_TARGET = "NoTarget";
    public static final String FILTER_MISMATCHING_REF_ALLELE = "MismatchedRefAllele";
    private static final List<VCFFilterHeaderLine> FILTERS = CollectionUtil.makeList((Object[])new VCFFilterHeaderLine[]{new VCFFilterHeaderLine("ReverseComplementedIndel", "Indel falls into a reverse complemented region in the target genome."), new VCFFilterHeaderLine("NoTarget", "Variant could not be lifted between genome builds."), new VCFFilterHeaderLine("MismatchedRefAllele", "Reference allele does not match reference genome sequence after liftover.")});
    private final Log log = Log.getInstance(LiftoverVcf.class);

    public static void main(String[] stringArray) {
        new LiftoverVcf().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        Object object2;
        SAMSequenceRecord sAMSequenceRecord2;
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsReadable((File)this.REFERENCE_SEQUENCE);
        IOUtil.assertFileIsReadable((File)this.CHAIN);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        IOUtil.assertFileIsWritable((File)this.REJECT);
        LiftOver liftOver = new LiftOver(this.CHAIN);
        VCFFileReader vCFFileReader = new VCFFileReader(this.INPUT, false);
        this.log.info(new Object[]{"Loading up the target reference genome."});
        ReferenceSequenceFileWalker referenceSequenceFileWalker = new ReferenceSequenceFileWalker(this.REFERENCE_SEQUENCE);
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        for (SAMSequenceRecord sAMSequenceRecord2 : referenceSequenceFileWalker.getSequenceDictionary().getSequences()) {
            hashMap.put(sAMSequenceRecord2.getSequenceName(), referenceSequenceFileWalker.get(sAMSequenceRecord2.getSequenceIndex()).getBases());
        }
        CloserUtil.close((Object)referenceSequenceFileWalker);
        VCFHeader vCFHeader = vCFFileReader.getFileHeader();
        sAMSequenceRecord2 = new VCFHeader(vCFHeader);
        sAMSequenceRecord2.setSequenceDictionary(referenceSequenceFileWalker.getSequenceDictionary());
        VariantContextWriter variantContextWriter = new VariantContextWriterBuilder().setOption(Options.INDEX_ON_THE_FLY).setOutputFile(this.OUTPUT).setReferenceDictionary(referenceSequenceFileWalker.getSequenceDictionary()).build();
        variantContextWriter.writeHeader((VCFHeader)sAMSequenceRecord2);
        VariantContextWriter variantContextWriter2 = new VariantContextWriterBuilder().setOutputFile(this.REJECT).unsetOption(Options.INDEX_ON_THE_FLY).build();
        VCFHeader vCFHeader2 = new VCFHeader(vCFFileReader.getFileHeader());
        for (VCFFilterHeaderLine vCFFilterHeaderLine : FILTERS) {
            vCFHeader2.addMetaDataLine((VCFHeaderLine)vCFFilterHeaderLine);
        }
        variantContextWriter2.writeHeader(vCFHeader2);
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        this.log.info(new Object[]{"Lifting variants over and sorting."});
        SortingCollection sortingCollection = SortingCollection.newInstance(VariantContext.class, (SortingCollection.Codec)new VCFRecordCodec((VCFHeader)sAMSequenceRecord2, this.VALIDATION_STRINGENCY != ValidationStringency.STRICT), (Comparator)sAMSequenceRecord2.getVCFRecordComparator(), (int)this.MAX_RECORDS_IN_RAM, (Collection)this.TMP_DIR);
        ProgressLogger progressLogger = new ProgressLogger(this.log, 1000000, "read");
        HashMap<Allele, Allele> hashMap2 = new HashMap<Allele, Allele>(10);
        for (Object object2 : vCFFileReader) {
            Object object3;
            ++l3;
            Interval interval = new Interval(object2.getContig(), object2.getStart(), object2.getEnd(), false, object2.getContig() + ":" + object2.getStart() + "-" + object2.getEnd());
            Interval interval2 = liftOver.liftOver(interval, 1.0);
            if (interval2 == null || interval2.isNegativeStrand() && (object2.isMixed() || object2.isIndel())) {
                object3 = interval2 == null ? FILTER_NO_TARGET : FILTER_CANNOT_LIFTOVER_INDEL;
                variantContextWriter2.add(new VariantContextBuilder(object2).filter((String)object3).make());
                ++l;
            } else {
                hashMap2.clear();
                object3 = new ArrayList();
                for (Allele allele : object2.getAlleles()) {
                    if (interval2.isPositiveStrand() || allele.isSymbolic()) {
                        object3.add(allele);
                        continue;
                    }
                    Allele allele2 = Allele.create((String)SequenceUtil.reverseComplement((String)allele.getBaseString()), (boolean)allele.isReference());
                    object3.add(allele2);
                    hashMap2.put(allele, allele2);
                }
                VariantContextBuilder variantContextBuilder = new VariantContextBuilder(object2.getSource(), interval2.getContig(), (long)interval2.getStart(), (long)interval2.getEnd(), (Collection)object3);
                variantContextBuilder.id(object2.getID());
                variantContextBuilder.attributes(object2.getAttributes());
                variantContextBuilder.genotypes(LiftoverVcf.fixGenotypes(object2.getGenotypes(), hashMap2));
                variantContextBuilder.filters(object2.getFilters());
                variantContextBuilder.log10PError(object2.getLog10PError());
                boolean bl = false;
                for (Allele allele : variantContextBuilder.getAlleles()) {
                    if (!allele.isReference()) continue;
                    byte[] byArray = (byte[])hashMap.get(interval2.getContig());
                    String string = StringUtil.bytesToString((byte[])byArray, (int)(interval2.getStart() - 1), (int)interval2.length());
                    if (string.equalsIgnoreCase(allele.getBaseString())) break;
                    bl = true;
                    break;
                }
                if (bl) {
                    variantContextWriter2.add(new VariantContextBuilder(object2).filter(FILTER_MISMATCHING_REF_ALLELE).make());
                    ++l2;
                } else {
                    sortingCollection.add((Object)variantContextBuilder.make());
                }
            }
            progressLogger.record(object2.getContig(), object2.getStart());
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.0000%");
        object2 = decimalFormat.format((double)(l + l2) / (double)l3);
        this.log.info(new Object[]{"Processed ", l3, " variants."});
        this.log.info(new Object[]{l, " variants failed to liftover."});
        this.log.info(new Object[]{l2, " variants lifted over but had mismatching reference alleles after lift over."});
        this.log.info(new Object[]{object2, " of variants were not successfully lifted over and written to the output."});
        variantContextWriter2.close();
        vCFFileReader.close();
        sortingCollection.doneAdding();
        progressLogger = new ProgressLogger(this.log, 1000000, "written");
        this.log.info(new Object[]{"Writing out sorted records to final VCF."});
        for (Interval interval2 : sortingCollection) {
            variantContextWriter.add((VariantContext)interval2);
            progressLogger.record(interval2.getContig(), interval2.getStart());
        }
        variantContextWriter.close();
        sortingCollection.cleanup();
        return 0;
    }

    protected static GenotypesContext fixGenotypes(GenotypesContext genotypesContext, Map<Allele, Allele> map) {
        if (map.isEmpty()) {
            return genotypesContext;
        }
        GenotypesContext genotypesContext2 = GenotypesContext.create((int)genotypesContext.size());
        for (Genotype genotype : genotypesContext) {
            ArrayList<Allele> arrayList = new ArrayList<Allele>();
            for (Allele allele : genotype.getAlleles()) {
                Allele allele2 = map.containsKey(allele) ? map.get(allele) : allele;
                arrayList.add(allele2);
            }
            genotypesContext2.add(new GenotypeBuilder(genotype).alleles(arrayList).make());
        }
        return genotypesContext2;
    }
}

