/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.PeekableIterator;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextComparator;
import java.util.Iterator;
import picard.vcf.VcTuple;

class PairedVariantSubContextIterator
implements Iterator<VcTuple> {
    private final PeekableIterator<VariantContext> truthIterator;
    private final String truthSample;
    private final PeekableIterator<VariantContext> callIterator;
    private final String callSample;
    private final VariantContextComparator comparator;

    PairedVariantSubContextIterator(Iterator<VariantContext> iterator, String string, Iterator<VariantContext> iterator2, String string2, SAMSequenceDictionary sAMSequenceDictionary) {
        this.truthIterator = new PeekableIterator(iterator);
        this.truthSample = string;
        this.callIterator = new PeekableIterator(iterator2);
        this.callSample = string2;
        this.comparator = new VariantContextComparator(sAMSequenceDictionary);
    }

    @Override
    public boolean hasNext() {
        return this.truthIterator.hasNext() || this.callIterator.hasNext();
    }

    @Override
    public VcTuple next() {
        VariantContext variantContext;
        if (!this.hasNext()) {
            throw new IllegalStateException("next() called while hasNext() is false.");
        }
        VariantContext variantContext2 = this.truthIterator.hasNext() ? (VariantContext)this.truthIterator.peek() : null;
        VariantContext variantContext3 = variantContext = this.callIterator.hasNext() ? (VariantContext)this.callIterator.peek() : null;
        if (variantContext2 == null) {
            return new VcTuple(null, ((VariantContext)this.callIterator.next()).subContextFromSample(this.callSample));
        }
        if (variantContext == null) {
            return new VcTuple(((VariantContext)this.truthIterator.next()).subContextFromSample(this.truthSample), null);
        }
        int n = this.comparator.compare(variantContext2, variantContext);
        if (n == 0) {
            return new VcTuple(((VariantContext)this.truthIterator.next()).subContextFromSample(this.truthSample), ((VariantContext)this.callIterator.next()).subContextFromSample(this.callSample));
        }
        if (n < 0) {
            return new VcTuple(((VariantContext)this.truthIterator.next()).subContextFromSample(this.truthSample), null);
        }
        return new VcTuple(null, ((VariantContext)this.callIterator.next()).subContextFromSample(this.callSample));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

