/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.variant.utils.SAMSequenceDictionaryExtractor;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.VcfOrBcf;

@CommandLineProgramProperties(usage="Takes a VCF and a second file that contains a sequence dictionary and updates the VCF with the new sequence dictionary.", usageShort="Takes a VCF and a second file that contains a sequence dictionary and updates the VCF with the new sequence dictionary.", programGroup=VcfOrBcf.class)
public class UpdateVcfSequenceDictionary
extends CommandLineProgram {
    @Option(shortName="I", doc="Input VCF")
    public File INPUT;
    @Option(shortName="O", doc="Output VCF to be written.")
    public File OUTPUT;
    @Option(shortName="SD", doc="A Sequence Dictionary (can be read from one of the following file types (SAM, BAM, VCF, BCF, Interval List, Fasta, or Dict)")
    public File SEQUENCE_DICTIONARY;
    private final Log log = Log.getInstance(UpdateVcfSequenceDictionary.class);

    public static void main(String[] stringArray) {
        new UpdateVcfSequenceDictionary().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsReadable((File)this.SEQUENCE_DICTIONARY);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        SAMSequenceDictionary sAMSequenceDictionary = SAMSequenceDictionaryExtractor.extractDictionary((File)this.SEQUENCE_DICTIONARY);
        VCFFileReader vCFFileReader = new VCFFileReader(this.INPUT, false);
        VCFHeader vCFHeader = vCFFileReader.getFileHeader();
        VariantContextWriterBuilder variantContextWriterBuilder = new VariantContextWriterBuilder().setReferenceDictionary(sAMSequenceDictionary).clearOptions();
        if (this.CREATE_INDEX.booleanValue()) {
            variantContextWriterBuilder.setOption(Options.INDEX_ON_THE_FLY);
        }
        VariantContextWriter variantContextWriter = variantContextWriterBuilder.setOutputFile(this.OUTPUT).build();
        vCFHeader.setSequenceDictionary(sAMSequenceDictionary);
        variantContextWriter.writeHeader(vCFHeader);
        ProgressLogger progressLogger = new ProgressLogger(this.log, 10000);
        CloseableIterator closeableIterator = vCFFileReader.iterator();
        while (closeableIterator.hasNext()) {
            VariantContext variantContext = (VariantContext)closeableIterator.next();
            variantContextWriter.add(variantContext);
            progressLogger.record(variantContext.getChr(), variantContext.getStart());
        }
        CloserUtil.close((Object)closeableIterator);
        CloserUtil.close((Object)vCFFileReader);
        variantContextWriter.close();
        return 0;
    }
}

