/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.VcfOrBcf;

@CommandLineProgramProperties(usage="Convert a VCF file to a BCF file, or BCF to VCF.\nInput and output formats are determined by file extension.", usageShort="Converts a VCF file to a BCF file, or BCF to VCF", programGroup=VcfOrBcf.class)
public class VcfFormatConverter
extends CommandLineProgram {
    public static final Log LOG = Log.getInstance(VcfFormatConverter.class);
    @Option(doc="The BCF or VCF input file. The file format is determined by file extension.", shortName="I")
    public File INPUT;
    @Option(doc="The BCF or VCF output file. The file format is determined by file extension.", shortName="O")
    public File OUTPUT;
    @Option(doc="Fail if an index is not available for the input VCF/BCF")
    public Boolean REQUIRE_INDEX = true;

    public static void main(String[] stringArray) {
        new VcfFormatConverter().instanceMainWithExit(stringArray);
    }

    public VcfFormatConverter() {
        this.CREATE_INDEX = true;
    }

    @Override
    protected int doWork() {
        ProgressLogger progressLogger = new ProgressLogger(LOG, 10000);
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        VCFFileReader vCFFileReader = new VCFFileReader(this.INPUT, this.REQUIRE_INDEX.booleanValue());
        VCFHeader vCFHeader = new VCFHeader(vCFFileReader.getFileHeader());
        SAMSequenceDictionary sAMSequenceDictionary = vCFHeader.getSequenceDictionary();
        if (this.CREATE_INDEX.booleanValue() && sAMSequenceDictionary == null) {
            throw new PicardException("A sequence dictionary must be available in the input file when creating indexed output.");
        }
        VariantContextWriterBuilder variantContextWriterBuilder = new VariantContextWriterBuilder().setOutputFile(this.OUTPUT).setReferenceDictionary(sAMSequenceDictionary);
        if (this.CREATE_INDEX.booleanValue()) {
            variantContextWriterBuilder.setOption(Options.INDEX_ON_THE_FLY);
        } else {
            variantContextWriterBuilder.unsetOption(Options.INDEX_ON_THE_FLY);
        }
        VariantContextWriter variantContextWriter = variantContextWriterBuilder.build();
        variantContextWriter.writeHeader(vCFHeader);
        CloseableIterator closeableIterator = vCFFileReader.iterator();
        while (closeableIterator.hasNext()) {
            VariantContext variantContext = (VariantContext)closeableIterator.next();
            variantContextWriter.add(variantContext);
            progressLogger.record(variantContext.getChr(), variantContext.getStart());
        }
        CloserUtil.close((Object)closeableIterator);
        CloserUtil.close((Object)vCFFileReader);
        variantContextWriter.close();
        return 0;
    }
}

