/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf.filter;

import htsjdk.samtools.util.CollectionUtil;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFFilterHeaderLine;
import java.util.HashMap;
import java.util.List;
import picard.vcf.filter.VariantFilter;

public class AlleleBalanceFilter
implements VariantFilter {
    public static final String AB_FILTER = "AlleleBalance";
    private final double hetAlleleBalance;

    public AlleleBalanceFilter(double d) {
        this.hetAlleleBalance = d;
    }

    @Override
    public List<VCFFilterHeaderLine> headerLines() {
        return CollectionUtil.makeList((Object[])new VCFFilterHeaderLine[]{new VCFFilterHeaderLine(AB_FILTER, "Heterozygote allele balance below required threshold.")});
    }

    @Override
    public String filter(VariantContext variantContext) {
        if (variantContext.getHetCount() == 0) {
            return null;
        }
        HashMap<List, Counts> hashMap = new HashMap<List, Counts>();
        for (Object object : variantContext.getGenotypesOrderedByName()) {
            if (object.isNoCall() || !object.isHet()) continue;
            List list = object.getAlleles();
            Counts counts = (Counts)hashMap.get(list);
            if (counts == null) {
                counts = new Counts();
                hashMap.put(list, counts);
            }
            counts.allele1 += object.getAD()[variantContext.getAlleleIndex((Allele)list.get(0))];
            counts.allele2 += object.getAD()[variantContext.getAlleleIndex((Allele)list.get(1))];
        }
        for (Object object : hashMap.values()) {
            int n = object.allele1 + object.allele2;
            if (n <= 0 || !((double)Math.min(object.allele1, object.allele2) / (double)n < this.hetAlleleBalance)) continue;
            return AB_FILTER;
        }
        return null;
    }

    private static class Counts {
        int samples;
        int allele1;
        int allele2;

        private Counts() {
        }
    }
}

