/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf.filter;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFFilterHeaderLine;
import htsjdk.variant.vcf.VCFFormatHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.VcfOrBcf;
import picard.vcf.filter.AlleleBalanceFilter;
import picard.vcf.filter.DepthFilter;
import picard.vcf.filter.FilterApplyingVariantIterator;
import picard.vcf.filter.FisherStrandFilter;
import picard.vcf.filter.GenotypeFilter;
import picard.vcf.filter.GenotypeQualityFilter;
import picard.vcf.filter.QdFilter;
import picard.vcf.filter.VariantFilter;

@CommandLineProgramProperties(usage="Applies one or more hard filters to a VCF file to filter out genotypes and variants.", usageShort="Hard filters a VCF.", programGroup=VcfOrBcf.class)
public class FilterVcf
extends CommandLineProgram {
    @Option(shortName="I", doc="The INPUT VCF or BCF file.")
    public File INPUT;
    @Option(shortName="O", doc="The output VCF or BCF.")
    public File OUTPUT;
    @Option(doc="The minimum allele balance acceptable before filtering a site. Allele balance is calculated for heterozygotes as the number of bases supporting the least-represented allele over the total number of base observations. Different heterozygote genotypes at the same locus are measured independently. The locus is filtered if any allele balance is below the limit.")
    public double MIN_AB = 0.0;
    @Option(doc="The minimum sequencing depth supporting a genotype before the genotype will be filtered out.")
    public int MIN_DP = 0;
    @Option(doc="The minimum genotype quality that must be achieved for a sample otherwise the genotype will be filtered out.")
    public int MIN_GQ = 0;
    @Option(doc="The maximum phred scaled fisher strand value before a site will be filtered out.")
    public double MAX_FS = Double.MAX_VALUE;
    @Option(doc="The minimum QD value to accept or otherwise filter out the variant.")
    public double MIN_QD = 0.0;

    public FilterVcf() {
        this.CREATE_INDEX = true;
    }

    public static void main(String[] stringArray) {
        new FilterVcf().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        SAMSequenceDictionary sAMSequenceDictionary;
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        List list = CollectionUtil.makeList((Object[])new VariantFilter[]{new AlleleBalanceFilter(this.MIN_AB), new FisherStrandFilter(this.MAX_FS), new QdFilter(this.MIN_QD)});
        List list2 = CollectionUtil.makeList((Object[])new GenotypeFilter[]{new GenotypeQualityFilter(this.MIN_GQ), new DepthFilter(this.MIN_DP)});
        VCFFileReader vCFFileReader = new VCFFileReader(this.INPUT, false);
        FilterApplyingVariantIterator filterApplyingVariantIterator = new FilterApplyingVariantIterator((Iterator<VariantContext>)vCFFileReader.iterator(), list, list2);
        VCFHeader vCFHeader = vCFFileReader.getFileHeader();
        VariantContextWriterBuilder variantContextWriterBuilder = new VariantContextWriterBuilder();
        if (this.isVcfOrBcf(this.OUTPUT)) {
            sAMSequenceDictionary = vCFHeader.getSequenceDictionary();
            if (sAMSequenceDictionary == null) {
                throw new PicardException("The input vcf must have a sequence dictionary in order to create indexed vcf or bcfs.");
            }
            variantContextWriterBuilder.setReferenceDictionary(sAMSequenceDictionary);
        }
        sAMSequenceDictionary = variantContextWriterBuilder.setOutputFile(this.OUTPUT).build();
        vCFHeader.addMetaDataLine((VCFHeaderLine)new VCFFilterHeaderLine("AllGtsFiltered", "Site filtered out because all genotypes are filtered out."));
        vCFHeader.addMetaDataLine((VCFHeaderLine)new VCFFormatHeaderLine("FT", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "Genotype filters."));
        for (VariantFilter variantFilter : list) {
            for (VCFFilterHeaderLine vCFFilterHeaderLine : variantFilter.headerLines()) {
                vCFHeader.addMetaDataLine((VCFHeaderLine)vCFFilterHeaderLine);
            }
        }
        sAMSequenceDictionary.writeHeader(vCFFileReader.getFileHeader());
        while (filterApplyingVariantIterator.hasNext()) {
            sAMSequenceDictionary.add(filterApplyingVariantIterator.next());
        }
        sAMSequenceDictionary.close();
        vCFFileReader.close();
        return 0;
    }

    private boolean isVcfOrBcf(File file) {
        String string = file.getName();
        return string.endsWith(".vcf") || string.endsWith(".bcf");
    }
}

