/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf.filter;

import htsjdk.samtools.util.CollectionUtil;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFFilterHeaderLine;
import java.util.List;
import picard.vcf.filter.VariantFilter;

public class QdFilter
implements VariantFilter {
    public static final String FILTER_NAME = "LowQD";
    private final double minimumQd;

    public QdFilter(double d) {
        this.minimumQd = d;
    }

    @Override
    public String filter(VariantContext variantContext) {
        double d = variantContext.getAttributeAsDouble("QD", -1.0);
        if (d >= 0.0 && d < this.minimumQd) {
            return FILTER_NAME;
        }
        return null;
    }

    @Override
    public List<VCFFilterHeaderLine> headerLines() {
        return CollectionUtil.makeList((Object[])new VCFFilterHeaderLine[]{new VCFFilterHeaderLine(FILTER_NAME, "Site exhibits QD value below a hard limit.")});
    }
}

