/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf.processor;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.OverlapDetector;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFFileReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import picard.vcf.processor.VcfFileSegment;
import picard.vcf.processor.VcfFileSegmentGenerator;
import picard.vcf.processor.util.PredicateFilterDecoratingClosableIterator;

public abstract class VariantIteratorProducer {
    static final int ONE_HUNDRED_MILLION = 100000000;

    public abstract Iterable<CloseableIterator<VariantContext>> iterators();

    public abstract void close();

    public static VariantIteratorProducer byHundredMegabaseChunksWithOnTheFlyFilteringByInterval(List<File> list, IntervalList intervalList) {
        return new Threadsafe(VcfFileSegmentGenerator.byWholeContigSubdividingWithWidth(100000000L), list, intervalList);
    }

    public static VariantIteratorProducer byHundredMegabaseChunks(List<File> list) {
        return new Threadsafe(VcfFileSegmentGenerator.byWholeContigSubdividingWithWidth(100000000L), list, null);
    }

    static class Threadsafe
    extends VariantIteratorProducer {
        static final Log LOG = Log.getInstance(Threadsafe.class);
        final List<VcfFileSegment> segments;
        final OverlapDetector<Interval> intervalsOfInterestDetector;
        final Map<File, OverlapDetector<VcfFileSegment>> multiSegmentDetectorPerFile = new CollectionUtil.DefaultingMap((CollectionUtil.DefaultingMap.Factory)new CollectionUtil.DefaultingMap.Factory<OverlapDetector<VcfFileSegment>, File>(){

            public OverlapDetector<VcfFileSegment> make(File file) {
                return new OverlapDetector(0, 0);
            }
        }, true);
        final Collection<VCFFileReader> allReaders = Collections.synchronizedCollection(new ArrayList());
        final ThreadLocal<CollectionUtil.DefaultingMap<File, VCFFileReader>> localVcfFileReaders = new ThreadLocal<CollectionUtil.DefaultingMap<File, VCFFileReader>>(){

            @Override
            protected CollectionUtil.DefaultingMap<File, VCFFileReader> initialValue() {
                return new CollectionUtil.DefaultingMap((CollectionUtil.DefaultingMap.Factory)new CollectionUtil.DefaultingMap.Factory<VCFFileReader, File>(){

                    public VCFFileReader make(File file) {
                        VCFFileReader vCFFileReader = new VCFFileReader(file);
                        LOG.debug(new Object[]{String.format("Producing a reader of %s for %s.", file, Thread.currentThread())});
                        allReaders.add(vCFFileReader);
                        return vCFFileReader;
                    }
                }, true);
            }
        };

        Threadsafe(VcfFileSegmentGenerator vcfFileSegmentGenerator, List<File> list) {
            this(vcfFileSegmentGenerator, list, null);
        }

        Threadsafe(VcfFileSegmentGenerator vcfFileSegmentGenerator, List<File> list, IntervalList intervalList) {
            Object object;
            if (intervalList != null) {
                object = intervalList.getUniqueIntervals(false);
                this.intervalsOfInterestDetector = new OverlapDetector(0, 0);
                this.intervalsOfInterestDetector.addAll((List)object, (List)object);
            } else {
                this.intervalsOfInterestDetector = null;
            }
            object = this.intervalsOfInterestDetector == null ? vcfFileSegmentGenerator : VcfFileSegmentGenerator.excludingNonOverlaps(vcfFileSegmentGenerator, this.intervalsOfInterestDetector);
            this.segments = new ArrayList<VcfFileSegment>();
            for (File object2 : list) {
                for (VcfFileSegment vcfFileSegment : ((VcfFileSegmentGenerator)object).forVcf(object2)) {
                    this.segments.add(vcfFileSegment);
                }
            }
            for (VcfFileSegment vcfFileSegment : this.segments) {
                Interval interval = vcfFileSegment.correspondingInterval();
                OverlapDetector<VcfFileSegment> overlapDetector = this.multiSegmentDetectorPerFile.get(vcfFileSegment.vcf());
                if (overlapDetector.getOverlaps(interval).isEmpty()) {
                    overlapDetector.addLhs((Object)vcfFileSegment, new Interval(vcfFileSegment.contig(), vcfFileSegment.start(), vcfFileSegment.stop()));
                    continue;
                }
                throw new IllegalArgumentException(String.format("Provided segmenting strategy produced overlapping intervals; %s overlaps with: %s", vcfFileSegment, Joiner.on((String)", ").join((Iterable)overlapDetector.getOverlaps(interval))));
            }
        }

        private CloseableIterator<VariantContext> iteratorForSegment(VcfFileSegment vcfFileSegment) {
            CloseableIterator closeableIterator = ((VCFFileReader)this.localVcfFileReaders.get().get((Object)vcfFileSegment.vcf())).query(vcfFileSegment.contig(), vcfFileSegment.start(), vcfFileSegment.stop());
            ArrayList arrayList = new ArrayList();
            if (this.intervalsOfInterestDetector != null) {
                arrayList.add(new OverlapsPredicate());
            }
            arrayList.add(new NonUniqueVariantPredicate(vcfFileSegment));
            return new PredicateFilterDecoratingClosableIterator<VariantContext>(closeableIterator, arrayList);
        }

        @Override
        public Iterable<CloseableIterator<VariantContext>> iterators() {
            return FluentIterable.from(this.segments).transform((Function)new Function<VcfFileSegment, CloseableIterator<VariantContext>>(){

                public CloseableIterator<VariantContext> apply(VcfFileSegment vcfFileSegment) {
                    return this.iteratorForSegment(vcfFileSegment);
                }
            });
        }

        @Override
        public void close() {
            Iterator<VCFFileReader> iterator = this.allReaders.iterator();
            while (iterator.hasNext()) {
                iterator.next().close();
                iterator.remove();
            }
        }

        final class OverlapsPredicate
        implements Predicate<VariantContext> {
            OverlapsPredicate() {
            }

            public boolean apply(VariantContext variantContext) {
                boolean bl;
                boolean bl2 = bl = !Threadsafe.this.intervalsOfInterestDetector.getOverlaps(new Interval(variantContext.getChr(), variantContext.getStart(), variantContext.getEnd())).isEmpty();
                if (!bl) {
                    LOG.debug(new Object[]{"Filtering variant at ", variantContext.getChr(), ":", variantContext.getStart(), "-", variantContext.getEnd()});
                }
                return bl;
            }
        }

        final class NonUniqueVariantPredicate
        implements Predicate<VariantContext> {
            final VcfFileSegment sourceSegment;

            NonUniqueVariantPredicate(VcfFileSegment vcfFileSegment) {
                this.sourceSegment = vcfFileSegment;
            }

            public boolean apply(VariantContext variantContext) {
                if (variantContext.getStart() == variantContext.getEnd()) {
                    return true;
                }
                Collection collection = Threadsafe.this.multiSegmentDetectorPerFile.get(this.sourceSegment.vcf()).getOverlaps(new Interval(variantContext.getChr(), variantContext.getStart(), variantContext.getEnd()));
                if (collection.size() < 2) {
                    return true;
                }
                int n = Threadsafe.this.segments.indexOf(this.sourceSegment);
                LOG.debug(new Object[]{"Found wide variant spanning multiple source segments: ", variantContext});
                for (VcfFileSegment vcfFileSegment : collection) {
                    if (Threadsafe.this.segments.indexOf(vcfFileSegment) >= n) continue;
                    return false;
                }
                LOG.debug(new Object[]{"Emitting wide variant because it belongs to first segment: ", variantContext});
                return true;
            }
        }
    }
}

