/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf.processor;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.primitives.Ints;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.OverlapDetector;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import picard.vcf.processor.VcfFileSegment;

public abstract class VcfFileSegmentGenerator {
    static final Log LOG = Log.getInstance(VcfFileSegmentGenerator.class);

    public abstract Iterable<VcfFileSegment> forVcf(File var1);

    public static VcfFileSegmentGenerator byWholeContigSubdividingWithWidth(long l) {
        return WidthLimitingDecorator.wrapping(ByWholeContig.getInstance(), l);
    }

    public static <T> VcfFileSegmentGenerator excludingNonOverlaps(final VcfFileSegmentGenerator vcfFileSegmentGenerator, final OverlapDetector<T> overlapDetector) {
        return new VcfFileSegmentGenerator(){

            @Override
            public Iterable<VcfFileSegment> forVcf(File file) {
                return FluentIterable.from(vcfFileSegmentGenerator.forVcf(file)).filter((Predicate)new Predicate<VcfFileSegment>(){

                    public boolean apply(VcfFileSegment vcfFileSegment) {
                        boolean bl;
                        boolean bl2 = bl = !overlapDetector.getOverlaps(new Interval(vcfFileSegment.contig(), vcfFileSegment.start(), vcfFileSegment.stop())).isEmpty();
                        if (!bl) {
                            LOG.debug(new Object[]{String.format("Ignoring segment because it does not overlap with detector, %s::%s:%s-%s", vcfFileSegment.vcf().getName(), vcfFileSegment.contig(), vcfFileSegment.start(), vcfFileSegment.stop())});
                        }
                        return bl;
                    }
                });
            }
        };
    }

    static class WidthLimitingDecorator
    extends VcfFileSegmentGenerator {
        final VcfFileSegmentGenerator underlyingStrategy;
        final long width;

        public static WidthLimitingDecorator wrapping(VcfFileSegmentGenerator vcfFileSegmentGenerator, long l) {
            return new WidthLimitingDecorator(vcfFileSegmentGenerator, l);
        }

        private WidthLimitingDecorator(VcfFileSegmentGenerator vcfFileSegmentGenerator, long l) {
            this.underlyingStrategy = vcfFileSegmentGenerator;
            this.width = l - 1L;
        }

        @Override
        public Iterable<VcfFileSegment> forVcf(File file) {
            return FluentIterable.from(this.underlyingStrategy.forVcf(file)).transformAndConcat((Function)new Function<VcfFileSegment, Iterable<? extends VcfFileSegment>>(){

                public Iterable<? extends VcfFileSegment> apply(VcfFileSegment vcfFileSegment) {
                    return new VcfFileSegmentSubdivider(vcfFileSegment);
                }
            });
        }

        private class VcfFileSegmentSubdivider
        implements Iterable<VcfFileSegment> {
            final VcfFileSegment basis;

            private VcfFileSegmentSubdivider(VcfFileSegment vcfFileSegment) {
                this.basis = vcfFileSegment;
            }

            @Override
            public Iterator<VcfFileSegment> iterator() {
                return new Iterator<VcfFileSegment>(){
                    int nextStart;
                    {
                        this.nextStart = VcfFileSegmentSubdivider.this.basis.start();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.nextStart <= VcfFileSegmentSubdivider.this.basis.stop();
                    }

                    @Override
                    public VcfFileSegment next() {
                        final int n = this.nextStart;
                        VcfFileSegment vcfFileSegment = new VcfFileSegment(){

                            @Override
                            public int start() {
                                return n;
                            }

                            @Override
                            public int stop() {
                                return Ints.checkedCast((long)Math.min((long)n + WidthLimitingDecorator.this.width, (long)VcfFileSegmentSubdivider.this.basis.stop()));
                            }

                            @Override
                            public String contig() {
                                return VcfFileSegmentSubdivider.this.basis.contig();
                            }

                            @Override
                            public File vcf() {
                                return VcfFileSegmentSubdivider.this.basis.vcf();
                            }
                        };
                        this.nextStart = (int)((long)this.nextStart + (WidthLimitingDecorator.this.width + 1L));
                        return vcfFileSegment;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }
    }

    static class ByWholeContig
    extends VcfFileSegmentGenerator {
        private static final ByWholeContig singleton = new ByWholeContig();

        ByWholeContig() {
        }

        public static ByWholeContig getInstance() {
            return singleton;
        }

        @Override
        public Iterable<VcfFileSegment> forVcf(final File file) {
            List<SAMSequenceRecord> list = ByWholeContig.readSequences(file);
            return FluentIterable.from(list).transform((Function)new Function<SAMSequenceRecord, VcfFileSegment>(){

                public VcfFileSegment apply(SAMSequenceRecord sAMSequenceRecord) {
                    return VcfFileSegment.ofWholeSequence(sAMSequenceRecord, file);
                }
            });
        }

        private static List<SAMSequenceRecord> readSequences(File file) {
            VCFFileReader vCFFileReader = new VCFFileReader(file);
            VCFHeader vCFHeader = vCFFileReader.getFileHeader();
            SAMSequenceDictionary sAMSequenceDictionary = vCFHeader.getSequenceDictionary();
            vCFFileReader.close();
            return sAMSequenceDictionary.getSequences();
        }
    }
}

