/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.analysis.SinglePassSamProgram;
import picard.cmdline.programgroups.Metrics;

@CommandLineProgramProperties(summary="Collect metrics about reads that pass quality thresholds and Illumina-specific filters.  This tool evaluates the overall quality of reads within a bam file containing one read group. The output indicates the total numbers of bases within a read group that pass a minimum base quality score threshold and (in the case of Illumina data) pass Illumina quality filters as described in the <a href='https://www.broadinstitute.org/gatk/guide/article?id=6329'>GATK Dictionary entry</a>. <br /><h4>Note on base quality score options</h4>If the quality score of read bases has been modified in a previous data processing step such as <a href='https://www.broadinstitute.org/gatk/guide/article?id=44'>GATK Base Recalibration</a> and an OQ tag is available, this tool can be set to use the OQ value instead of the primary quality value for the evaluation. <br /><br />Note that the default behaviour of this program changed as of November 6th 2015 to no longer include secondary and supplemental alignments in the computation. <br /><h4>Usage Example:</h4><pre>java -jar picard.jar CollectQualityYieldMetrics \\<br />       I=input.bam \\<br />       O=quality_yield_metrics.txt \\<br /></pre>Please see <a href='https://broadinstitute.github.io/picard/picard-metric-definitions.html#CollectQualityYieldMetrics.QualityYieldMetrics'>the QualityYieldMetrics documentation</a> for details and explanations of the output metrics.<hr />", oneLineSummary="Collect metrics about reads that pass quality thresholds and Illumina-specific filters.  ", programGroup=Metrics.class)
@DocumentedFeature
public class CollectQualityYieldMetrics
extends SinglePassSamProgram {
    private QualityYieldMetricsCollector collector = null;
    static final String USAGE_SUMMARY = "Collect metrics about reads that pass quality thresholds and Illumina-specific filters.  ";
    static final String USAGE_DETAILS = "This tool evaluates the overall quality of reads within a bam file containing one read group. The output indicates the total numbers of bases within a read group that pass a minimum base quality score threshold and (in the case of Illumina data) pass Illumina quality filters as described in the <a href='https://www.broadinstitute.org/gatk/guide/article?id=6329'>GATK Dictionary entry</a>. <br /><h4>Note on base quality score options</h4>If the quality score of read bases has been modified in a previous data processing step such as <a href='https://www.broadinstitute.org/gatk/guide/article?id=44'>GATK Base Recalibration</a> and an OQ tag is available, this tool can be set to use the OQ value instead of the primary quality value for the evaluation. <br /><br />Note that the default behaviour of this program changed as of November 6th 2015 to no longer include secondary and supplemental alignments in the computation. <br /><h4>Usage Example:</h4><pre>java -jar picard.jar CollectQualityYieldMetrics \\<br />       I=input.bam \\<br />       O=quality_yield_metrics.txt \\<br /></pre>Please see <a href='https://broadinstitute.github.io/picard/picard-metric-definitions.html#CollectQualityYieldMetrics.QualityYieldMetrics'>the QualityYieldMetrics documentation</a> for details and explanations of the output metrics.<hr />";
    @Argument(shortName="OQ", doc="If available in the OQ tag, use the original quality scores as inputs instead of the quality scores in the QUAL field.")
    public boolean USE_ORIGINAL_QUALITIES = true;
    @Argument(doc="If true, include bases from secondary alignments in metrics. Setting to true may cause double-counting of bases if there are secondary alignments in the input file.")
    public boolean INCLUDE_SECONDARY_ALIGNMENTS = false;
    @Argument(doc="If true, include bases from supplemental alignments in metrics. Setting to true may cause double-counting of bases if there are supplemental alignments in the input file.")
    public boolean INCLUDE_SUPPLEMENTAL_ALIGNMENTS = false;

    @Override
    protected boolean usesNoRefReads() {
        return true;
    }

    @Override
    protected void setup(SAMFileHeader header, File samFile) {
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        this.collector = new QualityYieldMetricsCollector(this.USE_ORIGINAL_QUALITIES, this.INCLUDE_SECONDARY_ALIGNMENTS, this.INCLUDE_SUPPLEMENTAL_ALIGNMENTS);
    }

    @Override
    protected void acceptRead(SAMRecord rec, ReferenceSequence ref) {
        this.collector.acceptRecord(rec, ref);
    }

    @Override
    protected void finish() {
        MetricsFile metricsFile = this.getMetricsFile();
        this.collector.finish();
        this.collector.addMetricsToFile(metricsFile);
        metricsFile.write(this.OUTPUT);
    }

    public static class QualityYieldMetrics
    extends MetricBase {
        public long TOTAL_READS = 0L;
        public long PF_READS = 0L;
        public int READ_LENGTH = 0;
        public long TOTAL_BASES;
        public long PF_BASES = 0L;
        public long Q20_BASES = 0L;
        public long PF_Q20_BASES = 0L;
        public long Q30_BASES = 0L;
        public long PF_Q30_BASES = 0L;
        public long Q20_EQUIVALENT_YIELD = 0L;
        public long PF_Q20_EQUIVALENT_YIELD = 0L;
    }

    public static class QualityYieldMetricsCollector {
        private final boolean useOriginalQualities;
        private final boolean includeSecondaryAlignments;
        public final boolean includeSupplementalAlignments;
        private final QualityYieldMetrics metrics = new QualityYieldMetrics();

        public QualityYieldMetricsCollector(boolean useOriginalQualities, boolean includeSecondaryAlignments, boolean includeSupplementalAlignments) {
            this.useOriginalQualities = useOriginalQualities;
            this.includeSecondaryAlignments = includeSecondaryAlignments;
            this.includeSupplementalAlignments = includeSupplementalAlignments;
        }

        public void acceptRecord(SAMRecord rec, ReferenceSequence ref) {
            byte[] quals;
            boolean isPfRead;
            if (!this.includeSecondaryAlignments && rec.getNotPrimaryAlignmentFlag()) {
                return;
            }
            if (!this.includeSupplementalAlignments && rec.getSupplementaryAlignmentFlag()) {
                return;
            }
            int length = rec.getReadLength();
            ++this.metrics.TOTAL_READS;
            this.metrics.TOTAL_BASES += (long)length;
            boolean bl = isPfRead = !rec.getReadFailsVendorQualityCheckFlag();
            if (isPfRead) {
                ++this.metrics.PF_READS;
                this.metrics.PF_BASES += (long)length;
            }
            if (this.useOriginalQualities) {
                byte[] tmp = rec.getOriginalBaseQualities();
                if (tmp == null) {
                    tmp = rec.getBaseQualities();
                }
                quals = tmp;
            } else {
                quals = rec.getBaseQualities();
            }
            for (byte qual : quals) {
                this.metrics.Q20_EQUIVALENT_YIELD += (long)qual;
                if (qual >= 30) {
                    ++this.metrics.Q20_BASES;
                    ++this.metrics.Q30_BASES;
                } else if (qual >= 20) {
                    ++this.metrics.Q20_BASES;
                }
                if (!isPfRead) continue;
                this.metrics.PF_Q20_EQUIVALENT_YIELD += (long)qual;
                if (qual >= 30) {
                    ++this.metrics.PF_Q20_BASES;
                    ++this.metrics.PF_Q30_BASES;
                    continue;
                }
                if (qual < 20) continue;
                ++this.metrics.PF_Q20_BASES;
            }
        }

        public void finish() {
            this.metrics.READ_LENGTH = this.metrics.TOTAL_READS == 0L ? 0 : (int)(this.metrics.TOTAL_BASES / this.metrics.TOTAL_READS);
            this.metrics.Q20_EQUIVALENT_YIELD /= 20L;
            this.metrics.PF_Q20_EQUIVALENT_YIELD /= 20L;
        }

        public void addMetricsToFile(MetricsFile<QualityYieldMetrics, Integer> metricsFile) {
            metricsFile.addMetric((MetricBase)this.metrics);
        }
    }
}

