/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.directed;

import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.CoordMath;
import htsjdk.samtools.util.FormatUtil;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.OverlapDetector;
import htsjdk.samtools.util.QualityUtil;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.LongStream;
import picard.PicardException;
import picard.analysis.MetricAccumulationLevel;
import picard.analysis.TheoreticalSensitivity;
import picard.analysis.directed.TargetMetrics;
import picard.filter.CountingMapQFilter;
import picard.metrics.MultilevelMetrics;
import picard.metrics.PerUnitMetricCollector;
import picard.metrics.SAMRecordMultiLevelCollector;

public abstract class TargetMetricsCollector<METRIC_TYPE extends MultilevelMetrics>
extends SAMRecordMultiLevelCollector<METRIC_TYPE, Integer> {
    public static final int NEAR_PROBE_DISTANCE_DEFAULT = 250;
    private int nearProbeDistance = 250;
    private final File perTargetCoverage;
    private final File perBaseCoverage;
    private final String probeSetName;
    private static final Log log = Log.getInstance(TargetMetricsCollector.class);
    private final IntervalList allProbes;
    private final IntervalList allTargets;
    private final OverlapDetector<Interval> targetDetector;
    private final OverlapDetector<Interval> probeDetector;
    private Map<Interval, Double> intervalToGc = null;
    private final long probeTerritory;
    private final long targetTerritory;
    private final long genomeSize;
    private final int coverageCap;
    private final int sampleSize;
    private final Histogram<Integer> highQualityDepthHistogram = new Histogram("coverage_or_base_quality", "high_quality_coverage_count");
    private final Histogram<Integer> unfilteredDepthHistogram = new Histogram("coverage_or_base_quality", "unfiltered_coverage_count");
    private final Histogram<Integer> unfilteredBaseQHistogram = new Histogram("baseq", "unfiltered_baseq_count");
    private static final double LOG_ODDS_THRESHOLD = 3.0;
    private final int minimumMappingQuality;
    private final int minimumBaseQuality;
    private final boolean clipOverlappingReads;
    private boolean noSideEffects;
    private final Map<Interval, Coverage> coverageByTargetForRead;
    private final Coverage[] cov;

    public int getNearProbeDistance() {
        return this.nearProbeDistance;
    }

    public void setNearProbeDistance(int nearProbeDistance) {
        this.nearProbeDistance = nearProbeDistance;
    }

    public abstract METRIC_TYPE convertMetric(TargetMetrics var1);

    public void setNoSideEffects(boolean value) {
        this.noSideEffects = value;
    }

    public static int getNumBasesPassingMinimumBaseQuality(SAMRecord record, AlignmentBlock block, int minimumBaseQuality) {
        int basesInBlockAtMinimumQuality = 0;
        byte[] baseQualities = record.getBaseQualities();
        for (int idx = block.getReadStart(); idx <= CoordMath.getEnd((int)block.getLength(), (int)block.getReadStart()); ++idx) {
            if (minimumBaseQuality > baseQualities[idx - 1]) continue;
            ++basesInBlockAtMinimumQuality;
        }
        return basesInBlockAtMinimumQuality;
    }

    protected static <MT extends MetricBase> void reflectiveCopy(TargetMetrics targetMetrics, MT outputMetrics, String[] targetKeys, String[] outputKeys) {
        if (targetKeys == null || outputKeys == null) {
            if (outputKeys != null) {
                throw new PicardException("Target keys is null but output keys == " + StringUtil.join((String)",", (Object[])outputKeys));
            }
            if (targetKeys != null) {
                throw new PicardException("Output keys is null but target keys == " + StringUtil.join((String)",", (Object[])targetKeys));
            }
        } else if (targetKeys.length != outputKeys.length) {
            throw new PicardException("Target keys and output keys do not have the same length: targetKeys == (" + StringUtil.join((String)",", (Object[])targetKeys) + ") " + "outputKeys == (" + StringUtil.join((String)",", (Object[])outputKeys) + ")");
        }
        Class<?> mtClass = outputMetrics.getClass();
        Set targetSet = CollectionUtil.makeSet((Object[])TargetMetrics.class.getFields());
        for (String targetKey : targetKeys) {
            if (!targetSet.contains(targetKey)) continue;
            targetSet.remove(targetKey);
        }
        HashSet<String> outputSet = new HashSet<String>();
        for (Field field : outputMetrics.getClass().getFields()) {
            outputSet.add(field.getName());
        }
        for (Field field : targetSet) {
            if (!outputSet.contains(field.getName())) continue;
            try {
                Field outputField = mtClass.getField(field.getName());
                outputField.set(outputMetrics, field.get((Object)targetMetrics));
            }
            catch (Exception e) {
                throw new PicardException("Exception while copying targetMetrics to " + outputMetrics.getClass().getName(), e);
            }
        }
        for (int i = 0; i < targetKeys.length; ++i) {
            try {
                Field targetMetricField = TargetMetrics.class.getField(targetKeys[i]);
                Field outputMetricField = mtClass.getField(outputKeys[i]);
                outputMetricField.set(outputMetrics, targetMetricField.get((Object)targetMetrics));
                continue;
            }
            catch (Exception exc) {
                throw new PicardException("Exception while copying TargetMetrics." + targetKeys[i] + " to " + mtClass.getName() + "." + outputKeys[i], exc);
            }
        }
    }

    public TargetMetricsCollector(Set<MetricAccumulationLevel> accumulationLevels, List<SAMReadGroupRecord> samRgRecords, ReferenceSequenceFile refFile, File perTargetCoverage, File perBaseCoverage, IntervalList targetIntervals, IntervalList probeIntervals, String probeSetName, int nearProbeDistance, int minimumMappingQuality, int minimumBaseQuality, boolean clipOverlappingReads, int coverageCap, int sampleSize) {
        this(accumulationLevels, samRgRecords, refFile, perTargetCoverage, perBaseCoverage, targetIntervals, probeIntervals, probeSetName, nearProbeDistance, minimumMappingQuality, minimumBaseQuality, clipOverlappingReads, false, coverageCap, sampleSize);
    }

    public TargetMetricsCollector(Set<MetricAccumulationLevel> accumulationLevels, List<SAMReadGroupRecord> samRgRecords, ReferenceSequenceFile refFile, File perTargetCoverage, File perBaseCoverage, IntervalList targetIntervals, IntervalList probeIntervals, String probeSetName, int nearProbeDistance, int minimumMappingQuality, int minimumBaseQuality, boolean clipOverlappingReads, boolean noSideEffects, int coverageCap, int sampleSize) {
        this.perTargetCoverage = perTargetCoverage;
        this.perBaseCoverage = perBaseCoverage;
        this.probeSetName = probeSetName;
        this.nearProbeDistance = nearProbeDistance;
        this.allProbes = probeIntervals;
        this.allTargets = targetIntervals;
        this.coverageCap = coverageCap;
        this.sampleSize = sampleSize;
        List uniqueBaits = this.allProbes.uniqued().getIntervals();
        this.probeDetector = new OverlapDetector(-this.nearProbeDistance, 0);
        this.probeDetector.addAll(uniqueBaits, uniqueBaits);
        this.probeTerritory = Interval.countBases((Collection)uniqueBaits);
        List uniqueTargets = this.allTargets.uniqued().getIntervals();
        this.targetDetector = new OverlapDetector(0, 0);
        this.targetDetector.addAll(uniqueTargets, uniqueTargets);
        this.targetTerritory = Interval.countBases((Collection)uniqueTargets);
        int i = 0;
        this.cov = new Coverage[uniqueTargets.size()];
        this.coverageByTargetForRead = new LinkedHashMap<Interval, Coverage>(uniqueTargets.size() * 2, 0.5f);
        for (Interval target : uniqueTargets) {
            Coverage coverage = new Coverage(target, 0);
            this.coverageByTargetForRead.put(target, coverage);
            this.cov[i++] = coverage;
        }
        long genomeSizeAccumulator = 0L;
        for (SAMSequenceRecord seq : this.allProbes.getHeader().getSequenceDictionary().getSequences()) {
            genomeSizeAccumulator += (long)seq.getSequenceLength();
        }
        this.genomeSize = genomeSizeAccumulator;
        if (refFile != null) {
            this.intervalToGc = new HashMap<Interval, Double>();
            for (Interval target : uniqueTargets) {
                ReferenceSequence rs = refFile.getSubsequenceAt(target.getContig(), (long)target.getStart(), (long)target.getEnd());
                this.intervalToGc.put(target, SequenceUtil.calculateGc((byte[])rs.getBases()));
            }
        }
        this.minimumMappingQuality = minimumMappingQuality;
        this.minimumBaseQuality = minimumBaseQuality;
        this.clipOverlappingReads = clipOverlappingReads;
        this.noSideEffects = noSideEffects;
        this.setup(accumulationLevels, samRgRecords);
    }

    @Override
    protected PerUnitMetricCollector<METRIC_TYPE, Integer, SAMRecord> makeChildCollector(String sample, String library, String readGroup) {
        PerUnitTargetMetricCollector collector = new PerUnitTargetMetricCollector(this.probeSetName, this.coverageByTargetForRead.keySet(), sample, library, readGroup, this.probeTerritory, this.targetTerritory, this.genomeSize, this.intervalToGc, this.minimumMappingQuality, this.minimumBaseQuality, this.clipOverlappingReads);
        if (this.probeSetName != null) {
            collector.setBaitSetName(this.probeSetName);
        }
        return collector;
    }

    @Override
    protected PerUnitMetricCollector<METRIC_TYPE, Integer, SAMRecord> makeAllReadCollector() {
        PerUnitTargetMetricCollector collector = (PerUnitTargetMetricCollector)this.makeChildCollector(null, null, null);
        if (this.perTargetCoverage != null) {
            collector.setPerTargetOutput(this.perTargetCoverage);
        }
        if (this.perBaseCoverage != null) {
            collector.setPerBaseOutput(this.perBaseCoverage);
        }
        return collector;
    }

    public static class Coverage {
        private final Interval interval;
        private final int[] depths;
        public long readCount = 0L;

        public Coverage(Interval i, int padding) {
            this.interval = i;
            this.depths = new int[this.interval.length() + 2 * padding];
        }

        public void addBase(int offset) {
            this.addBase(offset, 1);
        }

        public void addBase(int offset, int depth) {
            if (offset >= 0 && offset < this.depths.length && this.depths[offset] < Integer.MAX_VALUE - depth) {
                int n = offset;
                this.depths[n] = this.depths[n] + depth;
            }
        }

        public void incrementReadCount() {
            ++this.readCount;
        }

        public boolean hasCoverage() {
            for (int s : this.depths) {
                if (s <= 0) continue;
                return true;
            }
            return false;
        }

        public int[] getDepths() {
            return this.depths;
        }

        public long getTotal() {
            long total = 0L;
            for (int i = 0; i < this.depths.length; ++i) {
                total += total < Long.MAX_VALUE - (long)this.depths[i] ? (long)this.depths[i] : Long.MAX_VALUE - total;
            }
            return total;
        }

        public String toString() {
            return "TargetedMetricCollector(interval=" + this.interval + ", depths = [" + StringUtil.intValuesToString((int[])this.depths) + "])";
        }
    }

    public class PerUnitTargetMetricCollector
    implements PerUnitMetricCollector<METRIC_TYPE, Integer, SAMRecord> {
        private final Map<Interval, Double> intervalToGc;
        private File perTargetOutput;
        private File perBaseOutput;
        final long[] baseQHistogramArray = new long[127];
        private final Map<Interval, Coverage> highQualityCoverageByTarget;
        private final Map<Interval, Coverage> unfilteredCoverageByTarget;
        private final TargetMetrics metrics = new TargetMetrics();
        private final int minimumBaseQuality;
        private final CountingMapQFilter mapQFilter;
        private final boolean clipOverlappingReads;

        public PerUnitTargetMetricCollector(String probeSetName, Set<Interval> coverageTargets, String sample, String library, String readGroup, long probeTerritory, long targetTerritory, long genomeSize, Map<Interval, Double> intervalToGc, int minimumMappingQuality, int minimumBaseQuality, boolean clipOverlappingReads) {
            this.metrics.SAMPLE = sample;
            this.metrics.LIBRARY = library;
            this.metrics.READ_GROUP = readGroup;
            this.metrics.PROBE_SET = probeSetName;
            this.metrics.PROBE_TERRITORY = probeTerritory;
            this.metrics.TARGET_TERRITORY = targetTerritory;
            this.metrics.GENOME_SIZE = genomeSize;
            this.highQualityCoverageByTarget = new LinkedHashMap<Interval, Coverage>(coverageTargets.size() * 2, 0.5f);
            this.unfilteredCoverageByTarget = new LinkedHashMap<Interval, Coverage>(coverageTargets.size() * 2, 0.5f);
            for (Interval target : coverageTargets) {
                this.highQualityCoverageByTarget.put(target, new Coverage(target, 0));
                this.unfilteredCoverageByTarget.put(target, new Coverage(target, 0));
            }
            this.mapQFilter = new CountingMapQFilter(minimumMappingQuality);
            this.minimumBaseQuality = minimumBaseQuality;
            this.intervalToGc = intervalToGc;
            this.clipOverlappingReads = clipOverlappingReads;
        }

        public void setPerTargetOutput(File perTargetOutput) {
            this.perTargetOutput = perTargetOutput;
        }

        public void setPerBaseOutput(File perBaseOutput) {
            this.perBaseOutput = perBaseOutput;
        }

        public void setBaitSetName(String name) {
            this.metrics.PROBE_SET = name;
        }

        public Map<Interval, Coverage> getCoverageByTarget() {
            return Collections.unmodifiableMap(this.highQualityCoverageByTarget);
        }

        @Override
        public void acceptRecord(SAMRecord record) {
            SAMRecord rec;
            if (record.getNotPrimaryAlignmentFlag()) {
                return;
            }
            boolean mappedInPair = record.getReadPairedFlag() && !record.getReadUnmappedFlag() && !record.getMateUnmappedFlag() && !record.getSupplementaryAlignmentFlag();
            byte[] baseQualities = record.getBaseQualities();
            int basesAlignedInRecord = 0;
            if (!record.getReadUnmappedFlag()) {
                for (AlignmentBlock block : record.getAlignmentBlocks()) {
                    basesAlignedInRecord += block.getLength();
                }
            }
            if (!record.getSupplementaryAlignmentFlag()) {
                ++this.metrics.TOTAL_READS;
                if (!record.getReadFailsVendorQualityCheckFlag()) {
                    ++this.metrics.PF_READS;
                    if (!record.getDuplicateReadFlag()) {
                        ++this.metrics.PF_UNIQUE_READS;
                        if (!record.getReadUnmappedFlag()) {
                            ++this.metrics.PF_UQ_READS_ALIGNED;
                        }
                    }
                }
            }
            if (record.getReadFailsVendorQualityCheckFlag()) {
                return;
            }
            if (!record.getSupplementaryAlignmentFlag()) {
                this.metrics.PF_BASES += (long)record.getReadLength();
            }
            if (!record.getReadUnmappedFlag()) {
                this.metrics.PF_BASES_ALIGNED += (long)basesAlignedInRecord;
                if (!record.getDuplicateReadFlag()) {
                    this.metrics.PF_UQ_BASES_ALIGNED += (long)basesAlignedInRecord;
                }
            }
            if (record.getReadUnmappedFlag()) {
                return;
            }
            Interval read = new Interval(record.getReferenceName(), record.getAlignmentStart(), record.getAlignmentEnd());
            Set targets = TargetMetricsCollector.this.targetDetector.getOverlaps((Locatable)read);
            Set probes = TargetMetricsCollector.this.probeDetector.getOverlaps((Locatable)read);
            if (!record.getSupplementaryAlignmentFlag() && record.getReadPairedFlag() && record.getFirstOfPairFlag() && !record.getReadUnmappedFlag() && !record.getMateUnmappedFlag() && !probes.isEmpty()) {
                ++this.metrics.PF_SELECTED_PAIRS;
                if (!record.getDuplicateReadFlag()) {
                    ++this.metrics.PF_SELECTED_UNIQUE_PAIRS;
                }
            }
            int mappedBases = basesAlignedInRecord;
            int onBaitBases = 0;
            if (!probes.isEmpty()) {
                for (Interval bait : probes) {
                    for (AlignmentBlock block : record.getAlignmentBlocks()) {
                        int end = CoordMath.getEnd((int)block.getReferenceStart(), (int)block.getLength());
                        for (int pos = block.getReferenceStart(); pos <= end; ++pos) {
                            if (pos < bait.getStart() || pos > bait.getEnd()) continue;
                            ++onBaitBases;
                        }
                    }
                }
                this.metrics.ON_PROBE_BASES += (long)onBaitBases;
                this.metrics.NEAR_PROBE_BASES += (long)(mappedBases - onBaitBases);
            } else {
                this.metrics.OFF_PROBE_BASES += (long)mappedBases;
            }
            if (record.getDuplicateReadFlag()) {
                this.metrics.PCT_EXC_DUPE += (double)basesAlignedInRecord;
                return;
            }
            if (this.mapQFilter.filterOut(record)) {
                return;
            }
            if (this.clipOverlappingReads) {
                int numOverlappingBasesToClip = SAMUtils.getNumOverlappingAlignedBasesToClip((SAMRecord)record);
                rec = SAMUtils.clipOverlappingAlignedBases((SAMRecord)record, (int)numOverlappingBasesToClip, (boolean)TargetMetricsCollector.this.noSideEffects);
                this.metrics.PCT_EXC_OVERLAP += (double)numOverlappingBasesToClip;
                if (rec.getReadUnmappedFlag()) {
                    return;
                }
            } else {
                rec = record;
            }
            HashSet<Interval> coveredTargets = new HashSet<Interval>();
            for (AlignmentBlock block : rec.getAlignmentBlocks()) {
                int length = block.getLength();
                int refStart = block.getReferenceStart();
                int readStart = block.getReadStart();
                for (int offset = 0; offset < length; ++offset) {
                    int refPos = refStart + offset;
                    int readPos = readStart + offset;
                    byte qual = baseQualities[readPos - 1];
                    if (qual <= 2) {
                        this.metrics.PCT_EXC_BASEQ += 1.0;
                        continue;
                    }
                    boolean isOnTarget = false;
                    for (Interval target : targets) {
                        if (refPos < target.getStart() || refPos > target.getEnd()) continue;
                        int targetOffset = refPos - target.getStart();
                        if (qual >= this.minimumBaseQuality) {
                            ++this.metrics.ON_TARGET_BASES;
                            if (mappedInPair) {
                                ++this.metrics.ON_TARGET_FROM_PAIR_BASES;
                            }
                            Coverage highQualityCoverage = this.highQualityCoverageByTarget.get(target);
                            highQualityCoverage.addBase(targetOffset);
                            if (!coveredTargets.contains(target)) {
                                highQualityCoverage.incrementReadCount();
                                coveredTargets.add(target);
                                isOnTarget = true;
                            }
                        } else {
                            this.metrics.PCT_EXC_BASEQ += 1.0;
                        }
                        this.unfilteredCoverageByTarget.get(target).addBase(targetOffset);
                        if (this.unfilteredCoverageByTarget.get(target).getDepths()[targetOffset] > TargetMetricsCollector.this.coverageCap) continue;
                        byte by = qual;
                        this.baseQHistogramArray[by] = this.baseQHistogramArray[by] + 1L;
                    }
                    if (isOnTarget) continue;
                    this.metrics.PCT_EXC_OFF_TARGET += 1.0;
                }
            }
        }

        @Override
        public void finish() {
            this.metrics.PCT_PF_READS = (double)this.metrics.PF_READS / (double)this.metrics.TOTAL_READS;
            this.metrics.PCT_PF_UQ_READS = (double)this.metrics.PF_UNIQUE_READS / (double)this.metrics.TOTAL_READS;
            this.metrics.PCT_PF_UQ_READS_ALIGNED = (double)this.metrics.PF_UQ_READS_ALIGNED / (double)this.metrics.PF_UNIQUE_READS;
            double denominator = this.metrics.ON_PROBE_BASES + this.metrics.NEAR_PROBE_BASES + this.metrics.OFF_PROBE_BASES;
            this.metrics.PCT_SELECTED_BASES = (double)(this.metrics.ON_PROBE_BASES + this.metrics.NEAR_PROBE_BASES) / denominator;
            this.metrics.PCT_OFF_PROBE = (double)this.metrics.OFF_PROBE_BASES / denominator;
            this.metrics.ON_PROBE_VS_SELECTED = (double)this.metrics.ON_PROBE_BASES / (double)(this.metrics.ON_PROBE_BASES + this.metrics.NEAR_PROBE_BASES);
            this.metrics.MEAN_PROBE_COVERAGE = (double)this.metrics.ON_PROBE_BASES / (double)this.metrics.PROBE_TERRITORY;
            this.metrics.FOLD_ENRICHMENT = (double)this.metrics.ON_PROBE_BASES / denominator / ((double)this.metrics.PROBE_TERRITORY / (double)this.metrics.GENOME_SIZE);
            this.metrics.PCT_EXC_DUPE /= (double)this.metrics.PF_BASES_ALIGNED;
            this.metrics.PCT_EXC_MAPQ = (double)this.mapQFilter.getFilteredBases() / (double)this.metrics.PF_BASES_ALIGNED;
            this.metrics.PCT_EXC_BASEQ /= (double)this.metrics.PF_BASES_ALIGNED;
            this.metrics.PCT_EXC_OVERLAP /= (double)this.metrics.PF_BASES_ALIGNED;
            this.metrics.PCT_EXC_OFF_TARGET /= (double)this.metrics.PF_BASES_ALIGNED;
            this.calculateTargetCoverageMetrics();
            this.calculateTheoreticalHetSensitivity();
            this.calculateGcMetrics();
            this.emitPerBaseCoverageIfRequested();
        }

        private void calculateTargetCoverageMetrics() {
            long[] highQualityCoverageHistogramArray = new long[TargetMetricsCollector.this.coverageCap + 1];
            int zeroCoverageTargets = 0;
            long totalCoverage = 0L;
            long maxDepth = 0L;
            int[] targetBasesDepth = new int[]{0, 1, 2, 10, 20, 30, 40, 50, 100};
            int[] targetBases = new int[targetBasesDepth.length];
            for (Coverage c : this.highQualityCoverageByTarget.values()) {
                if (!c.hasCoverage()) {
                    ++zeroCoverageTargets;
                    highQualityCoverageHistogramArray[0] = highQualityCoverageHistogramArray[0] + (long)c.interval.length();
                    targetBases[0] = targetBases[0] + c.interval.length();
                    continue;
                }
                for (int depth : c.getDepths()) {
                    totalCoverage += (long)depth;
                    int n = Math.min(depth, TargetMetricsCollector.this.coverageCap);
                    highQualityCoverageHistogramArray[n] = highQualityCoverageHistogramArray[n] + 1L;
                    maxDepth = Math.max(maxDepth, (long)depth);
                    int i = 0;
                    while (i < targetBasesDepth.length && depth >= targetBasesDepth[i]) {
                        int n2 = i++;
                        targetBases[n2] = targetBases[n2] + 1;
                    }
                }
            }
            if (targetBases[0] != this.highQualityCoverageByTarget.keySet().stream().mapToInt(Interval::length).sum()) {
                throw new PicardException("the number of target bases with at least 0x coverage does not equal the number of target bases");
            }
            for (int i = 0; i < highQualityCoverageHistogramArray.length; ++i) {
                TargetMetricsCollector.this.highQualityDepthHistogram.increment((Comparable)Integer.valueOf(i), (double)highQualityCoverageHistogramArray[i]);
            }
            this.metrics.MEAN_TARGET_COVERAGE = (double)totalCoverage / (double)this.metrics.TARGET_TERRITORY;
            this.metrics.MEDIAN_TARGET_COVERAGE = TargetMetricsCollector.this.highQualityDepthHistogram.getMedian();
            this.metrics.MAX_TARGET_COVERAGE = maxDepth;
            this.metrics.FOLD_80_BASE_PENALTY = this.metrics.MEAN_TARGET_COVERAGE / TargetMetricsCollector.this.highQualityDepthHistogram.getPercentile(0.2);
            this.metrics.ZERO_CVG_TARGETS_PCT = (double)zeroCoverageTargets / (double)TargetMetricsCollector.this.allTargets.getIntervals().size();
            this.metrics.PCT_TARGET_BASES_1X = (double)targetBases[1] / (double)targetBases[0];
            this.metrics.PCT_TARGET_BASES_2X = (double)targetBases[2] / (double)targetBases[0];
            this.metrics.PCT_TARGET_BASES_10X = (double)targetBases[3] / (double)targetBases[0];
            this.metrics.PCT_TARGET_BASES_20X = (double)targetBases[4] / (double)targetBases[0];
            this.metrics.PCT_TARGET_BASES_30X = (double)targetBases[5] / (double)targetBases[0];
            this.metrics.PCT_TARGET_BASES_40X = (double)targetBases[6] / (double)targetBases[0];
            this.metrics.PCT_TARGET_BASES_50X = (double)targetBases[7] / (double)targetBases[0];
            this.metrics.PCT_TARGET_BASES_100X = (double)targetBases[8] / (double)targetBases[0];
        }

        private void calculateTheoreticalHetSensitivity() {
            int i2;
            long[] unfilteredDepthHistogramArray = new long[TargetMetricsCollector.this.coverageCap + 1];
            for (Coverage c : this.unfilteredCoverageByTarget.values()) {
                if (!c.hasCoverage()) {
                    unfilteredDepthHistogramArray[0] = unfilteredDepthHistogramArray[0] + (long)c.interval.length();
                    continue;
                }
                for (int depth : c.getDepths()) {
                    int n = Math.min(depth, TargetMetricsCollector.this.coverageCap);
                    unfilteredDepthHistogramArray[n] = unfilteredDepthHistogramArray[n] + 1L;
                }
            }
            if (LongStream.of(this.baseQHistogramArray).sum() != LongStream.rangeClosed(0L, TargetMetricsCollector.this.coverageCap).map(i -> i * unfilteredDepthHistogramArray[(int)i]).sum()) {
                throw new PicardException("numbers of bases in the base quality histogram and the coverage histogram are not equal");
            }
            for (i2 = 0; i2 < this.baseQHistogramArray.length; ++i2) {
                TargetMetricsCollector.this.unfilteredBaseQHistogram.increment((Comparable)Integer.valueOf(i2), (double)this.baseQHistogramArray[i2]);
            }
            for (i2 = 0; i2 < unfilteredDepthHistogramArray.length; ++i2) {
                TargetMetricsCollector.this.unfilteredDepthHistogram.increment((Comparable)Integer.valueOf(i2), (double)unfilteredDepthHistogramArray[i2]);
            }
            double[] depthDoubleArray = TheoreticalSensitivity.normalizeHistogram((Histogram<Integer>)TargetMetricsCollector.this.unfilteredDepthHistogram);
            double[] baseQDoubleArray = TheoreticalSensitivity.normalizeHistogram((Histogram<Integer>)TargetMetricsCollector.this.unfilteredBaseQHistogram);
            this.metrics.HET_SNP_SENSITIVITY = TheoreticalSensitivity.hetSNPSensitivity(depthDoubleArray, baseQDoubleArray, TargetMetricsCollector.this.sampleSize, 3.0);
            this.metrics.HET_SNP_Q = QualityUtil.getPhredScoreFromErrorProbability((double)(1.0 - this.metrics.HET_SNP_SENSITIVITY));
        }

        private void emitPerBaseCoverageIfRequested() {
            if (this.perBaseOutput == null) {
                return;
            }
            PrintWriter out = new PrintWriter(IOUtil.openFileForBufferedWriting((File)this.perBaseOutput));
            out.println("chrom\tpos\ttarget\tcoverage");
            for (Map.Entry<Interval, Coverage> entry : this.highQualityCoverageByTarget.entrySet()) {
                Interval interval = entry.getKey();
                String chrom = interval.getContig();
                int firstBase = interval.getStart();
                int[] cov = entry.getValue().getDepths();
                for (int i = 0; i < cov.length; ++i) {
                    out.print(chrom);
                    out.print('\t');
                    out.print(firstBase + i);
                    out.print('\t');
                    out.print(interval.getName());
                    out.print('\t');
                    out.print(cov[i]);
                    out.println();
                }
            }
            out.close();
        }

        private void calculateGcMetrics() {
            if (this.intervalToGc != null) {
                int i;
                PrintWriter out;
                log.info(new Object[]{"Calculating GC metrics"});
                FormatUtil fmt = new FormatUtil();
                try {
                    if (this.perTargetOutput != null) {
                        out = new PrintWriter(this.perTargetOutput);
                        out.println("chrom\tstart\tend\tlength\tname\t%gc\tmean_coverage\tnormalized_coverage\tmin_normalized_coverage\tmax_normalized_coverage\tmin_coverage\tmax_coverage\tpct_0x\tread_count");
                    } else {
                        out = null;
                    }
                }
                catch (IOException ioe) {
                    throw new RuntimeIOException((Throwable)ioe);
                }
                int bins = 101;
                long[] targetBasesByGc = new long[101];
                long[] alignedBasesByGc = new long[101];
                for (Map.Entry<Interval, Coverage> entry : this.highQualityCoverageByTarget.entrySet()) {
                    int gc;
                    Interval interval = entry.getKey();
                    Coverage cov = entry.getValue();
                    if (interval.length() <= 0) {
                        log.warn(new Object[]{"interval of length zero found: " + interval + " skipped."});
                        continue;
                    }
                    double gcDouble = this.intervalToGc.get(interval);
                    int n = gc = (int)Math.round(gcDouble * 100.0);
                    targetBasesByGc[n] = targetBasesByGc[n] + (long)interval.length();
                    int n2 = gc;
                    alignedBasesByGc[n2] = alignedBasesByGc[n2] + cov.getTotal();
                    if (out == null) continue;
                    double coverage = (double)cov.getTotal() / (double)interval.length();
                    double min = 2.147483647E9;
                    double max = -2.147483648E9;
                    double targetBasesAt0x = 0.0;
                    for (int d : cov.getDepths()) {
                        if (0 == d) {
                            targetBasesAt0x += 1.0;
                        }
                        if ((double)d < min) {
                            min = d;
                        }
                        if (!(max < (double)d)) continue;
                        max = d;
                    }
                    out.println(interval.getContig() + "\t" + interval.getStart() + "\t" + interval.getEnd() + "\t" + interval.length() + "\t" + interval.getName() + "\t" + fmt.format(gcDouble) + "\t" + fmt.format(coverage) + "\t" + fmt.format(coverage / this.metrics.MEAN_TARGET_COVERAGE) + "\t" + fmt.format(min / this.metrics.MEAN_TARGET_COVERAGE) + "\t" + fmt.format(max / this.metrics.MEAN_TARGET_COVERAGE) + "\t" + fmt.format(min) + "\t" + fmt.format(max) + "\t" + fmt.format(targetBasesAt0x / (double)interval.length()) + "\t" + fmt.format(cov.readCount));
                }
                if (out != null) {
                    out.close();
                }
                long totalTarget = 0L;
                long totalBases = 0L;
                for (i = 0; i < targetBasesByGc.length; ++i) {
                    totalTarget += targetBasesByGc[i];
                    totalBases += alignedBasesByGc[i];
                }
                for (i = 0; i < targetBasesByGc.length; ++i) {
                    double alignedPct = (double)alignedBasesByGc[i] / (double)totalBases;
                    double targetPct = (double)targetBasesByGc[i] / (double)totalTarget;
                    double dropout = (alignedPct - targetPct) * 100.0;
                    if (!(dropout < 0.0)) continue;
                    dropout = Math.abs(dropout);
                    if (i <= 50) {
                        this.metrics.AT_DROPOUT += dropout;
                    }
                    if (i < 50) continue;
                    this.metrics.GC_DROPOUT += dropout;
                }
            }
        }

        @Override
        public void addMetricsToFile(MetricsFile<METRIC_TYPE, Integer> hsMetricsComparableMetricsFile) {
            hsMetricsComparableMetricsFile.addMetric(TargetMetricsCollector.this.convertMetric(this.metrics));
            hsMetricsComparableMetricsFile.addHistogram(TargetMetricsCollector.this.highQualityDepthHistogram);
            hsMetricsComparableMetricsFile.addHistogram(TargetMetricsCollector.this.unfilteredBaseQHistogram);
        }
    }
}

