/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.Fingerprinting;
import picard.fingerprint.ClusteredCrosscheckMetric;
import picard.fingerprint.CrosscheckMetric;
import picard.util.GraphUtils;

@CommandLineProgramProperties(summary="Clusters the results from a CrosscheckFingerprints into groups that are connected according to a large enough LOD score.", oneLineSummary="Clusters the results of a CrosscheckFingerprints run by LOD score.", programGroup=Fingerprinting.class)
@DocumentedFeature
public class ClusterCrosscheckMetrics
extends CommandLineProgram {
    @Argument(shortName="I", doc="The cross-check metrics file to be clustered")
    public File INPUT;
    @Argument(shortName="O", optional=true, doc="Optional output file to write metrics to. Default is to write to stdout.")
    public File OUTPUT;
    @Argument(shortName="LOD", doc="LOD score to be used as the threshold for clustering.")
    public double LOD_THRESHOLD = 0.0;

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        if (this.OUTPUT != null) {
            IOUtil.assertFileIsWritable((File)this.OUTPUT);
        }
        MetricsFile metricsFile = this.getMetricsFile();
        try {
            metricsFile.read((Reader)new FileReader(this.INPUT));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return 1;
        }
        this.clusterMetrics(metricsFile.getMetrics()).write(this.OUTPUT);
        return 0;
    }

    private MetricsFile<ClusteredCrosscheckMetric, ?> clusterMetrics(List<CrosscheckMetric> metrics) {
        GraphUtils.Graph graph = new GraphUtils.Graph();
        metrics.stream().filter(metric -> metric.LOD_SCORE > this.LOD_THRESHOLD).forEach(metric -> {
            String lhsBy = metric.LEFT_GROUP_VALUE;
            String rhsBy = metric.RIGHT_GROUP_VALUE;
            graph.addEdge(lhsBy, rhsBy);
        });
        Map clusters = graph.cluster();
        Map<Integer, Set> collection = clusters.entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().map(Map.Entry::getKey).collect(Collectors.toSet())));
        MetricsFile clusteredMetrics = this.getMetricsFile();
        for (Map.Entry<Integer, Set> cluster : collection.entrySet()) {
            clusteredMetrics.addAllMetrics((Iterable)metrics.stream().filter(metric -> ((Set)cluster.getValue()).contains(metric.LEFT_GROUP_VALUE) && ((Set)cluster.getValue()).contains(metric.RIGHT_GROUP_VALUE)).map(metric -> {
                ClusteredCrosscheckMetric clusteredCrosscheckMetric = new ClusteredCrosscheckMetric((CrosscheckMetric)((Object)metric));
                clusteredCrosscheckMetric.CLUSTER = (Integer)cluster.getKey();
                clusteredCrosscheckMetric.CLUSTER_SIZE = ((Set)cluster.getValue()).size();
                return clusteredCrosscheckMetric;
            }).collect(Collectors.toSet()));
        }
        return clusteredMetrics;
    }
}

