/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.filter.NotPrimaryAlignmentFilter;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.SamLocusIterator;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.StringUtil;
import htsjdk.tribble.TribbleException;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeLikelihoods;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFFileReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import picard.PicardException;
import picard.fingerprint.CheckFingerprint;
import picard.fingerprint.DiploidGenotype;
import picard.fingerprint.Fingerprint;
import picard.fingerprint.FingerprintIdDetails;
import picard.fingerprint.FingerprintResults;
import picard.fingerprint.HaplotypeBlock;
import picard.fingerprint.HaplotypeMap;
import picard.fingerprint.HaplotypeProbabilities;
import picard.fingerprint.HaplotypeProbabilitiesFromContaminatorSequence;
import picard.fingerprint.HaplotypeProbabilitiesFromGenotype;
import picard.fingerprint.HaplotypeProbabilitiesFromGenotypeLikelihoods;
import picard.fingerprint.HaplotypeProbabilitiesFromSequence;
import picard.fingerprint.HaplotypeProbabilityOfNormalGivenTumor;
import picard.fingerprint.LocusResult;
import picard.fingerprint.MatchResults;
import picard.fingerprint.Snp;
import picard.util.AlleleSubsettingUtils;

public class FingerprintChecker {
    public static final double DEFAULT_GENOTYPING_ERROR_RATE = 0.01;
    public static final int DEFAULT_MINIMUM_MAPPING_QUALITY = 10;
    public static final int DEFAULT_MINIMUM_BASE_QUALITY = 20;
    public static final int DEFAULT_MAXIMAL_PL_DIFFERENCE = 30;
    private final HaplotypeMap haplotypes;
    private int minimumBaseQuality = 20;
    private int minimumMappingQuality = 10;
    private double genotypingErrorRate = 0.01;
    private int maximalPLDifference = 30;
    private ValidationStringency validationStringency = ValidationStringency.DEFAULT_STRINGENCY;
    private boolean allowDuplicateReads = false;
    private double pLossofHet = 0.0;
    private final Log log = Log.getInstance(FingerprintChecker.class);

    public ValidationStringency getValidationStringency() {
        return this.validationStringency;
    }

    public void setValidationStringency(ValidationStringency validationStringency) {
        this.validationStringency = validationStringency;
    }

    public FingerprintChecker(File haplotypeData) {
        this.haplotypes = new HaplotypeMap(haplotypeData);
    }

    public FingerprintChecker(HaplotypeMap haplotypes) {
        this.haplotypes = haplotypes;
    }

    public void setMinimumBaseQuality(int minimumBaseQuality) {
        this.minimumBaseQuality = minimumBaseQuality;
    }

    public void setMinimumMappingQuality(int minimumMappingQuality) {
        this.minimumMappingQuality = minimumMappingQuality;
    }

    public void setGenotypingErrorRate(double genotypingErrorRate) {
        this.genotypingErrorRate = genotypingErrorRate;
    }

    public void setmaximalPLDifference(int maximalPLDifference) {
        this.maximalPLDifference = maximalPLDifference;
    }

    public SAMFileHeader getHeader() {
        return this.haplotypes.getHeader();
    }

    public void setAllowDuplicateReads(boolean allowDuplicateReads) {
        this.allowDuplicateReads = allowDuplicateReads;
    }

    public void setpLossofHet(double pLossofHet) {
        this.pLossofHet = pLossofHet;
    }

    public Map<String, Fingerprint> loadFingerprints(File fingerprintFile, String specificSample) {
        SequenceUtil.assertSequenceDictionariesEqual((SAMSequenceDictionary)this.haplotypes.getHeader().getSequenceDictionary(), (SAMSequenceDictionary)VCFFileReader.getSequenceDictionary((File)fingerprintFile));
        if (FingerprintChecker.isQueryable(fingerprintFile)) {
            return this.loadFingerprintsFromIndexedVcf(fingerprintFile, specificSample);
        }
        this.log.warn(new Object[]{"Couldn't find index for file " + fingerprintFile + " going to read through it all."});
        return this.loadFingerprintsFromNonIndexedVcf(fingerprintFile, specificSample);
    }

    public Map<String, Fingerprint> loadFingerprintsFromNonIndexedVcf(File fingerprintFile, String specificSample) {
        VCFFileReader reader = new VCFFileReader(fingerprintFile, false);
        HashMap<String, Fingerprint> fingerprints = new HashMap<String, Fingerprint>();
        HashSet<String> samples = null;
        for (VariantContext ctx : reader) {
            if (samples == null) {
                if (specificSample != null) {
                    samples = new HashSet<String>();
                    samples.add(specificSample);
                } else {
                    samples = ctx.getSampleNames();
                    if (samples == null) {
                        this.log.warn(new Object[]{"No samples found in file " + fingerprintFile + ". Skipping file."});
                        return Collections.emptyMap();
                    }
                }
                samples.forEach(s -> fingerprints.put((String)s, new Fingerprint((String)s, fingerprintFile, null)));
            }
            try {
                this.getFingerprintFromVc(fingerprints, ctx);
            }
            catch (IllegalArgumentException e) {
                this.log.warn(new Object[]{"There was a genotyping error in File: " + fingerprintFile + "\n" + e.getMessage()});
            }
        }
        return fingerprints;
    }

    public Map<String, Fingerprint> loadFingerprintsFromIndexedVcf(File fingerprintFile, String specificSample) {
        VCFFileReader reader = new VCFFileReader(fingerprintFile, true);
        SequenceUtil.assertSequenceDictionariesEqual((SAMSequenceDictionary)this.haplotypes.getHeader().getSequenceDictionary(), (SAMSequenceDictionary)VCFFileReader.getSequenceDictionary((File)fingerprintFile));
        TreeSet<Snp> snps = new TreeSet<Snp>(this.haplotypes.getAllSnps());
        HashMap<String, Fingerprint> fingerprints = new HashMap<String, Fingerprint>();
        HashSet<String> samples = null;
        for (Snp snp : snps) {
            VariantContext ctx = (VariantContext)reader.query(snp.getChrom(), snp.getPos(), snp.getPos()).next();
            if (ctx == null) continue;
            if (samples == null) {
                if (specificSample != null) {
                    samples = new HashSet<String>();
                    samples.add(specificSample);
                } else {
                    samples = ctx.getSampleNames();
                    if (samples == null) {
                        this.log.warn(new Object[]{"No samples found in file " + fingerprintFile + ". Skipping file."});
                        return Collections.emptyMap();
                    }
                }
                samples.forEach(s -> fingerprints.put((String)s, new Fingerprint((String)s, fingerprintFile, null)));
            }
            try {
                this.getFingerprintFromVc(fingerprints, ctx);
            }
            catch (IllegalArgumentException e) {
                this.log.warn(new Object[]{"There was a genotyping error in File: " + fingerprintFile + "\n" + e.getMessage()});
            }
        }
        return fingerprints;
    }

    private void getFingerprintFromVc(Map<String, Fingerprint> fingerprints, VariantContext ctx) throws IllegalArgumentException {
        HaplotypeBlock h = this.haplotypes.getHaplotype(ctx.getContig(), ctx.getStart());
        Snp snp = this.haplotypes.getSnp(ctx.getContig(), ctx.getStart());
        if (h == null) {
            return;
        }
        VariantContext usableSnp = AlleleSubsettingUtils.subsetVCToMatchSnp(ctx, snp);
        if (usableSnp == null) {
            return;
        }
        boolean allelesOk = true;
        for (Allele allele : usableSnp.getAlleles()) {
            byte[] bases = allele.getBases();
            if (bases.length <= 1 && (bases[0] == snp.getAllele1() || bases[0] == snp.getAllele2())) continue;
            allelesOk = false;
        }
        if (!allelesOk) {
            this.log.warn(new Object[]{"Problem with genotype file: Alleles " + usableSnp.getAlleles() + " do not match to alleles for SNP " + snp + " with alleles " + snp.getAlleleString()});
            throw new IllegalArgumentException("Alleles do not match between database and file");
        }
        for (String sample : fingerprints.keySet()) {
            Fingerprint fp = fingerprints.get(sample);
            Genotype genotype = usableSnp.getGenotype(sample);
            if (genotype == null) {
                throw new IllegalArgumentException("Cannot find sample " + sample + " in provided file. ");
            }
            if (genotype.hasPL()) {
                HaplotypeProbabilitiesFromGenotypeLikelihoods hFp = new HaplotypeProbabilitiesFromGenotypeLikelihoods(h);
                int[] pls = genotype.getPL();
                int[] newPLs = new int[pls.length];
                for (int i = 0; i < pls.length; ++i) {
                    newPLs[i] = Math.min(this.maximalPLDifference, pls[i]);
                }
                hFp.addToLogLikelihoods(snp, usableSnp.getAlleles(), GenotypeLikelihoods.fromPLs((int[])newPLs).getAsVector());
                fp.add(hFp);
                continue;
            }
            if (genotype.isNoCall() || fp.containsKey(h)) continue;
            boolean hom = genotype.isHom();
            byte allele = StringUtil.toUpperCase((byte)genotype.getAllele(0).getBases()[0]);
            double halfError = this.genotypingErrorRate / 2.0;
            double accuracy = 1.0 - this.genotypingErrorRate;
            double[] probs = new double[]{hom && allele == snp.getAllele1() ? accuracy : halfError, !hom ? accuracy : halfError, hom && allele == snp.getAllele2() ? accuracy : halfError};
            fp.add(new HaplotypeProbabilitiesFromGenotype(snp, h, probs[0], probs[1], probs[2]));
        }
    }

    public IntervalList getLociToGenotype(Collection<Fingerprint> fingerprints) {
        IntervalList intervals = new IntervalList(this.haplotypes.getHeader());
        for (Fingerprint fp : fingerprints) {
            for (HaplotypeProbabilities genotype : fp.values()) {
                HaplotypeBlock h = genotype.getHaplotype();
                for (Snp snp : h.getSnps()) {
                    intervals.add(new Interval(snp.getChrom(), snp.getPos(), snp.getPos(), false, snp.getName()));
                }
            }
        }
        return intervals.uniqued();
    }

    public Map<FingerprintIdDetails, Fingerprint> fingerprintVcf(File vcfFile) {
        HashMap<FingerprintIdDetails, Fingerprint> fpIdMap = new HashMap<FingerprintIdDetails, Fingerprint>();
        Map<String, Fingerprint> sampleFpMap = this.loadFingerprints(vcfFile, null);
        sampleFpMap.forEach((key, value) -> {
            FingerprintIdDetails fpId = new FingerprintIdDetails();
            fpId.sample = key;
            fpId.file = vcfFile.getAbsolutePath();
            fpIdMap.put(fpId, (Fingerprint)value);
        });
        return fpIdMap;
    }

    public Map<FingerprintIdDetails, Fingerprint> fingerprintSamFile(File samFile, IntervalList loci) {
        SamReader in = SamReaderFactory.makeDefault().enable(new SamReaderFactory.Option[]{SamReaderFactory.Option.CACHE_FILE_BASED_INDEXES}).open(samFile);
        SequenceUtil.assertSequenceDictionariesEqual((SAMSequenceDictionary)this.haplotypes.getHeader().getSequenceDictionary(), (SAMSequenceDictionary)in.getFileHeader().getSequenceDictionary());
        SamLocusIterator iterator = new SamLocusIterator(in, loci, in.hasIndex());
        iterator.setEmitUncoveredLoci(true);
        iterator.setMappingQualityScoreCutoff(this.minimumMappingQuality);
        iterator.setQualityScoreCutoff(this.minimumBaseQuality);
        if (this.allowDuplicateReads) {
            ArrayList<NotPrimaryAlignmentFilter> filters = new ArrayList<NotPrimaryAlignmentFilter>(1);
            filters.add(new NotPrimaryAlignmentFilter());
            iterator.setSamFilters(filters);
        }
        HashMap<SAMReadGroupRecord, FingerprintIdDetails> fingerprintIdDetailsMap = new HashMap<SAMReadGroupRecord, FingerprintIdDetails>();
        HashMap<FingerprintIdDetails, Fingerprint> fingerprintsByReadGroup = new HashMap<FingerprintIdDetails, Fingerprint>();
        for (SAMReadGroupRecord rg : in.getFileHeader().getReadGroups()) {
            FingerprintIdDetails id = new FingerprintIdDetails(rg.getPlatformUnit(), samFile.getAbsolutePath());
            id.library = rg.getLibrary();
            id.sample = rg.getSample();
            fingerprintIdDetailsMap.put(rg, id);
            Fingerprint fingerprint = new Fingerprint(id.sample, samFile, id.platformUnit);
            fingerprintsByReadGroup.put(id, fingerprint);
            for (HaplotypeBlock h : this.haplotypes.getHaplotypes()) {
                fingerprint.add(new HaplotypeProbabilitiesFromSequence(h));
            }
        }
        HashSet<String> usedReadNames = new HashSet<String>(10000);
        for (SamLocusIterator.LocusInfo info : iterator) {
            HaplotypeBlock haplotypeBlock = this.haplotypes.getHaplotype(info.getSequenceName(), info.getPosition());
            Snp snp = this.haplotypes.getSnp(info.getSequenceName(), info.getPosition());
            for (SamLocusIterator.RecordAndOffset rec : info.getRecordAndOffsets()) {
                SAMReadGroupRecord rg = rec.getRecord().getReadGroup();
                if (rg == null && !fingerprintIdDetailsMap.containsKey(rg)) {
                    FingerprintIdDetails unknownFPDetails = this.createUnknownFP(samFile, rec.getRecord());
                    fingerprintIdDetailsMap.put(null, unknownFPDetails);
                    Fingerprint fp = new Fingerprint(unknownFPDetails.sample, new File(unknownFPDetails.file), unknownFPDetails.platformUnit);
                    fingerprintsByReadGroup.put(unknownFPDetails, fp);
                    for (HaplotypeBlock h : this.haplotypes.getHaplotypes()) {
                        fp.add(new HaplotypeProbabilitiesFromSequence(h));
                    }
                }
                if (fingerprintIdDetailsMap.containsKey(rg)) {
                    FingerprintIdDetails details = (FingerprintIdDetails)fingerprintIdDetailsMap.get(rg);
                    String readName = rec.getRecord().getReadName();
                    if (usedReadNames.contains(readName)) continue;
                    HaplotypeProbabilitiesFromSequence probs = (HaplotypeProbabilitiesFromSequence)((Fingerprint)fingerprintsByReadGroup.get(details)).get(haplotypeBlock);
                    byte base = StringUtil.toUpperCase((byte)rec.getReadBase());
                    byte qual = rec.getBaseQuality();
                    probs.addToProbs(snp, base, qual);
                    usedReadNames.add(readName);
                    continue;
                }
                PicardException e = new PicardException("Unknown read group: " + rg + " in file: " + samFile);
                this.log.error((Throwable)e, new Object[0]);
                throw e;
            }
        }
        return fingerprintsByReadGroup;
    }

    private FingerprintIdDetails createUnknownFP(File samFile, SAMRecord rec) {
        PicardException e = new PicardException("Found read with no readgroup: " + rec.getReadName() + " in file: " + samFile);
        if (this.validationStringency != ValidationStringency.STRICT) {
            SAMReadGroupRecord readGroupRecord = new SAMReadGroupRecord("<UNKNOWN>:::" + samFile.getAbsolutePath());
            readGroupRecord.setLibrary("<UNKNOWN>");
            readGroupRecord.setSample("<UNKNOWN>");
            readGroupRecord.setPlatformUnit("<UNKNOWN>.0.ZZZ");
            if (this.validationStringency == ValidationStringency.LENIENT) {
                this.log.warn((Throwable)e, new Object[0]);
                this.log.warn(new Object[]{"further messages from this file will be suppressed"});
            }
            return new FingerprintIdDetails(readGroupRecord, samFile.getAbsolutePath());
        }
        this.log.error((Throwable)e, new Object[0]);
        throw e;
    }

    public Map<String, Fingerprint> identifyContaminant(File samFile, double contamination, int locusMaxReads) {
        SamReader in = SamReaderFactory.makeDefault().enable(new SamReaderFactory.Option[]{SamReaderFactory.Option.CACHE_FILE_BASED_INDEXES}).open(samFile);
        SequenceUtil.assertSequenceDictionariesEqual((SAMSequenceDictionary)this.haplotypes.getHeader().getSequenceDictionary(), (SAMSequenceDictionary)in.getFileHeader().getSequenceDictionary());
        SamLocusIterator iterator = new SamLocusIterator(in, this.haplotypes.getIntervalList(), in.hasIndex());
        iterator.setEmitUncoveredLoci(true);
        iterator.setMappingQualityScoreCutoff(this.minimumMappingQuality);
        iterator.setQualityScoreCutoff(this.minimumBaseQuality);
        if (this.allowDuplicateReads) {
            ArrayList<NotPrimaryAlignmentFilter> filters = new ArrayList<NotPrimaryAlignmentFilter>(1);
            filters.add(new NotPrimaryAlignmentFilter());
            iterator.setSamFilters(filters);
        }
        HashMap<String, Fingerprint> fingerprintsBySample = new HashMap<String, Fingerprint>();
        for (SAMReadGroupRecord rg : in.getFileHeader().getReadGroups()) {
            if (fingerprintsBySample.containsKey(rg.getSample())) continue;
            Fingerprint fingerprint = new Fingerprint(rg.getSample(), samFile, rg.getSample());
            for (HaplotypeBlock h : this.haplotypes.getHaplotypes()) {
                fingerprint.add(new HaplotypeProbabilitiesFromContaminatorSequence(h, contamination));
            }
            fingerprintsBySample.put(rg.getSample(), fingerprint);
        }
        HashSet<String> usedReadNames = new HashSet<String>(10000);
        for (SamLocusIterator.LocusInfo info : iterator) {
            HaplotypeBlock haplotypeBlock = this.haplotypes.getHaplotype(info.getSequenceName(), info.getPosition());
            Snp snp = this.haplotypes.getSnp(info.getSequenceName(), info.getPosition());
            List<SamLocusIterator.RecordAndOffset> recordAndOffsetList = FingerprintChecker.randomSublist(info.getRecordAndPositions(), locusMaxReads);
            for (SamLocusIterator.RecordAndOffset rec : recordAndOffsetList) {
                SAMReadGroupRecord rg = rec.getRecord().getReadGroup();
                if (rg == null || !fingerprintsBySample.containsKey(rg.getSample())) {
                    PicardException e = new PicardException("Unknown sample: " + (rg != null ? rg.getSample() : "(null readgroup)"));
                    this.log.error((Throwable)e, new Object[0]);
                    throw e;
                }
                String readName = rec.getRecord().getReadName();
                if (usedReadNames.contains(readName)) continue;
                HaplotypeProbabilitiesFromContaminatorSequence probs = (HaplotypeProbabilitiesFromContaminatorSequence)((Fingerprint)fingerprintsBySample.get(rg.getSample())).get(haplotypeBlock);
                byte base = StringUtil.toUpperCase((byte)rec.getReadBase());
                byte qual = rec.getBaseQuality();
                probs.addToProbs(snp, base, qual);
                usedReadNames.add(readName);
            }
        }
        return fingerprintsBySample;
    }

    protected static <T> List<T> randomSublist(List<T> list, int n) {
        int availableElements = list.size();
        if (availableElements <= n) {
            return list;
        }
        int stillNeeded = n;
        Random rg = new Random();
        ArrayList<T> shortList = new ArrayList<T>(n);
        for (T aList : list) {
            if (rg.nextDouble() < (double)stillNeeded / (double)availableElements) {
                shortList.add(aList);
                --stillNeeded;
            }
            if (stillNeeded == 0) break;
            --availableElements;
        }
        return shortList;
    }

    public Map<FingerprintIdDetails, Fingerprint> fingerprintFiles(Collection<File> files, int threads, int waitTime, TimeUnit waitTimeUnit) {
        AtomicInteger filesRead = new AtomicInteger(0);
        ExecutorService executor = Executors.newFixedThreadPool(threads, new ThreadFactoryBuilder().setDaemon(true).build());
        IntervalList intervals = this.haplotypes.getIntervalList();
        ConcurrentHashMap<FingerprintIdDetails, Fingerprint> retval = new ConcurrentHashMap<FingerprintIdDetails, Fingerprint>();
        HashMap futures = new HashMap(files.size());
        for (File file : files) {
            futures.put(executor.submit(() -> {
                try {
                    if (CheckFingerprint.isBamOrSamFile(f)) {
                        retval.putAll(this.fingerprintSamFile(f, intervals));
                    } else {
                        retval.putAll(this.fingerprintVcf(f));
                    }
                    this.log.debug(new Object[]{"Processed file: " + f.getAbsolutePath() + " (" + filesRead.get() + ")"});
                    if (filesRead.incrementAndGet() % 100 == 0) {
                        this.log.info(new Object[]{"Processed " + filesRead.get() + " out of " + files.size()});
                    }
                }
                catch (Exception e) {
                    this.log.warn(new Object[]{"Exception thrown in thread:" + e.getMessage()});
                    throw e;
                }
            }), file);
        }
        executor.shutdown();
        try {
            executor.awaitTermination(waitTime, waitTimeUnit);
        }
        catch (InterruptedException ie) {
            this.log.warn((Throwable)ie, new Object[]{"Interrupted while waiting for executor to terminate."});
        }
        for (Map.Entry entry : futures.entrySet()) {
            try {
                ((Future)entry.getKey()).get();
            }
            catch (InterruptedException | ExecutionException e) {
                this.log.error(new Object[]{"Failed to fingerprint on file: " + entry.getValue()});
                throw new RuntimeException(e);
            }
        }
        return retval;
    }

    public List<FingerprintResults> checkFingerprints(List<File> samFiles, List<File> genotypeFiles, String specificSample, boolean ignoreReadGroups) {
        LinkedList<Fingerprint> expectedFingerprints = new LinkedList<Fingerprint>();
        for (File f : genotypeFiles) {
            expectedFingerprints.addAll(this.loadFingerprints(f, specificSample).values());
        }
        if (expectedFingerprints.isEmpty()) {
            throw new IllegalStateException("Could not find any fingerprints in: " + genotypeFiles);
        }
        ArrayList<FingerprintResults> resultsList = new ArrayList<FingerprintResults>();
        IntervalList intervals = this.getLociToGenotype(expectedFingerprints);
        for (File f : samFiles) {
            Map<FingerprintIdDetails, Fingerprint> fingerprintsByReadGroup = this.fingerprintSamFile(f, intervals);
            if (ignoreReadGroups) {
                Fingerprint combinedFp = new Fingerprint(specificSample, f, null);
                fingerprintsByReadGroup.values().forEach(combinedFp::merge);
                FingerprintResults results = new FingerprintResults(f, null, specificSample);
                for (Fingerprint expectedFp : expectedFingerprints) {
                    MatchResults result = FingerprintChecker.calculateMatchResults(combinedFp, expectedFp, 0.0, this.pLossofHet);
                    results.addResults(result);
                }
                resultsList.add(results);
                continue;
            }
            for (FingerprintIdDetails rg : fingerprintsByReadGroup.keySet()) {
                FingerprintResults results = new FingerprintResults(f, rg.platformUnit, rg.sample);
                for (Fingerprint expectedFp : expectedFingerprints) {
                    MatchResults result = FingerprintChecker.calculateMatchResults(fingerprintsByReadGroup.get(rg), expectedFp, 0.0, this.pLossofHet);
                    results.addResults(result);
                }
                resultsList.add(results);
            }
        }
        return resultsList;
    }

    public List<FingerprintResults> checkFingerprints(List<File> observedGenotypeFiles, List<File> expectedGenotypeFiles, String observedSample, String expectedSample) {
        ArrayList<Fingerprint> expectedFingerprints = new ArrayList<Fingerprint>();
        for (File f : expectedGenotypeFiles) {
            expectedFingerprints.addAll(this.loadFingerprints(f, expectedSample).values());
        }
        if (expectedFingerprints.isEmpty()) {
            throw new IllegalStateException("Could not find any fingerprints in: " + expectedGenotypeFiles);
        }
        ArrayList<FingerprintResults> resultsList = new ArrayList<FingerprintResults>();
        for (File f : observedGenotypeFiles) {
            Map<String, Fingerprint> observedFingerprintsBySample = this.loadFingerprints(f, observedSample);
            if (observedFingerprintsBySample.isEmpty()) {
                throw new IllegalStateException("Found no fingerprints in observed genotypes file: " + observedGenotypeFiles);
            }
            for (String sample : observedFingerprintsBySample.keySet()) {
                FingerprintResults results = new FingerprintResults(f, null, sample);
                for (Fingerprint expectedFp : expectedFingerprints) {
                    MatchResults result = FingerprintChecker.calculateMatchResults(observedFingerprintsBySample.get(sample), expectedFp, 0.0, this.pLossofHet);
                    results.addResults(result);
                }
                resultsList.add(results);
            }
        }
        return resultsList;
    }

    public static MatchResults calculateMatchResults(Fingerprint observedFp, Fingerprint expectedFp, double minPExpected, double pLoH) {
        ArrayList<LocusResult> locusResults = new ArrayList<LocusResult>();
        double llThisSample = 0.0;
        double llOtherSample = 0.0;
        double lodExpectedSampleTumorNormal = 0.0;
        double lodExpectedSampleNormalTumor = 0.0;
        double lminPExpected = Math.log10(minPExpected);
        for (HaplotypeProbabilities probs2 : expectedFp.values()) {
            HaplotypeBlock haplotypeBlock = probs2.getHaplotype();
            HaplotypeProbabilities probs1 = (HaplotypeProbabilities)observedFp.get(haplotypeBlock);
            if (probs1 == null) continue;
            HaplotypeProbabilityOfNormalGivenTumor prob1AssumingDataFromTumor = new HaplotypeProbabilityOfNormalGivenTumor(probs1, pLoH);
            HaplotypeProbabilityOfNormalGivenTumor prob2AssumingDataFromTumor = new HaplotypeProbabilityOfNormalGivenTumor(probs2, pLoH);
            Snp snp = probs2.getRepresentativeSnp();
            DiploidGenotype externalGenotype = probs2.getMostLikelyGenotype(snp);
            LocusResult lr = new LocusResult(snp, externalGenotype, probs1.getMostLikelyGenotype(snp), probs1.getObsAllele1(), probs1.getObsAllele2(), probs1.getLodMostProbableGenotype(), probs1.shiftedLogEvidenceProbabilityGivenOtherEvidence(probs2), probs1.shiftedLogEvidenceProbability(), prob1AssumingDataFromTumor.shiftedLogEvidenceProbabilityGivenOtherEvidence(probs2) - prob1AssumingDataFromTumor.shiftedLogEvidenceProbability(), probs1.shiftedLogEvidenceProbabilityGivenOtherEvidence(prob2AssumingDataFromTumor) - probs1.shiftedLogEvidenceProbability());
            locusResults.add(lr);
            if (!probs1.hasEvidence() || !probs2.hasEvidence()) continue;
            double lRandom = lr.lRandomSample();
            double lExpected = Math.max(lminPExpected, lr.lExpectedSample());
            llThisSample += lExpected;
            llOtherSample += lRandom;
            lodExpectedSampleTumorNormal += lr.getLodExpectedSampleTumorNormal();
            lodExpectedSampleNormalTumor += lr.getLodExpectedSampleNormalTumor();
        }
        return new MatchResults(expectedFp.getSource(), expectedFp.getSample(), llThisSample, llOtherSample, lodExpectedSampleTumorNormal, lodExpectedSampleNormalTumor, locusResults);
    }

    public static MatchResults calculateMatchResults(Fingerprint observedFp, Fingerprint expectedFp) {
        return FingerprintChecker.calculateMatchResults(observedFp, expectedFp, 0.0, 0.0);
    }

    static boolean isQueryable(File vcf) {
        if (!vcf.isFile()) {
            return false;
        }
        try (VCFFileReader reader = new VCFFileReader(vcf, false);){
            reader.query(reader.getFileHeader().getSequenceDictionary().getSequence(0).getSequenceName(), 1, 1);
        }
        catch (TribbleException e) {
            return false;
        }
        return true;
    }
}

