/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import picard.fingerprint.HaplotypeProbabilities;
import picard.fingerprint.Snp;

public class HaplotypeProbabilityOfNormalGivenTumor
extends HaplotypeProbabilities {
    private final double[][] transitionMatrix;
    private final HaplotypeProbabilities hpOfTumor;

    public HaplotypeProbabilityOfNormalGivenTumor(HaplotypeProbabilities hpOfTumor, double pLoH) {
        super(hpOfTumor.getHaplotype());
        this.hpOfTumor = hpOfTumor;
        this.transitionMatrix = new double[][]{{1.0, 0.0, 0.0}, {pLoH / 2.0, 1.0 - pLoH, pLoH / 2.0}, {0.0, 0.0, 1.0}};
    }

    @Override
    public double[] getLikelihoods() {
        double[] normalHaplotypeLikelihoods = new double[3];
        double[] tumorHaplotypeLikelihoods = this.hpOfTumor.getLikelihoods();
        for (HaplotypeProbabilities.Genotype g_n : HaplotypeProbabilities.Genotype.values()) {
            normalHaplotypeLikelihoods[g_n.v] = 0.0;
            for (HaplotypeProbabilities.Genotype g_t : HaplotypeProbabilities.Genotype.values()) {
                int n = g_n.v;
                normalHaplotypeLikelihoods[n] = normalHaplotypeLikelihoods[n] + tumorHaplotypeLikelihoods[g_t.v] * this.transitionMatrix[g_n.v][g_t.v];
            }
        }
        return normalHaplotypeLikelihoods;
    }

    @Override
    public Snp getRepresentativeSnp() {
        return this.hpOfTumor.getRepresentativeSnp();
    }

    @Override
    public void merge(HaplotypeProbabilities ignored) {
        throw new IllegalArgumentException("Cannot merge HaplotypeProbabilityOfNormalGivenTumor. Merge the underlying object and create a new wrapper.");
    }

    @Override
    public int getObsAllele1() {
        return this.hpOfTumor.getObsAllele1();
    }

    @Override
    public int getObsAllele2() {
        return this.hpOfTumor.getObsAllele2();
    }

    @Override
    public int getTotalObs() {
        return this.hpOfTumor.getTotalObs();
    }

    @Override
    public boolean hasEvidence() {
        return this.hpOfTumor.hasEvidence();
    }
}

