/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.SortingCollection;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import picard.PicardException;
import picard.illumina.BasecallsConverter;
import picard.illumina.parser.BaseIlluminaDataProvider;
import picard.illumina.parser.ClusterData;
import picard.illumina.parser.IlluminaDataProviderFactory;
import picard.illumina.parser.IlluminaFileUtil;
import picard.illumina.parser.NewIlluminaDataProvider;
import picard.illumina.parser.ParameterizedFileUtil;
import picard.illumina.parser.ReadStructure;
import picard.illumina.parser.readers.AbstractIlluminaPositionFileReader;
import picard.illumina.parser.readers.BclQualityEvaluationStrategy;
import picard.illumina.parser.readers.LocsFileReader;
import picard.util.ThreadPoolExecutorWithExceptions;

public class NewIlluminaBasecallsConverter<CLUSTER_OUTPUT_RECORD>
extends BasecallsConverter<CLUSTER_OUTPUT_RECORD> {
    private static final Log log = Log.getInstance(NewIlluminaBasecallsConverter.class);
    private final List<File> cbcls;
    private final List<AbstractIlluminaPositionFileReader.PositionInfo> locs = new ArrayList<AbstractIlluminaPositionFileReader.PositionInfo>();
    private final File[] filterFiles;
    private final Map<String, ThreadPoolExecutorWithExceptions> barcodeWriterThreads = new HashMap<String, ThreadPoolExecutorWithExceptions>();
    private final Map<Integer, List<RecordWriter>> completedWork = Collections.synchronizedMap(new HashMap());
    private final Map<Integer, File> barcodesFiles = new HashMap<Integer, File>();

    public NewIlluminaBasecallsConverter(File basecallsDir, File barcodesDir, int lane, ReadStructure readStructure, Map<String, ? extends BasecallsConverter.ConvertedClusterDataWriter<CLUSTER_OUTPUT_RECORD>> barcodeRecordWriterMap, boolean demultiplex, int maxReadsInRamPerTile, List<File> tmpDirs, int numProcessors, Integer firstTile, Integer tileLimit, Comparator<CLUSTER_OUTPUT_RECORD> outputRecordComparator, SortingCollection.Codec<CLUSTER_OUTPUT_RECORD> codecPrototype, Class<CLUSTER_OUTPUT_RECORD> outputRecordClass, BclQualityEvaluationStrategy bclQualityEvaluationStrategy, boolean ignoreUnexpectedBarcodes) {
        super(barcodeRecordWriterMap, maxReadsInRamPerTile, tmpDirs, codecPrototype, ignoreUnexpectedBarcodes, demultiplex, outputRecordComparator, bclQualityEvaluationStrategy, outputRecordClass, numProcessors, new IlluminaDataProviderFactory(basecallsDir, barcodesDir, lane, readStructure, bclQualityEvaluationStrategy));
        this.tiles = new ArrayList();
        barcodeRecordWriterMap.keySet().forEach(barcode -> this.barcodeWriterThreads.put((String)barcode, new ThreadPoolExecutorWithExceptions(1)));
        File laneDir = new File(basecallsDir, IlluminaFileUtil.longLaneStr(lane));
        File[] cycleDirs = IOUtil.getFilesMatchingRegexp((File)laneDir, (Pattern)IlluminaFileUtil.CYCLE_SUBDIRECTORY_PATTERN);
        this.cbcls = new ArrayList<File>();
        Arrays.asList(cycleDirs).forEach(cycleDir -> this.cbcls.addAll(Arrays.asList(IOUtil.getFilesMatchingRegexp((File)cycleDir, (String)("^" + IlluminaFileUtil.longLaneStr(lane) + "_(\\d{1,5}).cbcl$")))));
        if (this.cbcls.size() == 0) {
            throw new PicardException("No CBCL files found.");
        }
        IOUtil.assertFilesAreReadable(this.cbcls);
        File locsFile = new File(basecallsDir.getParentFile(), "s.locs");
        File[] fileArray = null;
        try (LocsFileReader locsFileReader = new LocsFileReader(locsFile);){
            while (locsFileReader.hasNext()) {
                this.locs.add(locsFileReader.next());
            }
        }
        catch (Throwable object) {
            fileArray = object;
            throw object;
        }
        IOUtil.assertFileIsReadable((File)locsFile);
        Pattern filterRegex = Pattern.compile(ParameterizedFileUtil.escapePeriods(ParameterizedFileUtil.makeLaneTileRegex(".filter", lane)));
        for (File filterFile : this.filterFiles = NewIlluminaBasecallsConverter.getTiledFiles(laneDir, filterRegex)) {
            Matcher tileMatcher = filterRegex.matcher(filterFile.getName());
            if (!tileMatcher.matches()) continue;
            this.tiles.add(Integer.valueOf(tileMatcher.group(1)));
        }
        IOUtil.assertFilesAreReadable(Arrays.asList(this.filterFiles));
        this.tiles.sort(TILE_NUMBER_COMPARATOR);
        if (demultiplex) {
            Pattern barcodeRegex = Pattern.compile(ParameterizedFileUtil.escapePeriods(ParameterizedFileUtil.makeLaneTileRegex("_barcode.txt(\\.gz|\\.bz2)?", lane)));
            File[] barcodeTileFiles = NewIlluminaBasecallsConverter.getTiledFiles(barcodesDir, barcodeRegex);
            if (barcodeTileFiles.length != this.tiles.size()) {
                throw new PicardException(String.format("Barcode files are required for each tile. Found %d expected %d.", barcodeTileFiles.length, this.tiles.size()));
            }
            for (File barcodeFile : barcodeTileFiles) {
                Matcher tileMatcher = barcodeRegex.matcher(barcodeFile.getName());
                if (!tileMatcher.matches()) continue;
                this.barcodesFiles.put(Integer.valueOf(tileMatcher.group(1)), barcodeFile);
            }
        }
        this.setTileLimits(firstTile, tileLimit);
    }

    public static File[] getTiledFiles(File baseDirectory, Pattern pattern) {
        return IOUtil.getFilesMatchingRegexp((File)baseDirectory, (Pattern)pattern);
    }

    @Override
    public void doTileProcessing() {
        ThreadPoolExecutorWithExceptions completedWorkExecutor = new ThreadPoolExecutorWithExceptions(1);
        CompletedWorkChecker workChecker = new CompletedWorkChecker();
        completedWorkExecutor.submit(workChecker);
        completedWorkExecutor.shutdown();
        ThreadPoolExecutorWithExceptions tileProcessingExecutor = new ThreadPoolExecutorWithExceptions(this.numThreads);
        for (Integer tile : this.tiles) {
            tileProcessingExecutor.submit(new TileProcessor(tile, this.barcodesFiles.get(tile)));
        }
        tileProcessingExecutor.shutdown();
        this.awaitThreadPoolTermination("Reading executor", tileProcessingExecutor);
        this.awaitThreadPoolTermination("Tile completion executor", completedWorkExecutor);
        this.barcodeWriterThreads.values().forEach(ThreadPoolExecutor::shutdown);
        this.barcodeWriterThreads.forEach((barcode, executor) -> this.awaitThreadPoolTermination(barcode + " writer", (ThreadPoolExecutor)executor));
    }

    private void awaitThreadPoolTermination(String executorName, ThreadPoolExecutor executorService) {
        try {
            while (!executorService.awaitTermination(300L, TimeUnit.SECONDS)) {
                log.info(new Object[]{String.format("%s waiting for job completion. Finished jobs - %d : Running jobs - %d : Queued jobs  - %d", executorName, executorService.getCompletedTaskCount(), executorService.getActiveCount(), executorService.getQueue().size())});
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private class CompletedWorkChecker
    implements Runnable {
        private int currentTileIndex = 0;

        private CompletedWorkChecker() {
        }

        @Override
        public void run() {
            while (this.currentTileIndex < NewIlluminaBasecallsConverter.this.tiles.size()) {
                Integer currentTile = (Integer)NewIlluminaBasecallsConverter.this.tiles.get(this.currentTileIndex);
                if (NewIlluminaBasecallsConverter.this.completedWork.containsKey(currentTile)) {
                    log.info(new Object[]{"Writing out tile " + currentTile});
                    ((List)NewIlluminaBasecallsConverter.this.completedWork.get(currentTile)).forEach(writer -> ((ThreadPoolExecutorWithExceptions)NewIlluminaBasecallsConverter.this.barcodeWriterThreads.get(writer.getBarcode())).submit((Runnable)writer));
                    ++this.currentTileIndex;
                    continue;
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    throw new PicardException(e.getMessage(), e);
                }
            }
            NewIlluminaBasecallsConverter.this.barcodeRecordWriterMap.forEach((barcode, writer) -> ((ThreadPoolExecutorWithExceptions)NewIlluminaBasecallsConverter.this.barcodeWriterThreads.get(barcode)).submit(new Closer((BasecallsConverter.ConvertedClusterDataWriter)writer, (String)barcode)));
        }
    }

    private class TileProcessor
    implements Runnable {
        private final int tileNum;
        private final Map<String, SortingCollection<CLUSTER_OUTPUT_RECORD>> barcodeToRecordCollection = new HashMap();
        private final File barcodeFile;

        TileProcessor(int tileNum, File barcodeFile) {
            this.tileNum = tileNum;
            this.barcodeFile = barcodeFile;
        }

        @Override
        public void run() {
            NewIlluminaDataProvider dataProvider = NewIlluminaBasecallsConverter.this.factory.makeDataProvider(NewIlluminaBasecallsConverter.this.cbcls, NewIlluminaBasecallsConverter.this.locs, NewIlluminaBasecallsConverter.this.filterFiles, this.tileNum, this.barcodeFile);
            while (dataProvider.hasNext()) {
                ClusterData cluster = (ClusterData)dataProvider.next();
                NewIlluminaBasecallsConverter.this.readProgressLogger.record(null, 0);
                String barcode2 = NewIlluminaBasecallsConverter.this.demultiplex ? cluster.getMatchedBarcode() : null;
                this.addRecord(barcode2, NewIlluminaBasecallsConverter.this.converter.convertClusterToOutputRecord(cluster));
            }
            ((BaseIlluminaDataProvider)dataProvider).close();
            ArrayList writerList = new ArrayList();
            this.barcodeToRecordCollection.forEach((barcode, value) -> {
                value.doneAdding();
                BasecallsConverter.ConvertedClusterDataWriter writer = (BasecallsConverter.ConvertedClusterDataWriter)NewIlluminaBasecallsConverter.this.barcodeRecordWriterMap.get(barcode);
                writerList.add(new RecordWriter(writer, value, (String)barcode));
            });
            NewIlluminaBasecallsConverter.this.completedWork.put(this.tileNum, writerList);
            log.info(new Object[]{"Finished processing tile " + this.tileNum});
        }

        private synchronized void addRecord(String barcode, CLUSTER_OUTPUT_RECORD record) {
            SortingCollection recordCollection = this.barcodeToRecordCollection.get(barcode);
            if (recordCollection == null) {
                if (!NewIlluminaBasecallsConverter.this.barcodeRecordWriterMap.containsKey(barcode)) {
                    if (NewIlluminaBasecallsConverter.this.ignoreUnexpectedBarcodes) {
                        return;
                    }
                    throw new PicardException(String.format("Read records with barcode %s, but this barcode was not expected.  (Is it referenced in the parameters file?)", barcode));
                }
                recordCollection = this.newSortingCollection();
                this.barcodeToRecordCollection.put(barcode, recordCollection);
            }
            recordCollection.add(record);
        }

        private synchronized SortingCollection<CLUSTER_OUTPUT_RECORD> newSortingCollection() {
            int maxRecordsInRam = Math.max(1, NewIlluminaBasecallsConverter.this.maxReadsInRamPerTile / NewIlluminaBasecallsConverter.this.barcodeRecordWriterMap.size());
            return SortingCollection.newInstance((Class)NewIlluminaBasecallsConverter.this.outputRecordClass, (SortingCollection.Codec)NewIlluminaBasecallsConverter.this.codecPrototype.clone(), (Comparator)NewIlluminaBasecallsConverter.this.outputRecordComparator, (int)maxRecordsInRam, (Collection)NewIlluminaBasecallsConverter.this.tmpDirs);
        }
    }

    private class Closer
    implements Runnable {
        private final BasecallsConverter.ConvertedClusterDataWriter<CLUSTER_OUTPUT_RECORD> writer;
        private final String barcode;

        private Closer(BasecallsConverter.ConvertedClusterDataWriter<CLUSTER_OUTPUT_RECORD> writer, String barcode) {
            this.writer = writer;
            this.barcode = barcode;
        }

        @Override
        public void run() {
            log.info(new Object[]{"Closing writer for barcode " + this.barcode});
            this.writer.close();
        }
    }

    private class RecordWriter
    implements Runnable {
        private final SortingCollection<CLUSTER_OUTPUT_RECORD> recordCollection;
        private final BasecallsConverter.ConvertedClusterDataWriter<CLUSTER_OUTPUT_RECORD> writer;
        private final String barcode;

        RecordWriter(BasecallsConverter.ConvertedClusterDataWriter<CLUSTER_OUTPUT_RECORD> writer, SortingCollection<CLUSTER_OUTPUT_RECORD> recordCollection, String barcode) {
            this.writer = writer;
            this.recordCollection = recordCollection;
            this.barcode = barcode;
        }

        @Override
        public void run() {
            for (Object record : this.recordCollection) {
                this.writer.write(record);
                NewIlluminaBasecallsConverter.this.writeProgressLogger.record(null, 0);
            }
        }

        public String getBarcode() {
            return this.barcode;
        }
    }
}

