/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.DownsamplingIterator;
import htsjdk.samtools.DownsamplingIteratorFactory;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import java.text.DecimalFormat;
import java.util.Random;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.analysis.CollectQualityYieldMetrics;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.argumentcollections.ReferenceArgumentCollection;
import picard.cmdline.programgroups.SamOrBam;

@CommandLineProgramProperties(summary="Downsample a SAM or BAM file.  This tool applies a random downsampling algorithm to a SAM or BAM file to retain only a random subset of the reads. Reads in a mate-pair are either both kept or both discarded. Reads marked as not primary alignments are all discarded. Each read is given a probability P of being retained so that runs performed with the exact same input in the same order and with the same value for RANDOM_SEED will produce the same results.All reads for a template are kept or discarded as a unit, with the goal of retaining readsfrom PROBABILITY * input templates. While this will usually result in approximately PROBABILITY * input reads being retained also, for very small PROBABILITIES this may not be the case.\nA number of different downsampling strategies are supported using the STRATEGY option:\n\nConstantMemory: Downsamples a stream or file of SAMRecords using a hash-projection strategy such that it can run in constant memory. The downsampling is stochastic, and therefore the actual retained proportion will vary around the requested proportion. Due to working in fixed memory this strategy is good for large inputs, and due to the stochastic nature the accuracy of this strategy is highest with a high number of output records, and diminishes at low output volumes.\n\nHighAccuracy: Attempts (but does not guarantee) to provide accuracy up to a specified limit. Accuracy is defined as emitting a proportion of reads as close to the requested proportion as possible. In order to do so this strategy requires memory that is proportional to the number of template names in the incoming stream of reads, and will thus require large amounts of memory when running on large input files.\n\nChained: Attempts to provide a compromise strategy that offers some of the advantages of both the ConstantMemory and HighAccuracy strategies. Uses a ConstantMemory strategy to downsample the incoming stream to approximately the desired proportion, and then a HighAccuracy strategy to finish. Works in a single pass, and will provide accuracy close to (but often not as good as) HighAccuracy while requiring memory proportional to the set of reads emitted from the ConstantMemory strategy to the HighAccuracy strategy. Works well when downsampling large inputs to small proportions (e.g. downsampling hundreds of millions of reads and retaining only 2%. Should be accurate 99.9% of the time when the input contains >= 50,000 templates (read names). For smaller inputs, HighAccuracy is recommended instead.\n\n<h4>Usage example:</h4><pre>java -jar picard.jar DownsampleSam \\<br />      I=input.bam \\<br />      O=downsampled.bam</pre><hr />", oneLineSummary="Downsample a SAM or BAM file.  ", programGroup=SamOrBam.class)
@DocumentedFeature
public class DownsampleSam
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Downsample a SAM or BAM file.  ";
    static final String USAGE_DETAILS = "This tool applies a random downsampling algorithm to a SAM or BAM file to retain only a random subset of the reads. Reads in a mate-pair are either both kept or both discarded. Reads marked as not primary alignments are all discarded. Each read is given a probability P of being retained so that runs performed with the exact same input in the same order and with the same value for RANDOM_SEED will produce the same results.All reads for a template are kept or discarded as a unit, with the goal of retaining readsfrom PROBABILITY * input templates. While this will usually result in approximately PROBABILITY * input reads being retained also, for very small PROBABILITIES this may not be the case.\nA number of different downsampling strategies are supported using the STRATEGY option:\n\nConstantMemory: Downsamples a stream or file of SAMRecords using a hash-projection strategy such that it can run in constant memory. The downsampling is stochastic, and therefore the actual retained proportion will vary around the requested proportion. Due to working in fixed memory this strategy is good for large inputs, and due to the stochastic nature the accuracy of this strategy is highest with a high number of output records, and diminishes at low output volumes.\n\nHighAccuracy: Attempts (but does not guarantee) to provide accuracy up to a specified limit. Accuracy is defined as emitting a proportion of reads as close to the requested proportion as possible. In order to do so this strategy requires memory that is proportional to the number of template names in the incoming stream of reads, and will thus require large amounts of memory when running on large input files.\n\nChained: Attempts to provide a compromise strategy that offers some of the advantages of both the ConstantMemory and HighAccuracy strategies. Uses a ConstantMemory strategy to downsample the incoming stream to approximately the desired proportion, and then a HighAccuracy strategy to finish. Works in a single pass, and will provide accuracy close to (but often not as good as) HighAccuracy while requiring memory proportional to the set of reads emitted from the ConstantMemory strategy to the HighAccuracy strategy. Works well when downsampling large inputs to small proportions (e.g. downsampling hundreds of millions of reads and retaining only 2%. Should be accurate 99.9% of the time when the input contains >= 50,000 templates (read names). For smaller inputs, HighAccuracy is recommended instead.\n\n<h4>Usage example:</h4><pre>java -jar picard.jar DownsampleSam \\<br />      I=input.bam \\<br />      O=downsampled.bam</pre><hr />";
    @Argument(shortName="I", doc="The input SAM or BAM file to downsample.")
    public File INPUT;
    @Argument(shortName="O", doc="The output, downsampled, SAM or BAM file to write.")
    public File OUTPUT;
    @Argument(shortName="S", doc="The downsampling strategy to use. See usage for discussion.")
    public DownsamplingIteratorFactory.Strategy STRATEGY = DownsamplingIteratorFactory.Strategy.ConstantMemory;
    @Argument(shortName="R", doc="Random seed to use if deterministic behavior is desired.  Setting to null will cause multiple invocations to produce different results.")
    public Integer RANDOM_SEED = 1;
    @Argument(shortName="P", doc="The probability of keeping any individual read, between 0 and 1.")
    public double PROBABILITY = 1.0;
    @Argument(shortName="A", doc="The accuracy that the downsampler should try to achieve if the selected strategy supports it. Note that accuracy is never guaranteed, but some strategies will attempt to provide accuracy within the requested bounds.Higher accuracy will generally require more memory.")
    public double ACCURACY = 1.0E-4;
    @Argument(shortName="M", doc="The file to write metrics to (QualityYieldMetrics)", optional=true)
    public File METRICS_FILE;
    private final Log log = Log.getInstance(DownsampleSam.class);

    public static void main(String[] args) {
        new DownsampleSam().instanceMainWithExit(args);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        if (this.PROBABILITY == 1.0) {
            this.log.warn(new Object[]{"Running DownsampleSam with PROBABILITY=1! This will likely just recreate the input file."});
        }
        Integer seed = this.RANDOM_SEED == null ? new Random().nextInt() : this.RANDOM_SEED.intValue();
        SamReader in = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(SamInputResource.of((File)this.INPUT));
        SAMFileWriter out = new SAMFileWriterFactory().makeSAMOrBAMWriter(in.getFileHeader(), true, this.OUTPUT);
        ProgressLogger progress = new ProgressLogger(this.log, 10000000, "Wrote");
        DownsamplingIterator iterator = DownsamplingIteratorFactory.make((SamReader)in, (DownsamplingIteratorFactory.Strategy)this.STRATEGY, (double)this.PROBABILITY, (double)this.ACCURACY, (int)seed);
        CollectQualityYieldMetrics.QualityYieldMetricsCollector metricsCollector = new CollectQualityYieldMetrics.QualityYieldMetricsCollector(true, false, false);
        while (iterator.hasNext()) {
            SAMRecord rec = (SAMRecord)iterator.next();
            out.addAlignment(rec);
            if (this.METRICS_FILE != null) {
                metricsCollector.acceptRecord(rec, null);
            }
            progress.record(rec);
        }
        out.close();
        CloserUtil.close((Object)in);
        DecimalFormat fmt = new DecimalFormat("0.00%");
        this.log.info(new Object[]{"Finished downsampling."});
        this.log.info(new Object[]{"Kept ", iterator.getAcceptedCount(), " out of ", iterator.getSeenCount(), " reads (", fmt.format(iterator.getAcceptedFraction()), ")."});
        if (this.METRICS_FILE != null) {
            MetricsFile metricsFile = this.getMetricsFile();
            metricsCollector.finish();
            metricsCollector.addMetricsToFile(metricsFile);
            metricsFile.write(this.METRICS_FILE);
        }
        return 0;
    }

    @Override
    protected ReferenceArgumentCollection makeReferenceArgumentCollection() {
        return new ReferenceArgumentCollection(){
            @Argument(doc="The reference sequence file.", optional=true, common=false)
            public File REFERENCE_SEQUENCE;

            @Override
            public File getReferenceFile() {
                return this.REFERENCE_SEQUENCE;
            }
        };
    }
}

