/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.filter.AlignedFilter;
import htsjdk.samtools.filter.FilteringSamIterator;
import htsjdk.samtools.filter.IntervalKeepPairFilter;
import htsjdk.samtools.filter.JavascriptSamRecordFilter;
import htsjdk.samtools.filter.ReadNameFilter;
import htsjdk.samtools.filter.SamRecordFilter;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.SamOrBam;

@CommandLineProgramProperties(summary="Subset read data from a SAM or BAM fileThis tool takes a SAM or BAM file and subsets it to a new file that either excludes or only includes either aligned or unaligned reads (set using FILTER), or specific reads based on a list of reads names supplied in the READ_LIST_FILE.  <h4>Usage example:</h4><pre>java -jar picard.jar FilterSamReads \\<br />       I=input.bam \\ <br />       O=output.bam \\<br />       READ_LIST_FILE=read_names.txt      FILTER=filter_value</pre> For information on the SAM format, please see: http://samtools.sourceforge.net<hr />", oneLineSummary="Subset read data from a SAM or BAM file", programGroup=SamOrBam.class)
@DocumentedFeature
public class FilterSamReads
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Subset read data from a SAM or BAM file";
    static final String USAGE_DETAILS = "This tool takes a SAM or BAM file and subsets it to a new file that either excludes or only includes either aligned or unaligned reads (set using FILTER), or specific reads based on a list of reads names supplied in the READ_LIST_FILE.  <h4>Usage example:</h4><pre>java -jar picard.jar FilterSamReads \\<br />       I=input.bam \\ <br />       O=output.bam \\<br />       READ_LIST_FILE=read_names.txt      FILTER=filter_value</pre> For information on the SAM format, please see: http://samtools.sourceforge.net<hr />";
    private static final Log log = Log.getInstance(FilterSamReads.class);
    @Argument(doc="The SAM or BAM file that will be filtered.", optional=false, shortName="I")
    public File INPUT;
    @Argument(doc="Filter.", optional=false)
    public Filter FILTER = null;
    @Argument(doc="Read List File containing reads that will be included or excluded from the OUTPUT SAM or BAM file.", optional=true, shortName="RLF")
    public File READ_LIST_FILE;
    @Argument(doc="Interval List File containing intervals that will be included or excluded from the OUTPUT SAM or BAM file.", optional=true, shortName="IL")
    public File INTERVAL_LIST;
    @Argument(doc="SortOrder of the OUTPUT SAM or BAM file, otherwise use the SortOrder of the INPUT file.", optional=true, shortName="SO")
    public SAMFileHeader.SortOrder SORT_ORDER;
    @Argument(doc="Create .reads files (for debugging purposes)", optional=true)
    public boolean WRITE_READS_FILES = true;
    @Argument(doc="SAM or BAM file to write read excluded results to", optional=false, shortName="O")
    public File OUTPUT;
    @Argument(shortName="JS", doc="Filters a SAM or BAM file with a javascript expression using the java javascript-engine.  The script puts the following variables in the script context:  'record' a SamRecord ( https://samtools.github.io/htsjdk/javadoc/htsjdk/htsjdk/samtools/SAMRecord.html ) and  'header' a SAMFileHeader ( https://samtools.github.io/htsjdk/javadoc/htsjdk/htsjdk/samtools/SAMFileHeader.html ). Last value of the script should be a boolean to tell wether we should accept or reject the record.", optional=true)
    public File JAVASCRIPT_FILE = null;

    private void filterReads(FilteringSamIterator filteringIterator) {
        SAMFileHeader fileHeader = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).getFileHeader(this.INPUT);
        SAMFileHeader.SortOrder inputSortOrder = fileHeader.getSortOrder();
        if (this.SORT_ORDER != null) {
            fileHeader.setSortOrder(this.SORT_ORDER);
        }
        if (this.FILTER == Filter.includePairedIntervals && fileHeader.getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
            throw new UnsupportedOperationException("Input must be coordinate sorted to use includePairedIntervals");
        }
        boolean presorted = inputSortOrder.equals((Object)fileHeader.getSortOrder());
        log.info(new Object[]{"Filtering [presorted=" + presorted + "] " + this.INPUT.getName() + " -> OUTPUT=" + this.OUTPUT.getName() + " [sortorder=" + fileHeader.getSortOrder().name() + "]"});
        SAMFileWriter outputWriter = new SAMFileWriterFactory().makeSAMOrBAMWriter(fileHeader, presorted, this.OUTPUT);
        ProgressLogger progress = new ProgressLogger(log, 1000000, "Written");
        while (filteringIterator.hasNext()) {
            SAMRecord rec = filteringIterator.next();
            outputWriter.addAlignment(rec);
            progress.record(rec);
        }
        filteringIterator.close();
        outputWriter.close();
        log.info(new Object[]{new DecimalFormat("#,###").format(progress.getCount()) + " SAMRecords written to " + this.OUTPUT.getName()});
    }

    private void writeReadsFile(File samOrBamFile) throws IOException {
        SamReader reader = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(samOrBamFile);
        File readsFile = new File(this.OUTPUT.getParentFile(), IOUtil.basename((File)samOrBamFile) + ".reads");
        IOUtil.assertFileIsWritable((File)readsFile);
        BufferedWriter bw = IOUtil.openFileForBufferedWriting((File)readsFile, (boolean)false);
        for (SAMRecord rec : reader) {
            bw.write(rec.toString() + "\n");
        }
        bw.close();
        reader.close();
        IOUtil.assertFileIsReadable((File)readsFile);
    }

    private List<Interval> getIntervalList(File intervalFile) throws IOException {
        IOUtil.assertFileIsReadable((File)intervalFile);
        return IntervalList.fromFile((File)intervalFile).getIntervals();
    }

    @Override
    protected int doWork() {
        try {
            FilteringSamIterator filteringIterator;
            IOUtil.assertFileIsReadable((File)this.INPUT);
            IOUtil.assertFileIsWritable((File)this.OUTPUT);
            if (this.WRITE_READS_FILES) {
                this.writeReadsFile(this.INPUT);
            }
            List<Object> intervalList = new ArrayList();
            if (this.INTERVAL_LIST != null) {
                intervalList = this.getIntervalList(this.INTERVAL_LIST);
            }
            SamReader samReader = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(this.INPUT);
            switch (this.FILTER) {
                case includeAligned: {
                    filteringIterator = new FilteringSamIterator((Iterator)samReader.iterator(), (SamRecordFilter)new AlignedFilter(true), true);
                    break;
                }
                case excludeAligned: {
                    filteringIterator = new FilteringSamIterator((Iterator)samReader.iterator(), (SamRecordFilter)new AlignedFilter(false), true);
                    break;
                }
                case includeReadList: {
                    filteringIterator = new FilteringSamIterator((Iterator)samReader.iterator(), (SamRecordFilter)new ReadNameFilter(this.READ_LIST_FILE, true));
                    break;
                }
                case excludeReadList: {
                    filteringIterator = new FilteringSamIterator((Iterator)samReader.iterator(), (SamRecordFilter)new ReadNameFilter(this.READ_LIST_FILE, false));
                    break;
                }
                case includeJavascript: {
                    filteringIterator = new FilteringSamIterator((Iterator)samReader.iterator(), (SamRecordFilter)new JavascriptSamRecordFilter(this.JAVASCRIPT_FILE, samReader.getFileHeader()));
                    break;
                }
                case includePairedIntervals: {
                    filteringIterator = new FilteringSamIterator((Iterator)samReader.iterator(), (SamRecordFilter)new IntervalKeepPairFilter(intervalList), false);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this.FILTER.name() + " has not been implemented!");
                }
            }
            this.filterReads(filteringIterator);
            IOUtil.assertFileIsReadable((File)this.OUTPUT);
            if (this.WRITE_READS_FILES) {
                this.writeReadsFile(this.OUTPUT);
            }
            return 0;
        }
        catch (Exception e) {
            if (this.OUTPUT.exists() && !this.OUTPUT.delete()) {
                log.warn(new Object[]{"Failed to delete " + this.OUTPUT.getAbsolutePath()});
            }
            log.error((Throwable)e, new Object[]{"Failed to filter " + this.INPUT.getName()});
            return 1;
        }
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.INPUT.equals(this.OUTPUT)) {
            return new String[]{"INPUT file and OUTPUT file must differ!"};
        }
        if ((this.FILTER.equals((Object)Filter.includeReadList) || this.FILTER.equals((Object)Filter.excludeReadList)) && this.READ_LIST_FILE == null) {
            return new String[]{"A READ_LIST_FILE must be specified when using the " + this.FILTER.name() + " option"};
        }
        if (this.FILTER.equals((Object)Filter.includePairedIntervals) && this.INTERVAL_LIST == null) {
            return new String[]{"A INTERVAL_LIST must be specified when using the " + this.FILTER.name() + " option"};
        }
        return super.customCommandLineValidation();
    }

    public static void main(String[] args) {
        System.exit(new FilterSamReads().instanceMain(args));
    }

    protected static enum Filter {
        includeAligned("OUTPUT SAM/BAM will contain aligned reads only. INPUT SAM/BAM must be in queryname SortOrder. (Note that *both* first and second of paired reads must be aligned to be included in the OUTPUT SAM or BAM)"),
        excludeAligned("OUTPUT SAM/BAM will contain un-mapped reads only. INPUT SAM/BAM must be in queryname SortOrder. (Note that *both* first and second of pair must be aligned to be excluded from the OUTPUT SAM or BAM)"),
        includeReadList("OUTPUT SAM/BAM will contain reads that are supplied in the READ_LIST_FILE file"),
        excludeReadList("OUTPUT bam will contain reads that are *not* supplied in the READ_LIST_FILE file"),
        includeJavascript("OUTPUT bam will contain reads that hava been accepted by the JAVASCRIPT_FILE script."),
        includePairedIntervals("OUTPUT SAM/BAM will contain any reads (and their mate) that overlap with an interval. INPUT SAM/BAM and INTERVAL_LIST must be in coordinate SortOrder. Only aligned reads will be output.");

        private final String description;

        private Filter(String description) {
            this.description = description;
        }

        public String toString() {
            return this.name() + " [" + this.description + "]";
        }
    }
}

