/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates.util;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.util.SamRecordWithOrdinal;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import picard.PicardException;
import picard.sam.markduplicates.util.OpticalDuplicateFinder;
import picard.sam.markduplicates.util.PhysicalLocationForMateCigarSet;
import picard.sam.markduplicates.util.ReadEnds;

public class ReadEndsForMateCigar
extends ReadEnds {
    byte hasUnmapped = 0;
    public SamRecordWithOrdinal samRecordWithOrdinal = null;
    private PhysicalLocationForMateCigarSet locationSet = null;

    public ReadEndsForMateCigar(SAMFileHeader header, SamRecordWithOrdinal samRecordWithOrdinal, OpticalDuplicateFinder opticalDuplicateFinder, short libraryId) {
        this.readGroup = (short)-1;
        this.tile = (short)-1;
        this.y = -1;
        this.x = -1;
        this.read2Coordinate = -1;
        this.read2ReferenceIndex = -1;
        this.hasUnmapped = 0;
        this.samRecordWithOrdinal = samRecordWithOrdinal;
        SAMRecord record = this.samRecordWithOrdinal.getRecord();
        this.read1ReferenceIndex = record.getReferenceIndex();
        int n = this.read1Coordinate = record.getReadNegativeStrandFlag() ? record.getUnclippedEnd() : record.getUnclippedStart();
        if (record.getReadUnmappedFlag()) {
            throw new PicardException("Found an unexpected unmapped read");
        }
        if (record.getReadPairedFlag() && !record.getReadUnmappedFlag() && !record.getMateUnmappedFlag()) {
            this.read2ReferenceIndex = record.getMateReferenceIndex();
            this.read2Coordinate = record.getMateNegativeStrandFlag() ? SAMUtils.getMateUnclippedEnd((SAMRecord)record) : SAMUtils.getMateUnclippedStart((SAMRecord)record);
            this.orientation = ReadEnds.getOrientationByte(record.getReadNegativeStrandFlag(), record.getMateNegativeStrandFlag());
            if (record.getReadPairedFlag()) {
                this.orientationForOpticalDuplicates = record.getFirstOfPairFlag() ? ReadEnds.getOrientationByte(record.getReadNegativeStrandFlag(), record.getMateNegativeStrandFlag()) : ReadEnds.getOrientationByte(record.getMateNegativeStrandFlag(), record.getReadNegativeStrandFlag());
            }
        } else {
            this.orientation = record.getReadNegativeStrandFlag() ? (byte)1 : 0;
        }
        this.libraryId = libraryId;
        if (record.getReadUnmappedFlag() || record.getReadPairedFlag() && record.getMateUnmappedFlag()) {
            this.hasUnmapped = 1;
        }
        if (opticalDuplicateFinder.addLocationInformation(record.getReadName(), this)) {
            this.readGroup = 0;
            String rg = (String)record.getAttribute("RG");
            List readGroups = header.getReadGroups();
            if (rg != null && readGroups != null) {
                SAMReadGroupRecord readGroup;
                Iterator iterator = readGroups.iterator();
                while (iterator.hasNext() && !(readGroup = (SAMReadGroupRecord)iterator.next()).getReadGroupId().equals(rg)) {
                    this.readGroup = (short)(this.readGroup + 1);
                }
            }
        }
    }

    public ReadEndsForMateCigar(ReadEndsForMateCigar other, SamRecordWithOrdinal samRecordWithOrdinal) {
        this.readGroup = other.readGroup;
        this.tile = other.tile;
        this.x = other.x;
        this.y = other.y;
        this.read1ReferenceIndex = other.read1ReferenceIndex;
        this.read1Coordinate = other.read1Coordinate;
        this.read2ReferenceIndex = other.read2ReferenceIndex;
        this.read2Coordinate = other.read2Coordinate;
        this.hasUnmapped = other.hasUnmapped;
        this.samRecordWithOrdinal = samRecordWithOrdinal;
        this.orientation = other.orientation;
        this.libraryId = other.libraryId;
    }

    public SamRecordWithOrdinal getSamRecordIndex() {
        return this.samRecordWithOrdinal;
    }

    public SAMRecord getRecord() {
        return this.samRecordWithOrdinal.getRecord();
    }

    public String getRecordReadName() {
        return this.samRecordWithOrdinal.getRecord().getReadName();
    }

    @Override
    public boolean isPaired() {
        return this.getRecord().getReadPairedFlag();
    }

    public Set<ReadEnds> getReadEndSetForOpticalDuplicates() {
        if (null == this.locationSet) {
            throw new PicardException("Already called getReadEndSetForOpticalDuplicates");
        }
        Set<ReadEnds> locationSet = this.locationSet.getReadEnds();
        this.locationSet = null;
        return locationSet;
    }

    public PhysicalLocationForMateCigarSet getLocationSet() {
        return this.locationSet;
    }

    public PhysicalLocationForMateCigarSet removeLocationSet() {
        PhysicalLocationForMateCigarSet locationSet = this.locationSet;
        this.locationSet = null;
        return locationSet;
    }

    public void setLocationSet(PhysicalLocationForMateCigarSet locationSet) {
        this.locationSet = locationSet;
    }
}

