/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.util.BufferedLineReader;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import picard.PicardException;
import picard.util.AbstractInputParser;

public class BasicInputParser
extends AbstractInputParser {
    private BufferedLineReader reader;
    private final ArrayList<InputStream> inputs = new ArrayList();
    private final ArrayList<String> fileNames = new ArrayList();
    String currentFileName = null;
    private String currentLine = null;
    private String nextLine = null;
    private int currentLineNumber = 0;
    private int nextLineNumber = 0;

    public BasicInputParser(boolean treatGroupedDelimitersAsOne, InputStream ... inputStreams) {
        if (inputStreams.length == 0) {
            throw new IllegalArgumentException("At least one input must be specified.");
        }
        this.inputs.addAll(Arrays.asList(inputStreams));
        this.reader = new BufferedLineReader(this.inputs.remove(0));
        this.setTreatGroupedDelimitersAsOne(treatGroupedDelimitersAsOne);
    }

    public BasicInputParser(boolean treatGroupedDelimitersAsOne, int wordCount, InputStream ... inputStreams) {
        this(treatGroupedDelimitersAsOne, inputStreams);
        this.setWordCount(wordCount);
    }

    public BasicInputParser(boolean treatGroupedDelimitersAsOne, File ... files) {
        this(treatGroupedDelimitersAsOne, BasicInputParser.filesToInputStreams(files));
        for (File f : files) {
            this.fileNames.add(f.getAbsolutePath());
        }
        this.currentFileName = this.fileNames.remove(0);
    }

    public BasicInputParser(boolean treatGroupedDelimitersAsOne, int wordCount, File ... files) {
        this(treatGroupedDelimitersAsOne, files);
        this.setWordCount(wordCount);
    }

    @Override
    protected byte[] readNextLine() {
        try {
            String line = this.reader.readLine();
            if (this.nextLine != null && !this.isComment(this.nextLine.getBytes())) {
                this.currentLineNumber = this.nextLineNumber;
                this.currentLine = this.nextLine;
            }
            if (line != null) {
                ++this.nextLineNumber;
                this.nextLine = line;
                return line.getBytes();
            }
            if (!this.inputs.isEmpty()) {
                this.advanceFile();
                return this.readNextLine();
            }
            return null;
        }
        catch (RuntimeIOException ioe) {
            throw new PicardException("Error reading from file " + this.currentFileName, ioe);
        }
    }

    protected void advanceFile() {
        this.currentFileName = !this.fileNames.isEmpty() ? this.fileNames.remove(0) : null;
        this.nextLineNumber = 0;
        this.nextLine = null;
        this.reader = new BufferedLineReader(this.inputs.remove(0));
    }

    @Override
    public void close() {
        if (this.reader != null) {
            this.reader.close();
        }
        for (InputStream stream : this.inputs) {
            CloserUtil.close((Object)stream);
        }
    }

    @Override
    public String getFileName() {
        return this.currentFileName != null ? this.currentFileName : "(file name unavailable)";
    }

    public String getCurrentLine() {
        return this.currentLine;
    }

    public int getCurrentLineNumber() {
        return this.currentLineNumber;
    }

    private static InputStream[] filesToInputStreams(File[] files) {
        InputStream[] result = new InputStream[files.length];
        for (int i = 0; i < files.length; ++i) {
            result[i] = IOUtil.openFileForReading((File)files[i]);
        }
        return result;
    }
}

