/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class LiftoverUtils {
    public static VariantContext liftVariant(VariantContext source, Interval target, ReferenceSequence refSeq, boolean writeOriginalPosition) {
        if (target == null) {
            return null;
        }
        VariantContextBuilder builder = target.isNegativeStrand() ? LiftoverUtils.reverseComplementVariantContext(source, target, refSeq) : LiftoverUtils.liftSimpleVariantContext(source, target);
        if (builder == null) {
            return null;
        }
        builder.filters(source.getFilters());
        builder.log10PError(source.getLog10PError());
        builder.attributes(source.getAttributes());
        builder.id(source.getID());
        if (writeOriginalPosition) {
            builder.attribute("OriginalContig", (Object)source.getContig());
            builder.attribute("OriginalStart", (Object)source.getStart());
        }
        return builder.make();
    }

    protected static VariantContextBuilder liftSimpleVariantContext(VariantContext source, Interval target) {
        if (target == null || source.getReference().length() != target.length()) {
            return null;
        }
        VariantContextBuilder builder = new VariantContextBuilder(source);
        builder.chr(target.getContig());
        builder.start((long)target.getStart());
        builder.stop((long)target.getEnd());
        return builder;
    }

    protected static VariantContextBuilder reverseComplementVariantContext(VariantContext source, Interval target, ReferenceSequence refSeq) {
        if (target.isPositiveStrand()) {
            throw new IllegalArgumentException("This should only be called for negative strand liftovers");
        }
        if (source.isIndel() && !source.isBiallelic()) {
            return null;
        }
        ArrayList<Allele> origAlleles = new ArrayList<Allele>(source.getAlleles());
        VariantContextBuilder vcb = new VariantContextBuilder(source);
        vcb.chr(target.getContig());
        boolean addToStart = source.isIndel() && target.getStart() > 1;
        int start = target.getStart() - (addToStart ? 1 : 0);
        vcb.start((long)start);
        int stop = target.getEnd() - (addToStart ? 1 : 0);
        vcb.stop((long)stop);
        vcb.alleles(LiftoverUtils.reverseComplementAlleles(origAlleles, target, refSeq, source.isIndel(), addToStart));
        if (source.isIndel()) {
            LiftoverUtils.leftAlignVariant(vcb, start, stop, vcb.getAlleles(), refSeq);
        }
        vcb.genotypes(LiftoverUtils.fixGenotypes(source.getGenotypes(), origAlleles, vcb.getAlleles()));
        return vcb;
    }

    private static List<Allele> reverseComplementAlleles(List<Allele> originalAlleles, Interval target, ReferenceSequence refSeq, boolean isBiAllelicIndel, boolean addToStart) {
        ArrayList<Allele> alleles = new ArrayList<Allele>();
        for (Allele oldAllele : originalAlleles) {
            alleles.add(LiftoverUtils.reverseComplement(oldAllele, target, refSeq, isBiAllelicIndel, addToStart));
        }
        return alleles;
    }

    private static Allele reverseComplement(Allele oldAllele, Interval target, ReferenceSequence referenceSequence, boolean isBiAllelicIndel, boolean addToStart) {
        if (oldAllele.isSymbolic() || oldAllele.isNoCall()) {
            return oldAllele;
        }
        if (isBiAllelicIndel) {
            StringBuilder alleleBuilder = new StringBuilder(target.getEnd() - target.getStart() + 1);
            if (addToStart) {
                alleleBuilder.append((char)referenceSequence.getBases()[target.getStart() - 2]);
            }
            alleleBuilder.append(SequenceUtil.reverseComplement((String)oldAllele.getBaseString().substring(1, oldAllele.length())));
            if (!addToStart) {
                alleleBuilder.append((char)referenceSequence.getBases()[target.getEnd() - 1]);
            }
            return Allele.create((String)alleleBuilder.toString(), (boolean)oldAllele.isReference());
        }
        return Allele.create((String)SequenceUtil.reverseComplement((String)oldAllele.getBaseString()), (boolean)oldAllele.isReference());
    }

    protected static GenotypesContext fixGenotypes(GenotypesContext originals, List<Allele> originalAlleles, List<Allele> newAlleles) {
        if (originalAlleles.equals(newAlleles)) {
            return originals;
        }
        if (originalAlleles.size() != newAlleles.size()) {
            throw new IllegalStateException("Error in allele lists: the original and new allele lists are not the same length: " + originalAlleles.toString() + " / " + newAlleles.toString());
        }
        HashMap<Allele, Allele> alleleMap = new HashMap<Allele, Allele>();
        for (int idx = 0; idx < originalAlleles.size(); ++idx) {
            alleleMap.put(originalAlleles.get(idx), newAlleles.get(idx));
        }
        GenotypesContext fixedGenotypes = GenotypesContext.create((int)originals.size());
        for (Genotype genotype : originals) {
            ArrayList<Allele> fixedAlleles = new ArrayList<Allele>();
            for (Allele allele : genotype.getAlleles()) {
                if (allele.isNoCall()) {
                    fixedAlleles.add(allele);
                    continue;
                }
                Allele newAllele = (Allele)alleleMap.get(allele);
                if (newAllele == null) {
                    throw new IllegalStateException("Allele not found: " + allele.toString() + ", " + originalAlleles + "/ " + newAlleles);
                }
                fixedAlleles.add(newAllele);
            }
            fixedGenotypes.add(new GenotypeBuilder(genotype).alleles(fixedAlleles).make());
        }
        return fixedGenotypes;
    }

    protected static void leftAlignVariant(VariantContextBuilder builder, int start, int end, List<Allele> alleles, ReferenceSequence referenceSequence) {
        boolean changesInAlleles = true;
        HashMap<Allele, byte[]> alleleBasesMap = new HashMap<Allele, byte[]>();
        alleles.forEach(a -> alleleBasesMap.put((Allele)a, a.getBases()));
        int theStart = start;
        int theEnd = end;
        while (changesInAlleles) {
            changesInAlleles = false;
            if (alleleBasesMap.values().stream().collect(Collectors.groupingBy(a -> a[((byte[])a).length - 1], Collectors.toSet())).size() == 1 && theEnd > 1) {
                for (Allele allele : alleleBasesMap.keySet()) {
                    alleleBasesMap.put(allele, LiftoverUtils.truncateBase((byte[])alleleBasesMap.get(allele), true));
                }
                changesInAlleles = true;
                --theEnd;
            }
            if (!alleleBasesMap.values().stream().map(a -> ((byte[])a).length).anyMatch(l -> l == 0)) continue;
            for (Allele allele : alleleBasesMap.keySet()) {
                byte extraBase = theStart > 1 ? referenceSequence.getBases()[theStart - 2] : referenceSequence.getBases()[theEnd];
                alleleBasesMap.put(allele, LiftoverUtils.extendOneBase((byte[])alleleBasesMap.get(allele), extraBase));
            }
            changesInAlleles = true;
            --theStart;
        }
        while (alleleBasesMap.values().stream().allMatch(a -> ((byte[])a).length >= 2) && alleleBasesMap.values().stream().collect(Collectors.groupingBy(a -> a[0], Collectors.toSet())).size() == 1) {
            for (Allele allele : alleleBasesMap.keySet()) {
                alleleBasesMap.put(allele, LiftoverUtils.truncateBase((byte[])alleleBasesMap.get(allele), false));
            }
            ++theStart;
        }
        builder.start((long)theStart);
        builder.stop((long)theEnd);
        Map<Allele, Allele> fixedAlleleMap = alleleBasesMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, me -> Allele.create((byte[])((byte[])me.getValue()), (boolean)((Allele)me.getKey()).isReference())));
        List fixedAlleles = alleles.stream().map(a -> (Allele)fixedAlleleMap.get(a)).collect(Collectors.toList());
        builder.alleles(fixedAlleles);
    }

    private static byte[] truncateBase(byte[] allele, boolean truncateRightmost) {
        return Arrays.copyOfRange(allele, truncateRightmost ? 0 : 1, truncateRightmost ? allele.length - 1 : allele.length);
    }

    private static byte[] extendOneBase(byte[] bases, byte base) {
        byte[] newBases = new byte[bases.length + 1];
        System.arraycopy(bases, 0, newBases, 1, bases.length);
        newBases[0] = base;
        return newBases;
    }
}

