/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.PeekableIterator;

public class QuerySortedReadPairIteratorUtil {
    public static ReadPair getNextReadPair(PeekableIterator<SAMRecord> iterator) {
        ReadPair readPair = new ReadPair();
        readPair.read1 = QuerySortedReadPairIteratorUtil.getNextUsableRead(iterator, false);
        if (readPair.read1 == null) {
            return null;
        }
        SAMRecord peekedNextRead = QuerySortedReadPairIteratorUtil.getNextUsableRead(iterator, true);
        if (peekedNextRead != null && peekedNextRead.getReadName().equals(readPair.read1.getReadName())) {
            readPair.read2 = QuerySortedReadPairIteratorUtil.getNextUsableRead(iterator, false);
        }
        return readPair;
    }

    private static SAMRecord getNextUsableRead(PeekableIterator<SAMRecord> iterator, boolean justPeek) {
        while (iterator.hasNext()) {
            SAMRecord nextRead = (SAMRecord)iterator.peek();
            if (nextRead.getReadFailsVendorQualityCheckFlag() || nextRead.isSecondaryOrSupplementary()) {
                iterator.next();
                continue;
            }
            return justPeek ? nextRead : (SAMRecord)iterator.next();
        }
        return null;
    }

    public static class ReadPair {
        public SAMRecord read1 = null;
        public SAMRecord read2 = null;
    }
}

