/*
 * Decompiled with CFR 0.152.
 */
package picard.util.help;

import java.util.HashMap;
import java.util.Map;

public final class HelpConstants {
    public static final String DOC_CAT_FASTA = "Fasta File Tools";
    public static final String DOC_CAT_FASTA_SUMMARY = "Tools for analysis and manipulation of files in fasta format";
    public static final String DOC_CAT_INTERVALS = "Interval Tools";
    public static final String DOC_CAT_INTERVALS_SUMMARY = "Tools for processing intervals and associated overlapping records";
    public static final String DOC_CAT_READS = "SAM/BAM/CRAM Tools";
    public static final String DOC_CAT_READS_SUMMARY = "Tools for manipulating read-level data (SAM/BAM/CRAM)";
    public static final String DOC_CAT_VARIANT = "VCF Tools";
    public static final String DOC_CAT_VARIANT_SUMMARY = "Tools for manipulating variants and associated metadata";
    public static final String DOC_CAT_TEST = "Test Tools";
    public static final String DOC_CAT_TEST_SUMMARY = "Tools for internal test purposes";
    public static final String DOC_SUPERCAT_TOOLS = "tools";
    public static final String DOC_SUPERCAT_UTILITIES = "utilities";
    public static final String DOC_SUPERCAT_EXCLUDE = "exclude";
    private static Map<String, String> groupToSuperCategory;

    private HelpConstants() {
    }

    public static Map<String, String> getSuperCategoryMap() {
        if (groupToSuperCategory == null) {
            groupToSuperCategory = new HashMap<String, String>();
            groupToSuperCategory.put(DOC_CAT_FASTA, DOC_SUPERCAT_TOOLS);
            groupToSuperCategory.put(DOC_CAT_READS, DOC_SUPERCAT_TOOLS);
            groupToSuperCategory.put(DOC_CAT_VARIANT, DOC_SUPERCAT_TOOLS);
            groupToSuperCategory.put(DOC_CAT_TEST, DOC_SUPERCAT_EXCLUDE);
        }
        return groupToSuperCategory;
    }

    public static String getSuperCategoryProperty(String groupName) {
        return HelpConstants.getSuperCategoryMap().getOrDefault(groupName, "other");
    }
}

