/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import java.util.ArrayList;
import java.util.Arrays;

public class CounterManager {
    private final int arrayLength;
    private final int readLength;
    private int offset = 0;
    private final ArrayList<Counter> arrays = new ArrayList(2);

    public CounterManager(int arrayLength, int readLength) {
        this.arrayLength = arrayLength;
        this.readLength = readLength;
    }

    int getOffset() {
        return this.offset;
    }

    void setOffset(int offset) {
        this.offset = offset;
    }

    public void checkOutOfBounds(int locusPosition) {
        if (locusPosition - this.offset + this.readLength >= this.arrayLength) {
            if (locusPosition - this.offset < this.arrayLength) {
                this.rebase(locusPosition);
            } else {
                this.clear();
                this.offset = locusPosition;
            }
        }
    }

    private void rebase(int locusPosition) {
        if (locusPosition < this.offset) {
            throw new IllegalArgumentException("Position in the reference sequence is lesser than offset.");
        }
        for (Counter counter : this.arrays) {
            int[] array = counter.array;
            int skipLength = locusPosition - this.offset;
            System.arraycopy(array, skipLength, array, 0, this.arrayLength - skipLength);
            Arrays.fill(array, this.arrayLength - skipLength, this.arrayLength, 0);
        }
        this.offset = locusPosition;
    }

    public void clear() {
        for (Counter counter : this.arrays) {
            int[] array = counter.array;
            Arrays.fill(array, 0);
        }
        this.offset = 0;
    }

    public Counter newCounter() {
        Counter counter = new Counter(this.arrayLength);
        this.arrays.add(counter);
        return counter;
    }

    public class Counter {
        private final int[] array;

        private Counter(int arrayLength) {
            this.array = new int[arrayLength];
        }

        public void increment(int index) {
            this.checkIndex(index);
            int n = index - CounterManager.this.offset;
            this.array[n] = this.array[n] + 1;
        }

        public int get(int index) {
            this.checkIndex(index);
            return this.array[index - CounterManager.this.offset];
        }

        private void checkIndex(int index) {
            if (index - CounterManager.this.offset < 0 || index - CounterManager.this.offset >= this.array.length) {
                throw new ArrayIndexOutOfBoundsException("The requested index " + index + " is out of counter bounds. " + "Possible cause of exception can be wrong READ_LENGTH parameter (much smaller than actual read length)");
            }
        }
    }
}

