/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.artifacts;

import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.SequenceUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.analysis.CollectOxoGMetrics;
import picard.analysis.artifacts.SequencingArtifactMetrics;
import picard.analysis.artifacts.Transition;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;

@CommandLineProgramProperties(summary="Extract OxoG metrics from generalized artifacts metrics.  <p>This tool extracts 8-oxoguanine (OxoG) artifact metrics from the output of CollectSequencingArtifactsMetrics (a tool that provides detailed information on a variety of artifacts found in sequencing libraries) and converts them to the CollectOxoGMetrics tool's output format. This conveniently eliminates the need to run CollectOxoGMetrics if we already ran CollectSequencingArtifactsMetrics in our pipeline. See the documentation for <a href='http://broadinstitute.github.io/picard/command-line-overview.html#CollectSequencingArtifactsMetrics'>CollectSequencingArtifactsMetrics</a> and <a href='http://broadinstitute.github.io/picard/command-line-overview.html#CollectOxoGMetrics'>CollectOxoGMetrics</a> for additional information on these tools.</p>.<p>Note that only the base of the CollectSequencingArtifactsMetrics output file name is required for the (INPUT_BASE) parameter. For example, if the file name is artifact_metrics.txt.bait_bias_detail_metrics or artifact_metrics.txt.pre_adapter_detail_metrics, only the file name base 'artifact_metrics' is required on the command line for this parameter.  An output file called 'artifact_metrics.oxog_metrics' will be generated automatically.  Finally, to run this tool successfully, the REFERENCE_SEQUENCE must be provided.</p><h4>Usage example:</h4><pre>java -jar picard.jar ConvertSequencingArtifactToOxoG \\<br />     I=artifact_metrics \\<br />     R=reference.fasta</pre>Please see the metrics definitions page at <a href='http://broadinstitute.github.io/picard/picard-metric-definitions.html#CollectOxoGMetrics.CpcgMetrics'>ConvertSequencingArtifactToOxoG</a> for detailed descriptions of the output metrics produced by this tool.<hr />", oneLineSummary="Extract OxoG metrics from generalized artifacts metrics.  ", programGroup=DiagnosticsAndQCProgramGroup.class)
@DocumentedFeature
public class ConvertSequencingArtifactToOxoG
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Extract OxoG metrics from generalized artifacts metrics.  ";
    static final String USAGE_DETAILS = "<p>This tool extracts 8-oxoguanine (OxoG) artifact metrics from the output of CollectSequencingArtifactsMetrics (a tool that provides detailed information on a variety of artifacts found in sequencing libraries) and converts them to the CollectOxoGMetrics tool's output format. This conveniently eliminates the need to run CollectOxoGMetrics if we already ran CollectSequencingArtifactsMetrics in our pipeline. See the documentation for <a href='http://broadinstitute.github.io/picard/command-line-overview.html#CollectSequencingArtifactsMetrics'>CollectSequencingArtifactsMetrics</a> and <a href='http://broadinstitute.github.io/picard/command-line-overview.html#CollectOxoGMetrics'>CollectOxoGMetrics</a> for additional information on these tools.</p>.<p>Note that only the base of the CollectSequencingArtifactsMetrics output file name is required for the (INPUT_BASE) parameter. For example, if the file name is artifact_metrics.txt.bait_bias_detail_metrics or artifact_metrics.txt.pre_adapter_detail_metrics, only the file name base 'artifact_metrics' is required on the command line for this parameter.  An output file called 'artifact_metrics.oxog_metrics' will be generated automatically.  Finally, to run this tool successfully, the REFERENCE_SEQUENCE must be provided.</p><h4>Usage example:</h4><pre>java -jar picard.jar ConvertSequencingArtifactToOxoG \\<br />     I=artifact_metrics \\<br />     R=reference.fasta</pre>Please see the metrics definitions page at <a href='http://broadinstitute.github.io/picard/picard-metric-definitions.html#CollectOxoGMetrics.CpcgMetrics'>ConvertSequencingArtifactToOxoG</a> for detailed descriptions of the output metrics produced by this tool.<hr />";
    @Argument(shortName="I", doc="Basename of the input artifact metrics file (output by CollectSequencingArtifactMetrics)")
    public File INPUT_BASE;
    @Argument(shortName="O", doc="Basename for output OxoG metrics. Defaults to same basename as input metrics", optional=true)
    public File OUTPUT_BASE;

    @Override
    protected int doWork() {
        Transition transition;
        if (this.OUTPUT_BASE == null) {
            this.OUTPUT_BASE = this.INPUT_BASE;
        }
        File PRE_ADAPTER_IN = new File(this.INPUT_BASE + ".pre_adapter_detail_metrics");
        File BAIT_BIAS_IN = new File(this.INPUT_BASE + ".bait_bias_detail_metrics");
        File OXOG_OUT = new File(this.OUTPUT_BASE + ".oxog_metrics");
        IOUtil.assertFileIsReadable((File)PRE_ADAPTER_IN);
        IOUtil.assertFileIsReadable((File)BAIT_BIAS_IN);
        IOUtil.assertFileIsWritable((File)OXOG_OUT);
        List preAdapterDetailMetricsList = MetricsFile.readBeans((File)PRE_ADAPTER_IN);
        List baitBiasDetailMetricsList = MetricsFile.readBeans((File)BAIT_BIAS_IN);
        String oxogSampleAlias = ((SequencingArtifactMetrics.PreAdapterDetailMetrics)((Object)preAdapterDetailMetricsList.get((int)0))).SAMPLE_ALIAS;
        HashSet<String> oxogLibraries = new HashSet<String>();
        HashSet<String> oxogContexts = new HashSet<String>();
        for (SequencingArtifactMetrics.PreAdapterDetailMetrics preAdapter : preAdapterDetailMetricsList) {
            oxogLibraries.add(preAdapter.LIBRARY);
            if (preAdapter.REF_BASE != 'C') continue;
            oxogContexts.add(preAdapter.CONTEXT);
        }
        HashMap preAdapterDetailMetricsMap = new HashMap();
        HashMap baitBiasDetailMetricsMap = new HashMap();
        for (String library : oxogLibraries) {
            HashMap contextsToPreAdapter = new HashMap();
            HashMap contextsToBaitBias = new HashMap();
            preAdapterDetailMetricsMap.put(library, contextsToPreAdapter);
            baitBiasDetailMetricsMap.put(library, contextsToBaitBias);
        }
        for (SequencingArtifactMetrics.PreAdapterDetailMetrics preAdapter : preAdapterDetailMetricsList) {
            transition = Transition.transitionOf(preAdapter.REF_BASE, preAdapter.ALT_BASE);
            if (!this.isOxoG(transition)) continue;
            ((Map)preAdapterDetailMetricsMap.get(preAdapter.LIBRARY)).put(preAdapter.CONTEXT, preAdapter);
        }
        for (Object baitBias : baitBiasDetailMetricsList) {
            transition = Transition.transitionOf(((SequencingArtifactMetrics.BaitBiasDetailMetrics)((Object)baitBias)).REF_BASE, ((SequencingArtifactMetrics.BaitBiasDetailMetrics)((Object)baitBias)).ALT_BASE);
            if (!this.isOxoG(transition)) continue;
            ((Map)baitBiasDetailMetricsMap.get(((SequencingArtifactMetrics.BaitBiasDetailMetrics)((Object)baitBias)).LIBRARY)).put(((SequencingArtifactMetrics.BaitBiasDetailMetrics)((Object)baitBias)).CONTEXT, baitBias);
        }
        ArrayList<CollectOxoGMetrics.CpcgMetrics> oxogMetrics = new ArrayList<CollectOxoGMetrics.CpcgMetrics>();
        for (String library : oxogLibraries) {
            for (String context : oxogContexts) {
                CollectOxoGMetrics.CpcgMetrics m = new CollectOxoGMetrics.CpcgMetrics();
                m.SAMPLE_ALIAS = oxogSampleAlias;
                m.LIBRARY = library;
                m.CONTEXT = context;
                m.TOTAL_SITES = 0;
                SequencingArtifactMetrics.PreAdapterDetailMetrics preAdapter = (SequencingArtifactMetrics.PreAdapterDetailMetrics)((Object)((Map)preAdapterDetailMetricsMap.get(library)).get(SequenceUtil.reverseComplement((String)context)));
                SequencingArtifactMetrics.BaitBiasDetailMetrics baitBiasFwd = (SequencingArtifactMetrics.BaitBiasDetailMetrics)((Object)((Map)baitBiasDetailMetricsMap.get(library)).get(context));
                m.TOTAL_BASES = preAdapter.PRO_REF_BASES + preAdapter.PRO_ALT_BASES + preAdapter.CON_REF_BASES + preAdapter.CON_ALT_BASES;
                m.REF_TOTAL_BASES = preAdapter.PRO_REF_BASES + preAdapter.CON_REF_BASES;
                m.REF_NONOXO_BASES = preAdapter.CON_REF_BASES;
                m.REF_OXO_BASES = preAdapter.PRO_REF_BASES;
                m.ALT_NONOXO_BASES = preAdapter.CON_ALT_BASES;
                m.ALT_OXO_BASES = preAdapter.PRO_ALT_BASES;
                m.OXIDATION_ERROR_RATE = (double)Math.max(m.ALT_OXO_BASES - m.ALT_NONOXO_BASES, 1L) / (double)m.TOTAL_BASES;
                m.OXIDATION_Q = -10.0 * Math.log10(m.OXIDATION_ERROR_RATE);
                m.C_REF_REF_BASES = baitBiasFwd.FWD_CXT_REF_BASES;
                m.G_REF_REF_BASES = baitBiasFwd.REV_CXT_REF_BASES;
                m.C_REF_ALT_BASES = baitBiasFwd.FWD_CXT_ALT_BASES;
                m.G_REF_ALT_BASES = baitBiasFwd.REV_CXT_ALT_BASES;
                double cRefErrorRate = (double)m.C_REF_ALT_BASES / (double)(m.C_REF_ALT_BASES + m.C_REF_REF_BASES);
                double gRefErrorRate = (double)m.G_REF_ALT_BASES / (double)(m.G_REF_ALT_BASES + m.G_REF_REF_BASES);
                m.C_REF_OXO_ERROR_RATE = Math.max(cRefErrorRate - gRefErrorRate, 1.0E-10);
                m.G_REF_OXO_ERROR_RATE = Math.max(gRefErrorRate - cRefErrorRate, 1.0E-10);
                m.C_REF_OXO_Q = -10.0 * Math.log10(m.C_REF_OXO_ERROR_RATE);
                m.G_REF_OXO_Q = -10.0 * Math.log10(m.G_REF_OXO_ERROR_RATE);
                oxogMetrics.add(m);
            }
        }
        MetricsFile outputFile = this.getMetricsFile();
        for (CollectOxoGMetrics.CpcgMetrics m : oxogMetrics) {
            outputFile.addMetric((MetricBase)m);
        }
        outputFile.write(OXOG_OUT);
        return 0;
    }

    private boolean isOxoG(Transition t) {
        return t.equals((Object)Transition.CtoA) || t.equals((Object)Transition.GtoT);
    }
}

