/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.artifacts;

import htsjdk.samtools.util.SequenceUtil;
import java.util.Arrays;

public enum Transition {
    AtoA('A', 'A'),
    AtoC('A', 'C'),
    AtoG('A', 'G'),
    AtoT('A', 'T'),
    CtoA('C', 'A'),
    CtoC('C', 'C'),
    CtoG('C', 'G'),
    CtoT('C', 'T'),
    GtoA('G', 'A'),
    GtoC('G', 'C'),
    GtoG('G', 'G'),
    GtoT('G', 'T'),
    TtoA('T', 'A'),
    TtoC('T', 'C'),
    TtoG('T', 'G'),
    TtoT('T', 'T');

    private static final Transition[] ALT_VALUES;
    private final char ref;
    private final char call;
    protected static final int[] baseIndexMap;
    private static final Transition[][] transitionIndexMap;

    private Transition(char ref, char call) {
        this.ref = ref;
        this.call = call;
    }

    public static Transition transitionOf(char ref, char call) {
        try {
            return transitionIndexMap[baseIndexMap[ref]][baseIndexMap[call]];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(String.format("Base params should be one of {A, C, T, G} but ref=%s and call=%s", Character.valueOf(ref), Character.valueOf(call)));
        }
    }

    public static Transition[] altValues() {
        return ALT_VALUES;
    }

    public Transition complement() {
        return Transition.transitionOf((char)SequenceUtil.complement((byte)((byte)this.ref)), (char)SequenceUtil.complement((byte)((byte)this.call)));
    }

    public char ref() {
        return this.ref;
    }

    public char call() {
        return this.call;
    }

    public String toString() {
        return this.ref + ">" + this.call;
    }

    static {
        ALT_VALUES = new Transition[]{AtoC, AtoG, AtoT, CtoA, CtoG, CtoT, GtoA, GtoC, GtoT, TtoA, TtoC, TtoG};
        baseIndexMap = new int[256];
        Arrays.fill(baseIndexMap, -1);
        for (Base b : Base.values()) {
            Transition.baseIndexMap[b.base] = b.ordinal();
        }
        transitionIndexMap = new Transition[Base.values().length][Base.values().length];
        for (Base b1 : Base.values()) {
            for (Base b2 : Base.values()) {
                Transition.transitionIndexMap[b1.ordinal()][b2.ordinal()] = Transition.valueOf(b1.toString() + "to" + b2.toString());
            }
        }
    }

    protected static enum Base {
        A('A'),
        C('C'),
        G('G'),
        T('T');

        public byte base;

        private Base(char base) {
            this.base = (byte)base;
        }
    }
}

