/*
 * Decompiled with CFR 0.152.
 */
package picard.reference;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.IntervalListReferenceSequenceMask;
import htsjdk.samtools.util.StringUtil;
import htsjdk.samtools.util.WholeGenomeReferenceSequenceMask;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.ReferenceProgramGroup;

@CommandLineProgramProperties(summary="Counts the number of non-N bases in a fasta file.This tool takes any FASTA-formatted file and counts the number of non-N bases in it.Note that it requires that the fasta file have associated index (.fai) and dictionary (.dict) files.<br /><h4>Usage example:</h4><pre>java -jar picard.jar NonNFastaSize \\<br />      I=input_sequence.fasta \\<br />      O=count.txt</pre><hr />", oneLineSummary="Counts the number of non-N bases in a fasta file.", programGroup=ReferenceProgramGroup.class)
@DocumentedFeature
public class NonNFastaSize
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Counts the number of non-N bases in a fasta file.";
    static final String USAGE_DETAILS = "This tool takes any FASTA-formatted file and counts the number of non-N bases in it.Note that it requires that the fasta file have associated index (.fai) and dictionary (.dict) files.<br /><h4>Usage example:</h4><pre>java -jar picard.jar NonNFastaSize \\<br />      I=input_sequence.fasta \\<br />      O=count.txt</pre><hr />";
    @Argument(shortName="I", doc="The input FASTA file.")
    public File INPUT;
    @Argument(shortName="O", doc="The output file in which to record the count.")
    public File OUTPUT;
    @Argument(shortName="INTERVALS", doc="An interval list file that contains the locations of the positions to assess.  If not provided, the entire reference will be used", optional=true)
    public File INTERVALS = null;

    public static void main(String[] args) {
        new NonNFastaSize().instanceMainWithExit(args);
    }

    @Override
    protected int doWork() {
        IntervalListReferenceSequenceMask referenceSequenceMask;
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        ReferenceSequenceFile ref = ReferenceSequenceFileFactory.getReferenceSequenceFile((File)this.INPUT);
        if (this.INTERVALS != null) {
            IOUtil.assertFileIsReadable((File)this.INTERVALS);
            IntervalList intervalList = IntervalList.fromFile((File)this.INTERVALS);
            referenceSequenceMask = new IntervalListReferenceSequenceMask(intervalList);
        } else {
            SAMFileHeader header = new SAMFileHeader();
            header.setSequenceDictionary(ref.getSequenceDictionary());
            referenceSequenceMask = new WholeGenomeReferenceSequenceMask(header);
        }
        long nonNbases = 0L;
        for (SAMSequenceRecord rec : ref.getSequenceDictionary().getSequences()) {
            ReferenceSequence sequence = ref.getSequence(rec.getSequenceName());
            byte[] bases = sequence.getBases();
            StringUtil.toUpperCase((byte[])bases);
            for (int i = 0; i < bases.length; ++i) {
                if (!referenceSequenceMask.get(sequence.getContigIndex(), i + 1)) continue;
                nonNbases += bases[i] == 78 ? 0L : 1L;
            }
        }
        try {
            BufferedWriter out = IOUtil.openFileForBufferedWriting((File)this.OUTPUT);
            out.write(nonNbases + "\n");
            out.close();
        }
        catch (IOException ioe) {
            throw new PicardException("Error writing to file " + this.OUTPUT.getAbsolutePath(), ioe);
        }
        return 0;
    }
}

