/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.io.IOException;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;

@CommandLineProgramProperties(summary="Asserts the provided gzip file's (e.g., BAM) last block is well-formed; RC 100 otherwise", oneLineSummary="Asserts the provided gzip file's (e.g., BAM) last block is well-formed; RC 100 otherwise", programGroup=DiagnosticsAndQCProgramGroup.class)
@DocumentedFeature
public class CheckTerminatorBlock
extends CommandLineProgram {
    static final String USAGE = "Asserts the provided gzip file's (e.g., BAM) last block is well-formed; RC 100 otherwise";
    @Argument(shortName="I", doc="The block compressed file to check.")
    public File INPUT;

    public static void main(String[] args) {
        new CheckTerminatorBlock().instanceMainWithExit(args);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        try {
            BlockCompressedInputStream.FileTermination term = BlockCompressedInputStream.checkTermination((File)this.INPUT);
            System.err.println(term.name());
            if (term == BlockCompressedInputStream.FileTermination.DEFECTIVE) {
                return 100;
            }
            return 0;
        }
        catch (IOException ioe) {
            throw new PicardException("Exception reading terminator block of file: " + this.INPUT.getAbsolutePath());
        }
    }
}

