/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.reference.ReferenceSequenceFileWalker;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.ProgressLoggerInterface;
import java.io.File;
import java.util.stream.StreamSupport;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;
import picard.sam.AbstractAlignmentMerger;

@CommandLineProgramProperties(summary="This tool takes in a coordinate-sorted SAM or BAM and calculatesthe NM, MD, and UQ tags by comparing with the reference.<br />This may be needed when MergeBamAlignment was run with SORT_ORDER other than 'coordinate' and thuscould not fix these tags then. The input must be coordinate sorted in order to run. If specified,the MD and NM tags can be ignored and only the UQ tag be set.<br /><h4>Usage example:</h4><pre>java -jar picard.jar SetNmMdAndUqTags <br />      R=reference_sequence.fasta <br />      I=sorted.bam <br />      O=fixed.bam <br /></pre>", oneLineSummary="Fixes the NM, MD, and UQ tags in a SAM file ", programGroup=ReadDataManipulationProgramGroup.class)
@DocumentedFeature
public class SetNmMdAndUqTags
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Fixes the NM, MD, and UQ tags in a SAM file ";
    static final String USAGE_DETAILS = "This tool takes in a coordinate-sorted SAM or BAM and calculatesthe NM, MD, and UQ tags by comparing with the reference.<br />This may be needed when MergeBamAlignment was run with SORT_ORDER other than 'coordinate' and thuscould not fix these tags then. The input must be coordinate sorted in order to run. If specified,the MD and NM tags can be ignored and only the UQ tag be set.<br /><h4>Usage example:</h4><pre>java -jar picard.jar SetNmMdAndUqTags <br />      R=reference_sequence.fasta <br />      I=sorted.bam <br />      O=fixed.bam <br /></pre>";
    @Argument(doc="The BAM or SAM file to fix. ", shortName="I")
    public File INPUT;
    @Argument(doc="The fixed BAM or SAM output file. ", shortName="O")
    public File OUTPUT;
    @Argument(doc="Whether the file contains bisulfite sequence (used when calculating the NM tag).")
    public boolean IS_BISULFITE_SEQUENCE = false;
    @Argument(doc="Only set the UQ tag, ignore MD and NM.")
    public boolean SET_ONLY_UQ = false;
    private final Log log = Log.getInstance(SetNmMdAndUqTags.class);

    @Override
    protected boolean requiresReference() {
        return true;
    }

    public static void main(String[] argv) {
        new SetNmMdAndUqTags().instanceMainWithExit(argv);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        SamReader reader = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(this.INPUT);
        if (reader.getFileHeader().getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
            throw new SAMException("Input must be coordinate-sorted for this program to run. Found: " + reader.getFileHeader().getSortOrder());
        }
        SAMFileWriter writer = new SAMFileWriterFactory().makeSAMOrBAMWriter(reader.getFileHeader(), true, this.OUTPUT);
        writer.setProgressLogger((ProgressLoggerInterface)new ProgressLogger(this.log, 10000000, "Wrote", "records"));
        ReferenceSequenceFileWalker refSeqWalker = new ReferenceSequenceFileWalker(this.REFERENCE_SEQUENCE);
        StreamSupport.stream(reader.spliterator(), false).peek(rec -> this.fixRecord((SAMRecord)rec, refSeqWalker)).forEach(arg_0 -> ((SAMFileWriter)writer).addAlignment(arg_0));
        CloserUtil.close((Object)reader);
        writer.close();
        return 0;
    }

    private void fixRecord(SAMRecord record, ReferenceSequenceFileWalker refSeqWalker) {
        if (!record.getReadUnmappedFlag()) {
            if (this.SET_ONLY_UQ) {
                AbstractAlignmentMerger.fixUq(record, refSeqWalker, this.IS_BISULFITE_SEQUENCE);
            } else {
                AbstractAlignmentMerger.fixNmMdAndUq(record, refSeqWalker, this.IS_BISULFITE_SEQUENCE);
            }
        }
    }
}

