/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.IntervalsManipulationProgramGroup;

@CommandLineProgramProperties(summary="Converts an Picard IntervalList file to a BED file.", oneLineSummary="Converts an Picard IntervalList file to a BED file.", programGroup=IntervalsManipulationProgramGroup.class)
@DocumentedFeature
public class IntervalListToBed
extends CommandLineProgram {
    @Argument(shortName="I", doc="Input IntervalList file.")
    public File INPUT;
    @Argument(shortName="O", doc="Output BED file.")
    public File OUTPUT;
    @Argument(doc="The score, between 0-1000, to output for each interval in the BED file.")
    public int SCORE = 500;
    @Argument(doc="If true, sort the interval list prior to outputting as BED file.")
    public boolean SORT = true;

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        IntervalList intervals = IntervalList.fromFile((File)this.INPUT);
        if (this.SORT) {
            intervals = intervals.sorted();
        }
        try {
            BufferedWriter out = IOUtil.openFileForBufferedWriting((File)this.OUTPUT);
            for (Interval i : intervals) {
                String strand = i.isNegativeStrand() ? "-" : "+";
                List fields = CollectionUtil.makeList((Object[])new Serializable[]{i.getContig(), Integer.valueOf(i.getStart() - 1), Integer.valueOf(i.getEnd()), i.getName(), Integer.valueOf(this.SCORE), strand});
                out.append(fields.stream().map(String::valueOf).collect(Collectors.joining("\t")));
                out.newLine();
            }
            out.close();
        }
        catch (IOException ioe) {
            throw new RuntimeIOException((Throwable)ioe);
        }
        return 0;
    }
}

