/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMProgramRecord;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import htsjdk.variant.vcf.VCFFileReader;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineParser;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.IntervalsManipulationProgramGroup;
import picard.util.IntervalListScatterer;

@CommandLineProgramProperties(summary="A tool for performing various IntervalList manipulations <h3>Summary</h3>This tool offers multiple interval list file manipulation capabilities, including: sorting, merging, subtracting, padding, and other set-theoretic operations. The default action is to merge and sort the intervals provided in the INPUTs. Other options, e.g. interval subtraction, are controlled by the arguments.<br />Both IntervalList and VCF files are accepted as input. IntervalList should be denoted with the extension .interval_list, while a VCF must have one of .vcf, .vcf.gz, .bcf When VCF file is used as input, each variant is translated into an using its reference allele or the END INFO annotation (if present) to determine the extent of the interval. \nIntervalListTools can also \"scatter\" the resulting interval-list into many interval-files. This can be useful for creating multiple interval lists for scattering an analysis over.\n\n <h3>Details</h3> The IntervalList file format is designed to help the users avoid mixing references when supplying intervals and other genomic data to a single tool. A SAM style header must be present at the top of the file. After the header, the file then contains records, one per line in text format with the followingvalues tab-separated: \n\n - Sequence name (SN) \n - Start position (1-based)\n - End position (1-based, inclusive)\n - Strand (either + or -)\n - Interval name (ideally unique names for intervals)\n\nThe coordinate system is 1-based, closed-ended so that the first base in a sequence has position 1, and both the start and the end positions are included in an interval.\n\nExample interval list file<pre>@HD\tVN:1.0\n@SQ\tSN:chr1\tLN:501\n@SQ\tSN:chr2\tLN:401\nchr1\t1\t100\t+\tstarts at the first base of the contig and covers 100 bases\nchr2\t100\t100\t+\tinterval with exactly one base\n</pre>\n\n<h3>Usage Examples</h3><h4>1. Combine the intervals from two interval lists:</h4><pre>java -jar picard.jar IntervalListTools \\\n      ACTION=CONCAT \\\n      I=input.interval_list \\\n      I=input_2.interval_list \\\n      O=new.interval_list</pre> <h4>2. Combine the intervals from two interval lists, sorting the resulting in list and merging overlapping and abutting intervals:</h4> <pre> java -jar picard.jar IntervalListTools \\\n       ACTION=CONCAT \\\n       SORT=true \\\n       UNIQUE=true \\\n       I=input.interval_list \\\n       I=input_2.interval_list \\\n       O=new.interval_list </pre> <h4>3. Subtract the intervals in SECOND_INPUT from those in INPUT</h4> <pre> java -jar picard.jar IntervalListTools \\\n       ACTION=SUBTRACT \\\n       I=input.interval_list \\\n       SI=input_2.interval_list \\\n       O=new.interval_list </pre> <h4>4. Find bases that are in either input1.interval_list or input2.interval_list, and also in input3.interval_list:</h4> <pre> java -jar picard.jar IntervalListTools \\\n       ACTION=INTERSECT \\\n       I=input1.interval_list \\\n       I=input2.interval_list \\\n       SI=input3.interval_list \\\n       O=new.interval_list </pre>", oneLineSummary="A tool for performing various IntervalList manipulations", programGroup=IntervalsManipulationProgramGroup.class)
@DocumentedFeature
public class IntervalListTools
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "A tool for performing various IntervalList manipulations";
    static final String USAGE_DETAILS = " <h3>Summary</h3>This tool offers multiple interval list file manipulation capabilities, including: sorting, merging, subtracting, padding, and other set-theoretic operations. The default action is to merge and sort the intervals provided in the INPUTs. Other options, e.g. interval subtraction, are controlled by the arguments.<br />Both IntervalList and VCF files are accepted as input. IntervalList should be denoted with the extension .interval_list, while a VCF must have one of .vcf, .vcf.gz, .bcf When VCF file is used as input, each variant is translated into an using its reference allele or the END INFO annotation (if present) to determine the extent of the interval. \nIntervalListTools can also \"scatter\" the resulting interval-list into many interval-files. This can be useful for creating multiple interval lists for scattering an analysis over.\n\n <h3>Details</h3> The IntervalList file format is designed to help the users avoid mixing references when supplying intervals and other genomic data to a single tool. A SAM style header must be present at the top of the file. After the header, the file then contains records, one per line in text format with the followingvalues tab-separated: \n\n - Sequence name (SN) \n - Start position (1-based)\n - End position (1-based, inclusive)\n - Strand (either + or -)\n - Interval name (ideally unique names for intervals)\n\nThe coordinate system is 1-based, closed-ended so that the first base in a sequence has position 1, and both the start and the end positions are included in an interval.\n\nExample interval list file<pre>@HD\tVN:1.0\n@SQ\tSN:chr1\tLN:501\n@SQ\tSN:chr2\tLN:401\nchr1\t1\t100\t+\tstarts at the first base of the contig and covers 100 bases\nchr2\t100\t100\t+\tinterval with exactly one base\n</pre>\n\n<h3>Usage Examples</h3><h4>1. Combine the intervals from two interval lists:</h4><pre>java -jar picard.jar IntervalListTools \\\n      ACTION=CONCAT \\\n      I=input.interval_list \\\n      I=input_2.interval_list \\\n      O=new.interval_list</pre> <h4>2. Combine the intervals from two interval lists, sorting the resulting in list and merging overlapping and abutting intervals:</h4> <pre> java -jar picard.jar IntervalListTools \\\n       ACTION=CONCAT \\\n       SORT=true \\\n       UNIQUE=true \\\n       I=input.interval_list \\\n       I=input_2.interval_list \\\n       O=new.interval_list </pre> <h4>3. Subtract the intervals in SECOND_INPUT from those in INPUT</h4> <pre> java -jar picard.jar IntervalListTools \\\n       ACTION=SUBTRACT \\\n       I=input.interval_list \\\n       SI=input_2.interval_list \\\n       O=new.interval_list </pre> <h4>4. Find bases that are in either input1.interval_list or input2.interval_list, and also in input3.interval_list:</h4> <pre> java -jar picard.jar IntervalListTools \\\n       ACTION=INTERSECT \\\n       I=input1.interval_list \\\n       I=input2.interval_list \\\n       SI=input3.interval_list \\\n       O=new.interval_list </pre>";
    @Argument(shortName="I", doc="One or more interval lists. If multiple interval lists are provided the output is theresult of merging the inputs. Supported formats are interval_list and VCF.", minElements=1)
    public List<File> INPUT;
    @Argument(doc="The output interval list file to write (if SCATTER_COUNT == 1) or the directory into which to write the scattered interval sub-directories (if SCATTER_COUNT > 1).", shortName="O", optional=true)
    public File OUTPUT;
    @Argument(doc="The amount to pad each end of the intervals by before other operations are undertaken. Negative numbers are allowed and indicate intervals should be shrunk. Resulting intervals < 0 bases long will be removed. Padding is applied to the interval lists (both INPUT and SECOND_INPUT, if provided) <b> before </b> the ACTION is performed.", optional=true)
    public int PADDING = 0;
    @Argument(doc="If true, merge overlapping and adjacent intervals to create a list of unique intervals. Implies SORT=true.")
    public boolean UNIQUE = false;
    @Argument(doc="If true, sort the resulting interval list by coordinate.")
    public boolean SORT = true;
    @Argument(doc="Action to take on inputs.")
    public Action ACTION = Action.CONCAT;
    @Argument(shortName="SI", doc="Second set of intervals for SUBTRACT and DIFFERENCE operations.", optional=true)
    public List<File> SECOND_INPUT;
    @Argument(doc="One or more lines of comment to add to the header of the output file (as @CO lines in the SAM header).", optional=true)
    public List<String> COMMENT = null;
    @Argument(doc="The number of files into which to scatter the resulting list by locus; in some situations, fewer intervals may be emitted.  Note - if > 1, the resultant scattered intervals will be sorted and uniqued.  The sort will be inverted if the INVERT flag is set.")
    public int SCATTER_COUNT = 1;
    @Argument(doc="Whether to include filtered variants in the vcf when generating an interval list from vcf.", optional=true)
    public boolean INCLUDE_FILTERED = false;
    @Argument(shortName="BRK", doc="If set to a positive value will create a new interval list with the original intervals broken up at integer multiples of this value. Set to 0 to NOT break up intervals.", optional=true)
    public int BREAK_BANDS_AT_MULTIPLES_OF = 0;
    @Argument(shortName="M", doc="Selects between various ways in which scattering of the interval-list can happen.")
    public IntervalListScatterer.Mode SUBDIVISION_MODE = IntervalListScatterer.Mode.INTERVAL_SUBDIVISION;
    @Argument(doc="Produce the inverse list of intervals, that is, the regions in the genome that are <br>not</br> covered by any of the input intervals. Will merge abutting intervals first. Output will be sorted.", optional=true)
    public boolean INVERT = false;
    private static final Log LOG = Log.getInstance(IntervalListTools.class);

    /*
     * WARNING - void declaration
     */
    @Override
    protected int doWork() {
        void var10_22;
        List finalIntervals;
        IOUtil.assertFilesAreReadable(this.INPUT);
        IOUtil.assertFilesAreReadable(this.SECOND_INPUT);
        if (this.OUTPUT != null) {
            if (this.SCATTER_COUNT == 1) {
                IOUtil.assertFileIsWritable((File)this.OUTPUT);
            } else {
                IOUtil.assertDirectoryIsWritable((File)this.OUTPUT);
            }
        }
        List<IntervalList> lists = this.openIntervalLists(this.INPUT);
        List<IntervalList> secondLists = this.openIntervalLists(this.SECOND_INPUT);
        if (this.UNIQUE && !this.SORT) {
            LOG.warn(new Object[]{"UNIQUE=true requires sorting but SORT=false was specified.  Results will be sorted."});
        }
        IntervalList result = this.ACTION.act(lists, secondLists);
        if (this.SCATTER_COUNT > 1) {
            this.SORT = true;
            this.UNIQUE = true;
        }
        if (this.INVERT) {
            this.SORT = false;
            this.UNIQUE = true;
        }
        IntervalList possiblySortedResult = this.SORT ? result.sorted() : result;
        IntervalList possiblyInvertedResult = this.INVERT ? IntervalList.invert((IntervalList)possiblySortedResult) : possiblySortedResult;
        List list = finalIntervals = this.UNIQUE ? possiblyInvertedResult.uniqued().getIntervals() : possiblyInvertedResult.getIntervals();
        if (this.BREAK_BANDS_AT_MULTIPLES_OF > 0) {
            finalIntervals = IntervalList.breakIntervalsAtBandMultiples((List)finalIntervals, (int)this.BREAK_BANDS_AT_MULTIPLES_OF);
        }
        SAMFileHeader header = result.getHeader();
        HashSet<String> pgs = new HashSet<String>();
        for (SAMProgramRecord sAMProgramRecord : header.getProgramRecords()) {
            pgs.add(sAMProgramRecord.getId());
        }
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            if (pgs.contains(String.valueOf(i))) continue;
            SAMProgramRecord sAMProgramRecord = new SAMProgramRecord(String.valueOf(i));
            sAMProgramRecord.setCommandLine(this.getCommandLine());
            sAMProgramRecord.setProgramName(this.getClass().getSimpleName());
            header.addProgramRecord(sAMProgramRecord);
            break;
        }
        if (this.COMMENT != null) {
            for (String string : this.COMMENT) {
                header.addComment(string);
            }
        }
        IntervalList output = new IntervalList(header);
        for (Interval i : finalIntervals) {
            output.add(i);
        }
        if (this.OUTPUT != null) {
            if (this.SCATTER_COUNT == 1) {
                output.write(this.OUTPUT);
                List<IntervalList> list2 = Arrays.asList(output);
            } else {
                List<IntervalList> scattered = this.writeScatterIntervals(output);
                LOG.info(new Object[]{String.format("Wrote %s scatter subdirectories to %s.", scattered.size(), this.OUTPUT)});
                if (scattered.size() != this.SCATTER_COUNT) {
                    LOG.warn(new Object[]{String.format("Requested scatter width of %s, but only emitted %s.  (This may be an expected consequence of running in %s mode.)", new Object[]{this.SCATTER_COUNT, scattered.size(), this.SUBDIVISION_MODE})});
                }
                List<IntervalList> list3 = scattered;
            }
        } else {
            List<IntervalList> list4 = Arrays.asList(output);
        }
        long totalUniqueBaseCount = 0L;
        long intervalCount = 0L;
        for (IntervalList finalInterval : var10_22) {
            totalUniqueBaseCount += finalInterval.getUniqueBaseCount();
            intervalCount += (long)finalInterval.size();
        }
        LOG.info(new Object[]{"Produced " + intervalCount + " intervals totalling " + totalUniqueBaseCount + " unique bases."});
        return 0;
    }

    private List<IntervalList> openIntervalLists(List<File> files) {
        ArrayList<IntervalList> lists = new ArrayList<IntervalList>();
        for (File f : files) {
            try {
                lists.add(IntervalListInputType.getIntervalList(f, this.INCLUDE_FILTERED).padded(this.PADDING));
            }
            catch (Exception e) {
                LOG.error(new Object[]{"There was a problem opening IntervalList file " + f.getAbsolutePath()});
                throw e;
            }
        }
        return lists;
    }

    @Override
    protected String[] customCommandLineValidation() {
        ArrayList<String> errorMsgs = new ArrayList<String>();
        if (this.SCATTER_COUNT < 1) {
            errorMsgs.add("SCATTER_COUNT must be greater than 0.");
        }
        if (this.BREAK_BANDS_AT_MULTIPLES_OF < 0) {
            errorMsgs.add("BREAK_BANDS_AT_MULTIPLES_OF must be greater than or equal to 0.");
        }
        if ((this.SECOND_INPUT == null || this.SECOND_INPUT.isEmpty()) && this.ACTION.takesSecondInput) {
            errorMsgs.add("SECOND_INPUT was not provided but action " + (Object)((Object)this.ACTION) + " requires a second input.");
        }
        if (this.SECOND_INPUT != null && !this.SECOND_INPUT.isEmpty() && !this.ACTION.takesSecondInput) {
            errorMsgs.add("SECOND_INPUT was provided but action " + (Object)((Object)this.ACTION) + " doesn't take a second input.");
        }
        return errorMsgs.isEmpty() ? null : errorMsgs.toArray(new String[errorMsgs.size()]);
    }

    private List<IntervalList> writeScatterIntervals(IntervalList list) {
        IntervalListScatterer scatterer = new IntervalListScatterer(this.SUBDIVISION_MODE);
        List<IntervalList> scattered = scatterer.scatter(list, this.SCATTER_COUNT, this.UNIQUE);
        DecimalFormat fileNameFormatter = new DecimalFormat("0000");
        int fileIndex = 1;
        for (IntervalList intervals : scattered) {
            intervals.write(IntervalListTools.createDirectoryAndGetScatterFile(this.OUTPUT, scattered.size(), fileNameFormatter.format(fileIndex++)));
        }
        return scattered;
    }

    public static File getScatteredFileName(File scatterDirectory, long scatterTotal, String formattedIndex) {
        return new File(scatterDirectory.getAbsolutePath() + "/temp_" + formattedIndex + "_of_" + scatterTotal + "/scattered" + ".interval_list");
    }

    private static File createDirectoryAndGetScatterFile(File outputDirectory, long scatterCount, String formattedIndex) {
        IntervalListTools.createDirectoryOrFail(outputDirectory);
        File result = IntervalListTools.getScatteredFileName(outputDirectory, scatterCount, formattedIndex);
        IntervalListTools.createDirectoryOrFail(result.getParentFile());
        return result;
    }

    private static void createDirectoryOrFail(File directory) {
        if (!directory.exists() && !directory.mkdir()) {
            throw new PicardException("Unable to create directory: " + directory.getAbsolutePath());
        }
    }

    static enum IntervalListInputType {
        VCF(IOUtil.VCF_EXTENSIONS){

            @Override
            protected IntervalList getIntervalListInternal(File vcf, boolean includeFiltered) {
                return VCFFileReader.fromVcf((File)vcf, (boolean)includeFiltered);
            }
        }
        ,
        INTERVAL_LIST(new String[]{".interval_list"}){

            @Override
            protected IntervalList getIntervalListInternal(File intervalList, boolean includeFiltered) {
                return IntervalList.fromFile((File)intervalList);
            }
        };

        protected final Collection<String> applicableExtensions;

        private IntervalListInputType(String ... s) {
            this.applicableExtensions = CollectionUtil.makeSet((Object[])s);
        }

        private IntervalListInputType(Collection<String> extensions) {
            this.applicableExtensions = extensions;
        }

        protected abstract IntervalList getIntervalListInternal(File var1, boolean var2);

        static IntervalListInputType forFile(File intervalListExtractable) {
            for (IntervalListInputType intervalListInputType : IntervalListInputType.values()) {
                for (String s : intervalListInputType.applicableExtensions) {
                    if (!intervalListExtractable.getName().endsWith(s)) continue;
                    return intervalListInputType;
                }
            }
            throw new SAMException("Cannot figure out type of file " + intervalListExtractable.getAbsolutePath() + " from extension. Current implementation understands the following types: " + Arrays.toString((Object[])IntervalListInputType.values()));
        }

        public static IntervalList getIntervalList(File file, boolean includeFiltered) {
            return IntervalListInputType.forFile(file).getIntervalListInternal(file, includeFiltered);
        }

        public String toString() {
            return super.toString() + ": " + this.applicableExtensions.toString();
        }
    }

    public static enum Action implements CommandLineParser.ClpEnum
    {
        CONCAT("The concatenation of all the intervals in all the INPUTs, no sorting or merging of overlapping/abutting intervals implied. Will result in a possibly unsorted list unless requested otherwise.", false){

            @Override
            IntervalList act(List<IntervalList> list, List<IntervalList> unused) {
                return IntervalList.concatenate(list);
            }
        }
        ,
        UNION("Like CONCATENATE but with UNIQUE and SORT implied, the result being the set-wise union of all INPUTS, with overlapping and abutting intervals merged into one.", false){

            @Override
            IntervalList act(List<IntervalList> list, List<IntervalList> unused) {
                return IntervalList.union(list);
            }
        }
        ,
        INTERSECT("The sorted and merged set of all loci that are contained in all of the INPUTs.", false){

            @Override
            IntervalList act(List<IntervalList> list, List<IntervalList> unused) {
                return IntervalList.intersection(list);
            }
        }
        ,
        SUBTRACT("Subtracts the intervals in SECOND_INPUT from those in INPUT. The resulting loci are those in INPUT that are not in SECOND_INPUT.", true){

            @Override
            IntervalList act(List<IntervalList> list1, List<IntervalList> list2) {
                return IntervalList.subtract(list1, list2);
            }
        }
        ,
        SYMDIFF("Results in loci that are in INPUT or SECOND_INPUT but are not in both.", true){

            @Override
            IntervalList act(List<IntervalList> list1, List<IntervalList> list2) {
                return IntervalList.difference(list1, list2);
            }
        }
        ,
        OVERLAPS("Outputs the entire intervals from INPUT that have bases which overlap any interval from SECOND_INPUT. Note that this is different than INTERSECT in that each original interval is either emitted in its entirety, or not at all.", true){

            @Override
            IntervalList act(List<IntervalList> list1, List<IntervalList> list2) {
                return IntervalList.overlaps(list1, list2);
            }
        };

        final String helpdoc;
        final boolean takesSecondInput;

        private Action(String helpdoc, boolean takesSecondInput) {
            this.helpdoc = helpdoc;
            this.takesSecondInput = takesSecondInput;
        }

        public String getHelpDoc() {
            return this.helpdoc;
        }

        abstract IntervalList act(List<IntervalList> var1, List<IntervalList> var2);
    }
}

