/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import java.util.EnumSet;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.VariantManipulationProgramGroup;

@CommandLineProgramProperties(summary="This tool enables the user to rename a sample in either a VCF or BCF file.  It is intended to change the name of a sample in a VCF prior to merging with VCF files in which one or more samples have similar names. Note that the input VCF file must be single-sample VCF and that the NEW_SAMPLE_NAME is required.<br /><br /><h4>Usage example:</h4><pre>java -jar picard.jar RenameSampleInVcf \\<br />      INPUT=input_variants.vcf \\<br />      OUTPUT=output_variants.vcf \\<br />      NEW_SAMPLE_NAME=sample</pre><h4> Notes </h4><br />The input VCF (or BCF) <i>must</i> be single-sample.", oneLineSummary="Renames a sample within a VCF or BCF.", programGroup=VariantManipulationProgramGroup.class)
@DocumentedFeature
public class RenameSampleInVcf
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Renames a sample within a VCF or BCF.";
    static final String USAGE_DETAILS = "This tool enables the user to rename a sample in either a VCF or BCF file.  It is intended to change the name of a sample in a VCF prior to merging with VCF files in which one or more samples have similar names. Note that the input VCF file must be single-sample VCF and that the NEW_SAMPLE_NAME is required.<br /><br /><h4>Usage example:</h4><pre>java -jar picard.jar RenameSampleInVcf \\<br />      INPUT=input_variants.vcf \\<br />      OUTPUT=output_variants.vcf \\<br />      NEW_SAMPLE_NAME=sample</pre><h4> Notes </h4><br />The input VCF (or BCF) <i>must</i> be single-sample.";
    @Argument(shortName="I", doc="Input single sample VCF or BCF file.")
    public File INPUT;
    @Argument(shortName="O", doc="Output single sample VCF.")
    public File OUTPUT;
    @Argument(doc="Existing name of sample in VCF; if provided, asserts that that is the name of the extant sample name", optional=true)
    public String OLD_SAMPLE_NAME = null;
    @Argument(doc="New name to give sample in output VCF.")
    public String NEW_SAMPLE_NAME;

    public static void main(String[] args) {
        new RenameSampleInVcf().instanceMainWithExit(args);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        VCFFileReader in = new VCFFileReader(this.INPUT);
        VCFHeader header = in.getFileHeader();
        if (header.getGenotypeSamples().size() > 1) {
            throw new IllegalArgumentException("Input VCF must be single-sample.");
        }
        if (this.OLD_SAMPLE_NAME != null && !this.OLD_SAMPLE_NAME.equals(header.getGenotypeSamples().get(0))) {
            throw new IllegalArgumentException("Input VCF did not contain expected sample. Contained: " + (String)header.getGenotypeSamples().get(0));
        }
        EnumSet<Options> options = EnumSet.copyOf(VariantContextWriterBuilder.DEFAULT_OPTIONS);
        if (this.CREATE_INDEX.booleanValue()) {
            options.add(Options.INDEX_ON_THE_FLY);
        } else {
            options.remove(Options.INDEX_ON_THE_FLY);
        }
        VCFHeader outHeader = new VCFHeader(header.getMetaDataInInputOrder(), CollectionUtil.makeList((Object[])new String[]{this.NEW_SAMPLE_NAME}));
        VariantContextWriter out = new VariantContextWriterBuilder().setOptions(options).setOutputFile(this.OUTPUT).setReferenceDictionary(outHeader.getSequenceDictionary()).build();
        out.writeHeader(outHeader);
        for (VariantContext ctx : in) {
            out.add(ctx);
        }
        out.close();
        in.close();
        return 0;
    }
}

