/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf.filter;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.filter.JavascriptVariantFilter;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFFilterHeaderLine;
import htsjdk.variant.vcf.VCFFormatHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.VariantFilteringProgramGroup;
import picard.vcf.filter.AlleleBalanceFilter;
import picard.vcf.filter.DepthFilter;
import picard.vcf.filter.FilterApplyingVariantIterator;
import picard.vcf.filter.FisherStrandFilter;
import picard.vcf.filter.GenotypeFilter;
import picard.vcf.filter.GenotypeQualityFilter;
import picard.vcf.filter.QdFilter;
import picard.vcf.filter.VariantFilter;

@CommandLineProgramProperties(summary="Applies one or more hard filters to a VCF file to filter out genotypes and variants.", oneLineSummary="Hard filters a VCF.", programGroup=VariantFilteringProgramGroup.class)
@DocumentedFeature
public class FilterVcf
extends CommandLineProgram {
    @Argument(shortName="I", doc="The INPUT VCF or BCF file.")
    public File INPUT;
    @Argument(shortName="O", doc="The output VCF or BCF.")
    public File OUTPUT;
    @Argument(doc="The minimum allele balance acceptable before filtering a site. Allele balance is calculated for heterozygotes as the number of bases supporting the least-represented allele over the total number of base observations. Different heterozygote genotypes at the same locus are measured independently. The locus is filtered if any allele balance is below the limit.")
    public double MIN_AB = 0.0;
    @Argument(doc="The minimum sequencing depth supporting a genotype before the genotype will be filtered out.")
    public int MIN_DP = 0;
    @Argument(doc="The minimum genotype quality that must be achieved for a sample otherwise the genotype will be filtered out.")
    public int MIN_GQ = 0;
    @Argument(doc="The maximum phred scaled fisher strand value before a site will be filtered out.")
    public double MAX_FS = Double.MAX_VALUE;
    @Argument(doc="The minimum QD value to accept or otherwise filter out the variant.")
    public double MIN_QD = 0.0;
    @Argument(shortName="JS", doc="Filters a VCF file with a javascript expression interpreted by the java javascript engine.  The script puts the following variables in the script context:  'variant' a VariantContext ( https://samtools.github.io/htsjdk/javadoc/htsjdk/htsjdk/variant/variantcontext/VariantContext.html ) and  'header' a VCFHeader ( https://samtools.github.io/htsjdk/javadoc/htsjdk/htsjdk/variant/vcf/VCFHeader.html ). Last value of the script should be a boolean to tell whether we should accept or reject the record.", optional=true)
    public File JAVASCRIPT_FILE = null;
    private final Log log = Log.getInstance(FilterVcf.class);
    private final ProgressLogger progress = new ProgressLogger(this.log, 100000, "Processed", "Variants");

    public FilterVcf() {
        this.CREATE_INDEX = true;
    }

    public static void main(String[] args) {
        new FilterVcf().instanceMainWithExit(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doWork() {
        int n;
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        VCFFileReader in = null;
        VariantContextWriter out = null;
        try {
            in = new VCFFileReader(this.INPUT, false);
            ArrayList<VariantFilter> variantFilters = new ArrayList<VariantFilter>(4);
            variantFilters.add(new AlleleBalanceFilter(this.MIN_AB));
            variantFilters.add(new FisherStrandFilter(this.MAX_FS));
            variantFilters.add(new QdFilter(this.MIN_QD));
            if (this.JAVASCRIPT_FILE != null) {
                try {
                    variantFilters.add(new VariantContextJavascriptFilter(this.JAVASCRIPT_FILE, in.getFileHeader()));
                }
                catch (IOException error) {
                    throw new PicardException("javascript-related error", error);
                }
            }
            List genotypeFilters = CollectionUtil.makeList((Object[])new GenotypeFilter[]{new GenotypeQualityFilter(this.MIN_GQ), new DepthFilter(this.MIN_DP)});
            FilterApplyingVariantIterator iterator = new FilterApplyingVariantIterator((Iterator<VariantContext>)in.iterator(), variantFilters, genotypeFilters);
            VCFHeader header = in.getFileHeader();
            VariantContextWriterBuilder variantContextWriterBuilder = new VariantContextWriterBuilder();
            if (this.isVcfOrBcf(this.OUTPUT)) {
                SAMSequenceDictionary sequenceDictionary = header.getSequenceDictionary();
                if (sequenceDictionary == null) {
                    throw new PicardException("The input vcf must have a sequence dictionary in order to create indexed vcf or bcfs.");
                }
                variantContextWriterBuilder.setReferenceDictionary(sequenceDictionary);
            }
            out = variantContextWriterBuilder.setOutputFile(this.OUTPUT).build();
            header.addMetaDataLine((VCFHeaderLine)new VCFFilterHeaderLine("AllGtsFiltered", "Site filtered out because all genotypes are filtered out."));
            header.addMetaDataLine((VCFHeaderLine)new VCFFormatHeaderLine("FT", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "Genotype filters."));
            for (VariantFilter filter : variantFilters) {
                filter.headerLines().forEach(arg_0 -> ((VCFHeader)header).addMetaDataLine(arg_0));
            }
            out.writeHeader(in.getFileHeader());
            while (iterator.hasNext()) {
                VariantContext vc = iterator.next();
                this.progress.record(vc.getContig(), vc.getStart());
                out.add(vc);
            }
            n = 0;
        }
        catch (Throwable throwable) {
            CloserUtil.close(out);
            CloserUtil.close(in);
            throw throwable;
        }
        CloserUtil.close((Object)out);
        CloserUtil.close((Object)in);
        return n;
    }

    private boolean isVcfOrBcf(File file) {
        String fileName = file.getName();
        return fileName.endsWith(".vcf") || fileName.endsWith(".bcf");
    }

    private static class VariantContextJavascriptFilter
    extends JavascriptVariantFilter
    implements VariantFilter {
        private final String filterName;
        private final File scriptFile;

        private VariantContextJavascriptFilter(File scriptFile, VCFHeader header) throws IOException {
            super(scriptFile, header);
            this.scriptFile = scriptFile;
            String fname = IOUtil.basename((File)scriptFile);
            if (fname.isEmpty()) {
                fname = "JSFILTER";
            }
            this.filterName = fname;
        }

        @Override
        public String filter(VariantContext ctx) {
            return super.accept((Object)ctx) ? null : this.filterName;
        }

        @Override
        public List<VCFFilterHeaderLine> headerLines() {
            return CollectionUtil.makeList((Object[])new VCFFilterHeaderLine[]{new VCFFilterHeaderLine(this.filterName, "Variant Filtered by Javascript file " + this.scriptFile)});
        }
    }
}

