/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.util.Histogram;
import picard.analysis.MergeableMetricBase;

public class DuplicationMetrics
extends MergeableMetricBase {
    @MergeableMetricBase.MergeByAssertEquals
    public String LIBRARY;
    @MergeableMetricBase.MergeByAdding
    public long UNPAIRED_READS_EXAMINED;
    @MergeableMetricBase.MergeByAdding
    public long READ_PAIRS_EXAMINED;
    @MergeableMetricBase.MergeByAdding
    public long SECONDARY_OR_SUPPLEMENTARY_RDS;
    @MergeableMetricBase.MergeByAdding
    public long UNMAPPED_READS;
    @MergeableMetricBase.MergeByAdding
    public long UNPAIRED_READ_DUPLICATES;
    @MergeableMetricBase.MergeByAdding
    public long READ_PAIR_DUPLICATES;
    @MergeableMetricBase.MergeByAdding
    public long READ_PAIR_OPTICAL_DUPLICATES;
    @MergeableMetricBase.NoMergingIsDerived
    public Double PERCENT_DUPLICATION;
    @MergeableMetricBase.NoMergingIsDerived
    public Long ESTIMATED_LIBRARY_SIZE;

    @Override
    public void calculateDerivedFields() {
        this.ESTIMATED_LIBRARY_SIZE = DuplicationMetrics.estimateLibrarySize(this.READ_PAIRS_EXAMINED - this.READ_PAIR_OPTICAL_DUPLICATES, this.READ_PAIRS_EXAMINED - this.READ_PAIR_DUPLICATES);
        this.PERCENT_DUPLICATION = (double)(this.UNPAIRED_READ_DUPLICATES + this.READ_PAIR_DUPLICATES * 2L) / (double)(this.UNPAIRED_READS_EXAMINED + this.READ_PAIRS_EXAMINED * 2L);
    }

    @Deprecated
    public void calculateDerivedMetrics() {
        this.calculateDerivedFields();
    }

    public static Long estimateLibrarySize(long readPairs, long uniqueReadPairs) {
        long readPairDuplicates = readPairs - uniqueReadPairs;
        if (readPairs > 0L && readPairDuplicates > 0L) {
            double r;
            double u;
            double m = 1.0;
            double M = 100.0;
            if (uniqueReadPairs >= readPairs || DuplicationMetrics.f(m * (double)uniqueReadPairs, uniqueReadPairs, readPairs) < 0.0) {
                throw new IllegalStateException("Invalid values for pairs and unique pairs: " + readPairs + ", " + uniqueReadPairs);
            }
            while (DuplicationMetrics.f(M * (double)uniqueReadPairs, uniqueReadPairs, readPairs) > 0.0) {
                M *= 10.0;
            }
            for (int i = 0; i < 40 && (u = DuplicationMetrics.f((r = (m + M) / 2.0) * (double)uniqueReadPairs, uniqueReadPairs, readPairs)) != 0.0; ++i) {
                if (u > 0.0) {
                    m = r;
                    continue;
                }
                if (!(u < 0.0)) continue;
                M = r;
            }
            return (long)((double)uniqueReadPairs * (m + M) / 2.0);
        }
        return null;
    }

    private static double f(double x, double c, double n) {
        return c / x - 1.0 + Math.exp(-n / x);
    }

    public static double estimateRoi(long estimatedLibrarySize, double x, long pairs, long uniquePairs) {
        return (double)estimatedLibrarySize * (1.0 - Math.exp(-(x * (double)pairs) / (double)estimatedLibrarySize)) / (double)uniquePairs;
    }

    public Histogram<Double> calculateRoiHistogram() {
        if (this.ESTIMATED_LIBRARY_SIZE == null) {
            try {
                this.calculateDerivedFields();
                if (this.ESTIMATED_LIBRARY_SIZE == null) {
                    return null;
                }
            }
            catch (IllegalStateException ise) {
                return null;
            }
        }
        long uniquePairs = this.READ_PAIRS_EXAMINED - this.READ_PAIR_DUPLICATES;
        Histogram histo = new Histogram();
        for (double x = 1.0; x <= 100.0; x += 1.0) {
            histo.increment((Comparable)Double.valueOf(x), DuplicationMetrics.estimateRoi(this.ESTIMATED_LIBRARY_SIZE, x, this.READ_PAIRS_EXAMINED, uniquePairs));
        }
        return histo;
    }

    public static void main(String[] args) {
        DuplicationMetrics m = new DuplicationMetrics();
        m.READ_PAIRS_EXAMINED = Integer.parseInt(args[0]);
        m.READ_PAIR_DUPLICATES = Integer.parseInt(args[1]);
        m.calculateDerivedFields();
        System.out.println("Percent Duplication: " + m.PERCENT_DUPLICATION);
        System.out.println("Est. Library Size  : " + m.ESTIMATED_LIBRARY_SIZE);
        System.out.println();
        System.out.println("X Seq\tX Unique");
        for (Histogram.Bin bin : m.calculateRoiHistogram().values()) {
            System.out.println(bin.getId() + "\t" + bin.getValue());
        }
    }
}

