/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.argumentcollections.ReferenceArgumentCollection;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;

@CommandLineProgramProperties(summary="Not to be confused with SortSam which sorts a SAM or BAM file with a valid sequence dictionary, ReorderSam reorders reads in a SAM/BAM file to match the contig ordering in a provided reference file, as determined by exact name matching of contigs.  Reads mapped to contigs absent in the new reference are dropped. Runs substantially faster if the input is an indexed BAM file.\nExample\n\n java -jar picard.jar ReorderSam \\\n      INPUT=sample.bam \\\n      OUTPUT=reordered.bam \\\n      REFERENCE=reference_with_different_order.fasta\n", oneLineSummary="Reorders reads in a SAM or BAM file to match ordering in a second reference file.", programGroup=ReadDataManipulationProgramGroup.class)
@DocumentedFeature
public class ReorderSam
extends CommandLineProgram {
    @Argument(shortName="I", doc="Input file (SAM or BAM) to extract reads from.")
    public File INPUT;
    @Argument(shortName="O", doc="Output file (SAM or BAM) to write extracted reads to.")
    public File OUTPUT;
    @Argument(shortName="S", doc="If true, then allows only a partial overlap of the original contigs with the new reference sequence contigs.  By default, this tool requires a corresponding contig in the new reference for each read contig")
    public boolean ALLOW_INCOMPLETE_DICT_CONCORDANCE = false;
    @Argument(shortName="U", doc="If true, then permits mapping from a read contig to a new reference contig with the same name but a different length.  Highly dangerous, only use if you know what you are doing.")
    public boolean ALLOW_CONTIG_LENGTH_DISCORDANCE = false;
    private final Log log = Log.getInstance(ReorderSam.class);

    @Override
    protected ReferenceArgumentCollection makeReferenceArgumentCollection() {
        return new ReorderSamReferenceArgumentCollection();
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsReadable((File)this.REFERENCE_SEQUENCE);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        SamReader in = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(this.INPUT);
        ReferenceSequenceFile reference = ReferenceSequenceFileFactory.getReferenceSequenceFile((File)this.REFERENCE_SEQUENCE);
        SAMSequenceDictionary refDict = reference.getSequenceDictionary();
        if (refDict == null) {
            this.log.error(new Object[]{"No reference sequence dictionary found. Aborting.  You can create a sequence dictionary for the reference fasta using CreateSequenceDictionary.jar."});
            CloserUtil.close((Object)in);
            return 1;
        }
        this.printDictionary("SAM/BAM file", in.getFileHeader().getSequenceDictionary());
        this.printDictionary("Reference", refDict);
        Map<Integer, Integer> newOrder = this.buildSequenceDictionaryMap(refDict, in.getFileHeader().getSequenceDictionary());
        SAMFileHeader outHeader = in.getFileHeader().clone();
        outHeader.setSequenceDictionary(refDict);
        this.log.info(new Object[]{"Writing reads..."});
        if (in.hasIndex()) {
            try (SAMFileWriter out = new SAMFileWriterFactory().makeSAMOrBAMWriter(outHeader, true, this.OUTPUT);){
                for (SAMSequenceRecord contig : refDict.getSequences()) {
                    SAMRecordIterator it = in.query(contig.getSequenceName(), 0, 0, false);
                    this.writeReads(out, it, newOrder, contig.getSequenceName());
                }
                this.writeReads(out, in.queryUnmapped(), newOrder, "unmapped");
            }
        }
        try (SAMFileWriter out = new SAMFileWriterFactory().makeSAMOrBAMWriter(outHeader, false, this.OUTPUT);){
            this.writeReads(out, in.iterator(), newOrder, "All reads");
        }
        CloserUtil.close((Object)in);
        return 0;
    }

    private int newOrderIndex(SAMRecord read, int oldIndex, Map<Integer, Integer> newOrder) {
        if (oldIndex == -1) {
            return -1;
        }
        Integer n = newOrder.get(oldIndex);
        if (n == null) {
            throw new PicardException("BUG: no mapping found for read " + read.getSAMString());
        }
        return n;
    }

    private void writeReads(SAMFileWriter out, SAMRecordIterator it, Map<Integer, Integer> newOrder, String name) {
        long counter = 0L;
        this.log.info(new Object[]{"  Processing " + name});
        while (it.hasNext()) {
            ++counter;
            SAMRecord read = (SAMRecord)it.next();
            int oldRefIndex = read.getReferenceIndex();
            int oldMateIndex = read.getMateReferenceIndex();
            int newRefIndex = this.newOrderIndex(read, oldRefIndex, newOrder);
            read.setHeader(out.getFileHeader());
            read.setReferenceIndex(newRefIndex);
            int newMateIndex = this.newOrderIndex(read, oldMateIndex, newOrder);
            if (oldMateIndex != -1 && newMateIndex == -1) {
                read.setMateAlignmentStart(0);
                read.setMateUnmappedFlag(true);
                read.setAttribute(SAMTag.MC.name(), null);
            }
            read.setMateReferenceIndex(newMateIndex);
            out.addAlignment(read);
        }
        it.close();
        this.log.info(new Object[]{"Wrote " + counter + " reads"});
    }

    private Map<Integer, Integer> buildSequenceDictionaryMap(SAMSequenceDictionary refDict, SAMSequenceDictionary readsDict) {
        HashMap<Integer, Integer> newOrder = new HashMap<Integer, Integer>();
        this.log.info(new Object[]{"Reordering SAM/BAM file:"});
        for (SAMSequenceRecord refRec : refDict.getSequences()) {
            SAMSequenceRecord readsRec = readsDict.getSequence(refRec.getSequenceName());
            if (readsRec == null) continue;
            if (refRec.getSequenceLength() != readsRec.getSequenceLength()) {
                String msg = String.format("Discordant contig lengths: read %s LN=%d, ref %s LN=%d", readsRec.getSequenceName(), readsRec.getSequenceLength(), refRec.getSequenceName(), refRec.getSequenceLength());
                if (this.ALLOW_CONTIG_LENGTH_DISCORDANCE) {
                    this.log.warn(new Object[]{msg});
                } else {
                    throw new PicardException(msg);
                }
            }
            this.log.info(new Object[]{String.format("  Reordering read contig %s [index=%d] to => ref contig %s [index=%d]%n", readsRec.getSequenceName(), readsRec.getSequenceIndex(), refRec.getSequenceName(), refRec.getSequenceIndex())});
            newOrder.put(readsRec.getSequenceIndex(), refRec.getSequenceIndex());
        }
        for (SAMSequenceRecord readsRec : readsDict.getSequences()) {
            if (newOrder.containsKey(readsRec.getSequenceIndex())) continue;
            if (this.ALLOW_INCOMPLETE_DICT_CONCORDANCE) {
                newOrder.put(readsRec.getSequenceIndex(), -1);
                continue;
            }
            throw new PicardException("New reference sequence does not contain a matching contig for " + readsRec.getSequenceName());
        }
        return newOrder;
    }

    private void printDictionary(String name, SAMSequenceDictionary dict) {
        this.log.info(new Object[]{name});
        for (SAMSequenceRecord contig : dict.getSequences()) {
            this.log.info(new Object[]{"  SN=%s LN=%d%n", contig.getSequenceName(), contig.getSequenceLength()});
        }
    }

    public static class ReorderSamReferenceArgumentCollection
    implements ReferenceArgumentCollection {
        @Argument(shortName="R", common=false, doc="Reference sequence to reorder reads to match.  A sequence dictionary corresponding to the reference fasta is required.  Create one with CreateSequenceDictionary.")
        public File REFERENCE;

        @Override
        public File getReferenceFile() {
            return this.REFERENCE;
        }
    }
}

