/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;

@CommandLineProgramProperties(summary="Takes a SAM or BAM file and separates all the reads into one SAM or BAM file per library name.  Reads that do not have a read group specified or whose read group does not have a library name are written to a file called 'unknown.' The format (SAM or BAM) of the  output files matches that of the input file.<br /><h4>Usage example:</h4><pre>java -jar picard.jar SplitSamByLibrary <br />      I=input_reads.bam <br />      O=/output/directory/ <br /></pre>", oneLineSummary="Splits a SAM or BAM file into individual files by library", programGroup=ReadDataManipulationProgramGroup.class)
@DocumentedFeature
public class SplitSamByLibrary
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Splits a SAM or BAM file into individual files by library";
    static final String USAGE_DETAILS = "Takes a SAM or BAM file and separates all the reads into one SAM or BAM file per library name.  Reads that do not have a read group specified or whose read group does not have a library name are written to a file called 'unknown.' The format (SAM or BAM) of the  output files matches that of the input file.<br /><h4>Usage example:</h4><pre>java -jar picard.jar SplitSamByLibrary <br />      I=input_reads.bam <br />      O=/output/directory/ <br /></pre>";
    @Argument(shortName="I", doc="The SAM or BAM file to be split. ")
    public File INPUT;
    @Argument(shortName="O", doc="The directory where the library SAM or BAM files should be written (defaults to the current directory). ", optional=true)
    public File OUTPUT = new File(".").getAbsoluteFile();
    private static final Log log = Log.getInstance(SplitSamByLibrary.class);
    public static final int NO_LIBRARIES_SPECIFIED_IN_HEADER = 2;

    public static void main(String[] args) {
        System.exit(new SplitSamByLibrary().instanceMain(args));
    }

    @Override
    protected int doWork() {
        String lib;
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertDirectoryIsWritable((File)this.OUTPUT);
        SamReader reader = SamReaderFactory.makeDefault().open(this.INPUT);
        HashMap<String, SAMFileWriter> libraryToWriter = new HashMap<String, SAMFileWriter>();
        HashMap libraryToRg = new HashMap();
        SAMFileWriterFactory factory = new SAMFileWriterFactory();
        String extension = reader.type().equals(SamReader.Type.BAM_TYPE) ? ".bam" : ".sam";
        SAMFileHeader unknownHeader = reader.getFileHeader().clone();
        unknownHeader.setReadGroups(new ArrayList());
        SAMFileWriter unknown = null;
        for (SAMReadGroupRecord sAMReadGroupRecord : reader.getFileHeader().getReadGroups()) {
            lib = sAMReadGroupRecord.getLibrary();
            if (lib != null) {
                if (!libraryToRg.containsKey(lib)) {
                    libraryToRg.put(lib, new ArrayList());
                }
                ((List)libraryToRg.get(lib)).add(sAMReadGroupRecord);
                continue;
            }
            unknownHeader.addReadGroup(sAMReadGroupRecord);
        }
        if (libraryToRg.isEmpty()) {
            log.error(new Object[]{"No individual libraries are specified in the header of " + this.INPUT.getAbsolutePath()});
            return 2;
        }
        for (Map.Entry entry : libraryToRg.entrySet()) {
            lib = (String)entry.getKey();
            SAMFileHeader header = reader.getFileHeader().clone();
            header.setReadGroups((List)entry.getValue());
            libraryToWriter.put(lib, factory.makeSAMOrBAMWriter(header, true, new File(this.OUTPUT, IOUtil.makeFileNameSafe((String)lib) + extension)));
        }
        for (SAMRecord sAMRecord : reader) {
            SAMReadGroupRecord rg = sAMRecord.getReadGroup();
            if (rg != null && rg.getLibrary() != null) {
                ((SAMFileWriter)libraryToWriter.get(rg.getLibrary())).addAlignment(sAMRecord);
                continue;
            }
            if (unknown == null) {
                unknown = factory.makeSAMOrBAMWriter(unknownHeader, true, new File(this.OUTPUT, "unknown" + extension));
            }
            unknown.addAlignment(sAMRecord);
        }
        CloserUtil.close((Object)reader);
        if (unknown != null) {
            unknown.close();
        }
        for (SAMFileWriter sAMFileWriter : libraryToWriter.values()) {
            sAMFileWriter.close();
        }
        return 0;
    }
}

